/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.Uris;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.BranchDetectingTxVerifier;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.MasterClient20;
import org.neo4j.kernel.ha.SlaveStoreWriter;
import org.neo4j.kernel.ha.StoreOutOfDateException;
import org.neo4j.kernel.ha.StoreUnableToParticipateInClusterException;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.slave.SlaveImpl;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.Logging;

public class HighAvailabilityModeSwitcher
implements HighAvailabilityMemberListener,
Lifecycle {
    private static final Class[] SERVICES_TO_RESTART_FOR_STORE_COPY = new Class[]{XaDataSourceManager.class, TxManager.class, NodeManager.class, IndexStore.class, StoreLockerLifecycleAdapter.class};
    public static final String MASTER = "master";
    public static final String SLAVE = "slave";
    private URI availableMasterId;
    private final HighAvailabilityMemberStateMachine stateHandler;
    private final DelegateInvocationHandler delegateHandler;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final GraphDatabaseAPI graphDb;
    private final Config config;
    private LifeSupport life;
    private final StringLogger msgLog;
    private final HaIdGeneratorFactory idGeneratorFactory;
    private final Logging logging;
    private final UpdateableSchemaState updateableSchemaState;

    public static int getServerId(URI haUri) {
        return (Integer)Settings.INTEGER.apply(Functions.withDefaults((Function)Functions.constant((Object)"-1"), (Function)Uris.parameter((String)"serverId")).apply((Object)haUri));
    }

    public HighAvailabilityModeSwitcher(DelegateInvocationHandler delegateHandler, ClusterMemberAvailability clusterMemberAvailability, HighAvailabilityMemberStateMachine stateHandler, GraphDatabaseAPI graphDb, HaIdGeneratorFactory idGeneratorFactory, Config config, Logging logging, UpdateableSchemaState updateableSchemaState) {
        this.delegateHandler = delegateHandler;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.graphDb = graphDb;
        this.idGeneratorFactory = idGeneratorFactory;
        this.config = config;
        this.logging = logging;
        this.updateableSchemaState = updateableSchemaState;
        this.msgLog = logging.getLogger(this.getClass());
        this.life = new LifeSupport();
        this.stateHandler = stateHandler;
    }

    public synchronized void init() throws Throwable {
        this.stateHandler.addHighAvailabilityMemberListener(this);
        this.life.init();
    }

    public synchronized void start() throws Throwable {
        this.life.start();
    }

    public synchronized void stop() throws Throwable {
        this.life.stop();
    }

    public synchronized void shutdown() throws Throwable {
        this.stateHandler.removeHighAvailabilityMemberListener(this);
        this.life.shutdown();
    }

    @Override
    public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
        this.stateChanged(event);
    }

    @Override
    public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
        this.stateChanged(event);
    }

    @Override
    public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
    }

    @Override
    public void instanceStops(HighAvailabilityMemberChangeEvent event) {
        this.stateChanged(event);
    }

    private void stateChanged(HighAvailabilityMemberChangeEvent event) {
        this.availableMasterId = event.getServerHaUri();
        if (event.getNewState() == event.getOldState()) {
            return;
        }
        switch (event.getNewState()) {
            case TO_MASTER: {
                this.life.shutdown();
                this.life = new LifeSupport();
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                }
                this.switchToMaster();
                break;
            }
            case TO_SLAVE: {
                this.life.shutdown();
                this.life = new LifeSupport();
                this.switchToSlave();
                break;
            }
            case PENDING: {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                } else if (event.getOldState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.clusterMemberAvailability.memberIsUnavailable(MASTER);
                }
                this.life.shutdown();
                this.life = new LifeSupport();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchToMaster() {
        this.msgLog.logMessage("I am " + this.config.get(HaSettings.server_id) + ", moving to master");
        try {
            MasterImpl masterImpl = new MasterImpl(this.graphDb, this.logging, this.config);
            MasterServer masterServer = new MasterServer(masterImpl, this.logging, this.serverConfig(), new BranchDetectingTxVerifier(this.graphDb));
            this.life.add((Object)masterImpl);
            this.life.add((Object)masterServer);
            this.delegateHandler.setDelegate(masterImpl);
            DependencyResolver resolver = this.graphDb.getDependencyResolver();
            HaXaDataSourceManager xaDsm = (HaXaDataSourceManager)((Object)resolver.resolveDependency(HaXaDataSourceManager.class));
            this.idGeneratorFactory.switchToMaster();
            HaXaDataSourceManager haXaDataSourceManager = xaDsm;
            synchronized (haXaDataSourceManager) {
                this.ensureDataSourceStarted(xaDsm, resolver);
            }
            this.life.start();
            URI haUri = URI.create("ha://" + masterServer.getSocketAddress().getHostName() + ":" + masterServer.getSocketAddress().getPort() + "?serverId=" + this.config.get(HaSettings.server_id));
            this.clusterMemberAvailability.memberIsAvailable(MASTER, haUri);
            this.msgLog.logMessage("I am " + this.config.get(HaSettings.server_id) + ", successfully moved to master");
        }
        catch (Throwable e) {
            this.msgLog.logMessage("Failed to switch to master", e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchToSlave() {
        int tries = 5;
        while (tries-- > 0) {
            try {
                URI masterUri = this.availableMasterId;
                this.msgLog.logMessage("I am " + this.config.get(HaSettings.server_id) + ", moving to slave for master " + masterUri);
                assert (masterUri != null);
                DependencyResolver resolver = this.graphDb.getDependencyResolver();
                HaXaDataSourceManager xaDataSourceManager = (HaXaDataSourceManager)((Object)resolver.resolveDependency(HaXaDataSourceManager.class));
                this.idGeneratorFactory.switchToSlave();
                HaXaDataSourceManager haXaDataSourceManager = xaDataSourceManager;
                synchronized (haXaDataSourceManager) {
                    if (!NeoStore.isStorePresent((FileSystemAbstraction)((FileSystemAbstraction)resolver.resolveDependency(FileSystemAbstraction.class)), (Config)this.config) && !this.copyStoreFromMaster(masterUri)) {
                        continue;
                    }
                    NeoStoreXaDataSource nioneoDataSource = this.ensureDataSourceStarted(xaDataSourceManager, resolver);
                    if (!this.checkDataConsistency(xaDataSourceManager, nioneoDataSource, masterUri)) {
                        continue;
                    }
                    if (!this.startHaCommunication(xaDataSourceManager, nioneoDataSource, masterUri)) {
                        continue;
                    }
                    this.msgLog.logMessage("I am " + this.config.get(HaSettings.server_id) + ", successfully moved to slave for master " + masterUri);
                    break;
                }
            }
            catch (Throwable t) {
                this.msgLog.logMessage("Unable to switch to slave", t);
            }
        }
    }

    private boolean startHaCommunication(HaXaDataSourceManager xaDataSourceManager, NeoStoreXaDataSource nioneoDataSource, URI masterUri) {
        try {
            MasterClient20 master = new MasterClient20(masterUri, this.logging, nioneoDataSource.getStoreId(), this.config);
            SlaveImpl slaveImpl = new SlaveImpl(nioneoDataSource.getStoreId(), master, new RequestContextFactory(HighAvailabilityModeSwitcher.getServerId(masterUri), xaDataSourceManager, this.graphDb.getDependencyResolver()), xaDataSourceManager);
            SlaveServer server = new SlaveServer(slaveImpl, this.serverConfig(), this.logging);
            this.delegateHandler.setDelegate(master);
            this.life.add((Object)master);
            this.life.add((Object)slaveImpl);
            this.life.add((Object)server);
            this.life.start();
            URI haUri = URI.create("ha://" + server.getSocketAddress().getHostName() + ":" + server.getSocketAddress().getPort() + "?serverId=" + this.config.get(HaSettings.server_id));
            this.clusterMemberAvailability.memberIsAvailable(SLAVE, haUri);
            return true;
        }
        catch (Throwable t) {
            this.msgLog.logMessage("Got exception while starting HA communication", t);
            this.life.shutdown();
            this.life = new LifeSupport();
            nioneoDataSource.stop();
            return false;
        }
    }

    private Server.Configuration serverConfig() {
        Server.Configuration serverConfig = new Server.Configuration(){

            public long getOldChannelThreshold() {
                return (Long)HighAvailabilityModeSwitcher.this.config.get(HaSettings.lock_read_timeout);
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)HighAvailabilityModeSwitcher.this.config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)HighAvailabilityModeSwitcher.this.config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)HighAvailabilityModeSwitcher.this.config.get(HaSettings.ha_server);
            }
        };
        return serverConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDataConsistency(XaDataSourceManager xaDataSourceManager, NeoStoreXaDataSource nioneoDataSource, URI masterUri) throws Throwable {
        block12: {
            LifeSupport checkConsistencyLife = new LifeSupport();
            try {
                MasterClient20 checkConsistencyMaster = new MasterClient20(masterUri, this.logging, nioneoDataSource.getStoreId(), this.config);
                checkConsistencyLife.add((Object)checkConsistencyMaster);
                checkConsistencyLife.start();
                this.checkDataConsistencyWithMaster(checkConsistencyMaster, nioneoDataSource);
                boolean bl = true;
                return bl;
            }
            catch (StoreUnableToParticipateInClusterException upe) {
                this.msgLog.warn("Current store is unable to participate in the cluster; fetching new store from master", (Throwable)upe);
                try {
                    xaDataSourceManager.unregisterDataSource("nioneodb");
                    this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)));
                }
                catch (IOException e) {
                    this.msgLog.warn("Failed while trying to handle branched data", (Throwable)e);
                }
            }
            catch (MismatchingStoreIdException e) {
                if (nioneoDataSource.getNeoStore().getLastCommittedTx() == 1L) {
                    this.msgLog.warn("Found and deleting empty store with mismatching store id " + e.getMessage());
                    this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
                    break block12;
                }
                this.msgLog.error("Store cannot participate in cluster due to mismatching store IDs");
                throw e;
            }
            catch (Throwable throwable) {
                this.msgLog.warn("Consistency checker failed", throwable);
            }
            finally {
                checkConsistencyLife.shutdown();
            }
        }
        return false;
    }

    private NeoStoreXaDataSource ensureDataSourceStarted(XaDataSourceManager xaDataSourceManager, DependencyResolver resolver) throws IOException {
        NeoStoreXaDataSource nioneoDataSource = (NeoStoreXaDataSource)xaDataSourceManager.getXaDataSource("nioneodb");
        if (nioneoDataSource == null) {
            try {
                nioneoDataSource = new NeoStoreXaDataSource(this.config, (StoreFactory)resolver.resolveDependency(StoreFactory.class), (LockManager)resolver.resolveDependency(LockManager.class), (StringLogger)resolver.resolveDependency(StringLogger.class), (XaFactory)resolver.resolveDependency(XaFactory.class), (TransactionStateFactory)resolver.resolveDependency(TransactionStateFactory.class), (CacheAccessBackDoor)resolver.resolveDependency(CacheAccessBackDoor.class), (TransactionInterceptorProviders)resolver.resolveDependency(TransactionInterceptorProviders.class), (JobScheduler)resolver.resolveDependency(JobScheduler.class), this.logging, this.updateableSchemaState, resolver);
                xaDataSourceManager.registerDataSource((XaDataSource)nioneoDataSource);
            }
            catch (IOException e) {
                this.msgLog.logMessage("Failed while trying to create datasource", (Throwable)e);
                throw e;
            }
        }
        return nioneoDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyStoreFromMaster(URI masterUri) {
        LifeSupport life = new LifeSupport();
        try {
            this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
            MasterClient20 copyMaster = new MasterClient20(masterUri, this.logging, null, this.config);
            life.add((Object)copyMaster);
            life.start();
            this.msgLog.logMessage("Copying store from master");
            new SlaveStoreWriter(this.config).copyStore(copyMaster);
            this.startServicesAgain();
            this.msgLog.logMessage("Finished copying store from master");
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.msgLog.logMessage("Failed to copy store from master", e);
        }
        finally {
            life.stop();
        }
        return false;
    }

    private void startServicesAgain() throws Throwable {
        ArrayList<Class> services = new ArrayList<Class>(Arrays.asList(SERVICES_TO_RESTART_FOR_STORE_COPY));
        Collections.reverse(services);
        for (Class serviceClass : services) {
            ((Lifecycle)this.graphDb.getDependencyResolver().resolveDependency(serviceClass)).start();
        }
    }

    private void stopServicesAndHandleBranchedStore(BranchedDataPolicy branchPolicy) throws Throwable {
        for (Class serviceClass : SERVICES_TO_RESTART_FOR_STORE_COPY) {
            ((Lifecycle)this.graphDb.getDependencyResolver().resolveDependency(serviceClass)).stop();
        }
        branchPolicy.handle((File)this.config.get(InternalAbstractGraphDatabase.Configuration.store_dir));
    }

    private void checkDataConsistencyWithMaster(Master master, NeoStoreXaDataSource nioneoDataSource) {
        Pair mastersMaster;
        Pair myMaster;
        long myLastCommittedTx = nioneoDataSource.getLastCommittedTxId();
        try {
            myMaster = nioneoDataSource.getMasterForCommittedTx(myLastCommittedTx);
        }
        catch (NoSuchLogVersionException e) {
            this.msgLog.logMessage("Logical log file for txId " + myLastCommittedTx + " missing [version=" + e.getVersion() + "]. If this is startup then it will be recovered later, " + "otherwise it might be a problem.");
            return;
        }
        catch (IOException e) {
            this.msgLog.logMessage("Failed to get master ID for txId " + myLastCommittedTx + ".", (Throwable)e);
            return;
        }
        catch (Exception e) {
            throw new BranchedDataException("Exception while getting master ID for txId " + myLastCommittedTx + ".", e);
        }
        Response<Pair<Integer, Long>> response = null;
        try {
            response = master.getMasterIdForCommittedTx(myLastCommittedTx, nioneoDataSource.getStoreId());
            mastersMaster = (Pair)response.response();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MissingLogDataException) {
                throw new StoreOutOfDateException("The master is missing the log required to complete the consistency check", e.getCause());
            }
            throw e;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        if ((Integer)myMaster.first() != -1 && !myMaster.equals((Object)mastersMaster)) {
            String msg = "Branched data, I (machineId:" + this.config.get(HaSettings.server_id) + ") think machineId for" + " txId (" + myLastCommittedTx + ") is " + myMaster + ", but master (machineId:" + HighAvailabilityModeSwitcher.getServerId(this.availableMasterId) + ") says that it's " + mastersMaster;
            throw new BranchedDataException(msg);
        }
        this.msgLog.logMessage("Master id for last committed tx ok with highestTxId=" + myLastCommittedTx + " with masterId=" + myMaster, true);
    }
}

