/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.Uris;
import org.neo4j.helpers.collection.MapUtil;

public class ClusterMember {
    private final URI clusterUri;
    private final Map<String, URI> roles;
    private final boolean alive;

    public ClusterMember(URI clusterUri) {
        this(clusterUri, Collections.emptyMap(), true);
    }

    ClusterMember(URI clusterUri, Map<String, URI> roles, boolean alive) {
        this.clusterUri = clusterUri;
        this.roles = roles;
        this.alive = alive;
    }

    public URI getClusterUri() {
        return this.clusterUri;
    }

    public int getInstanceId() {
        URI haURI = this.getHAUri();
        if (haURI != null) {
            return (Integer)Settings.INTEGER.apply(Functions.withDefaults((Function)Functions.constant((Object)"-1"), (Function)Uris.parameter((String)"serverId")).apply((Object)haURI));
        }
        return -1;
    }

    public URI getHAUri() {
        URI haURI = this.roles.get("master");
        if (haURI == null) {
            haURI = this.roles.get("slave");
        }
        return haURI;
    }

    public String getHARole() {
        if (this.roles.containsKey("master")) {
            return "master";
        }
        if (this.roles.containsKey("slave")) {
            return "slave";
        }
        return "UNKNOWN";
    }

    public boolean hasRole(String role) {
        return this.roles.containsKey(role);
    }

    public URI getRoleURI(String role) {
        return this.roles.get(role);
    }

    public Iterable<String> getRoles() {
        return this.roles.keySet();
    }

    public Iterable<URI> getRoleURIs() {
        return this.roles.values();
    }

    public boolean isAlive() {
        return this.alive;
    }

    ClusterMember availableAs(String role, URI roleUri) {
        return new ClusterMember(this.clusterUri, MapUtil.copyAndPut(this.roles, (Object)role, (Object)roleUri), this.alive);
    }

    ClusterMember unavailableAs(String role) {
        return new ClusterMember(this.clusterUri, MapUtil.copyAndRemove(this.roles, (Object)role), this.alive);
    }

    ClusterMember alive() {
        return new ClusterMember(this.clusterUri, this.roles, true);
    }

    ClusterMember failed() {
        return new ClusterMember(this.clusterUri, this.roles, false);
    }

    public String toString() {
        return String.format("cluster URI=%s, alive=%s, roles=%s", this.clusterUri.toString(), this.alive, this.roles.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterMember that = (ClusterMember)o;
        return this.clusterUri.equals(that.clusterUri);
    }

    public int hashCode() {
        return this.clusterUri.hashCode();
    }
}

