/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class ClusterMembers {
    public static final Predicate<ClusterMember> ALIVE = new Predicate<ClusterMember>(){

        public boolean accept(ClusterMember item) {
            return item.isAlive();
        }
    };
    private URI clusterUri;
    private final Map<URI, ClusterMember> members = new CopyOnWriteHashMap();

    public static Predicate<ClusterMember> inRole(final String role) {
        return new Predicate<ClusterMember>(){

            public boolean accept(ClusterMember item) {
                return item.hasRole(role);
            }
        };
    }

    public ClusterMembers(Cluster cluster, BindingNotifier binding, Heartbeat heartbeat, ClusterMemberEvents clusterMemberEvents) {
        cluster.addClusterListener((ClusterListener)new HAMClusterListener());
        heartbeat.addHeartbeatListener((HeartbeatListener)new HAMHeartbeatListener());
        clusterMemberEvents.addClusterMemberListener((ClusterMemberListener)new HAMClusterMemberListener());
        binding.addBindingListener((BindingListener)new HAMBindingListener());
    }

    public Iterable<ClusterMember> getMembers() {
        return this.members.values();
    }

    public ClusterMember getSelf() {
        for (ClusterMember clusterMember : this.getMembers()) {
            if (!clusterMember.getClusterUri().equals(this.clusterUri)) continue;
            return clusterMember;
        }
        return null;
    }

    private ClusterMember getMember(URI server) {
        ClusterMember clusterMember = this.members.get(server);
        if (clusterMember == null) {
            throw new IllegalStateException("Member " + server + " not found in " + this.members);
        }
        return clusterMember;
    }

    private class HAMBindingListener
    implements BindingListener {
        private HAMBindingListener() {
        }

        public void listeningAt(URI me) {
            ClusterMembers.this.clusterUri = me;
        }
    }

    private class HAMHeartbeatListener
    extends HeartbeatListener.Adapter {
        private HAMHeartbeatListener() {
        }

        public void failed(URI server) {
            ClusterMembers.this.members.put(server, ClusterMembers.this.getMember(server).failed());
        }

        public void alive(URI server) {
            ClusterMembers.this.members.put(server, ClusterMembers.this.getMember(server).alive());
        }
    }

    private class HAMClusterMemberListener
    extends ClusterMemberListener.Adapter {
        private URI masterURI = null;

        private HAMClusterMemberListener() {
        }

        public void masterIsElected(URI masterUri) {
            if (masterUri.equals(this.masterURI)) {
                return;
            }
            this.masterURI = masterUri;
            CopyOnWriteHashMap newMembers = new CopyOnWriteHashMap();
            for (Map.Entry memberEntry : ClusterMembers.this.members.entrySet()) {
                newMembers.put(memberEntry.getKey(), ((ClusterMember)memberEntry.getValue()).unavailableAs("master").unavailableAs("slave"));
            }
            ClusterMembers.this.members.clear();
            ClusterMembers.this.members.putAll(newMembers);
        }

        public void memberIsAvailable(String role, URI instanceClusterUri, URI roleUri) {
            ClusterMembers.this.members.put(instanceClusterUri, ClusterMembers.this.getMember(instanceClusterUri).availableAs(role, roleUri));
        }

        public void memberIsUnavailable(String role, URI instanceClusterUri) {
            ClusterMember member = null;
            try {
                member = ClusterMembers.this.getMember(instanceClusterUri);
                ClusterMembers.this.members.put(instanceClusterUri, member.unavailableAs(role));
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
    }

    private class HAMClusterListener
    extends ClusterListener.Adapter {
        private HAMClusterListener() {
        }

        public void enteredCluster(ClusterConfiguration configuration) {
            HashMap<URI, ClusterMember> newMembers = new HashMap<URI, ClusterMember>();
            for (URI memberClusterUri : configuration.getMembers()) {
                newMembers.put(memberClusterUri, new ClusterMember(memberClusterUri));
            }
            ClusterMembers.this.members.clear();
            ClusterMembers.this.members.putAll(newMembers);
        }

        public void leftCluster() {
            ClusterMembers.this.members.clear();
        }

        public void joinedCluster(URI member) {
            ClusterMembers.this.members.put(member, new ClusterMember(member));
        }

        public void leftCluster(URI member) {
            ClusterMembers.this.members.remove(member);
        }
    }
}

