/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.zoo;

import java.net.URI;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.helpers.Listeners;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.cluster.zoo.ZooClient;
import org.neo4j.kernel.ha.cluster.zoo.ZooListener;
import org.neo4j.kernel.ha.switchover.CompatibilityModeListener;
import org.neo4j.kernel.ha.switchover.Switchover;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.Logging;

public class ZooKeeperHighAvailabilityEvents
implements ClusterMemberEvents,
ClusterMemberAvailability,
BindingNotifier,
Lifecycle {
    private ZooClient client;
    private final Logging logger;
    private final Config config;
    private final Switchover switchover;
    private final int serverId;
    private Iterable<ClusterMemberListener> haListeners = Listeners.newListeners();
    private Iterable<BindingListener> bindingListeners = Listeners.newListeners();
    private final LifeSupport life;

    public ZooKeeperHighAvailabilityEvents(Logging logger, Config config, Switchover switchover) {
        this.logger = logger;
        this.config = config;
        this.switchover = switchover;
        this.life = new LifeSupport();
        this.serverId = (Integer)config.get(HaSettings.server_id);
    }

    public void init() throws Throwable {
        this.client = new ZooClient(this.logger.getLogger(ZooClient.class), this.config);
        this.life.add((Object)this.client);
        this.client.addZooListener(new ZooHaEventListener());
        this.client.addCompatibilityModeListener(new ZooCompatibilityModeListener());
        this.life.init();
    }

    public void start() throws Throwable {
        this.life.start();
        Listeners.notifyListeners(this.bindingListeners, (Listeners.Notification)new Listeners.Notification<BindingListener>(){

            public void notify(BindingListener listener) {
                listener.listeningAt(URI.create(ZooKeeperHighAvailabilityEvents.this.client.getClusterServer()));
            }
        });
        this.client.refreshMasterFromZooKeeper();
        Listeners.notifyListeners(this.haListeners, (Listeners.Notification)new Listeners.Notification<ClusterMemberListener>(){

            public void notify(ClusterMemberListener listener) {
                listener.masterIsElected(URI.create("cluster://" + ZooKeeperHighAvailabilityEvents.this.client.getCachedMaster().getServerAsString()));
            }
        });
        Listeners.notifyListeners(this.haListeners, (Listeners.Notification)new Listeners.Notification<ClusterMemberListener>(){

            public void notify(ClusterMemberListener listener) {
                listener.memberIsAvailable("master", URI.create("cluster://" + ZooKeeperHighAvailabilityEvents.this.client.getCachedMaster().getServerAsString()), URI.create("ha://" + ZooKeeperHighAvailabilityEvents.this.client.getCachedMaster().getServerAsString()));
            }
        });
    }

    public void stop() throws Throwable {
        this.life.stop();
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    public void memberIsAvailable(final String role, final URI roleUri) {
        Listeners.notifyListeners(this.haListeners, (Listeners.Notification)new Listeners.Notification<ClusterMemberListener>(){

            public void notify(ClusterMemberListener listener) {
                ZooKeeperHighAvailabilityEvents.this.logger.getLogger(this.getClass()).logMessage("got member is available for me: " + ZooKeeperHighAvailabilityEvents.this.client.getClusterServer());
                listener.memberIsAvailable(role, URI.create(ZooKeeperHighAvailabilityEvents.this.client.getClusterServer()), roleUri);
            }
        });
    }

    public void addClusterMemberListener(ClusterMemberListener listener) {
        this.haListeners = Listeners.addListener((Object)listener, this.haListeners);
    }

    public void removeClusterMemberListener(ClusterMemberListener listener) {
        this.haListeners = Listeners.removeListener((Object)listener, this.haListeners);
    }

    public void addBindingListener(BindingListener listener) {
        this.bindingListeners = Listeners.addListener((Object)listener, this.bindingListeners);
    }

    public void removeBindingListener(BindingListener listener) {
        this.bindingListeners = Listeners.removeListener((Object)listener, this.bindingListeners);
    }

    public void memberIsUnavailable(String role) {
    }

    private class ZooCompatibilityModeListener
    implements CompatibilityModeListener {
        private ZooCompatibilityModeListener() {
        }

        @Override
        public void leftCompatibilityMode() {
            ZooKeeperHighAvailabilityEvents.this.switchover.doSwitchover();
        }
    }

    private class ZooHaEventListener
    implements ZooListener {
        private ZooHaEventListener() {
        }

        @Override
        public void newMasterRequired() {
            ZooKeeperHighAvailabilityEvents.this.logger.getLogger(this.getClass()).logMessage("Refreshing master from zk, got " + ZooKeeperHighAvailabilityEvents.this.client.refreshMasterFromZooKeeper());
        }

        @Override
        public void reconnect() {
            try {
                ZooKeeperHighAvailabilityEvents.this.stop();
                ZooKeeperHighAvailabilityEvents.this.start();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public void masterNotify() {
            ZooKeeperHighAvailabilityEvents.this.logger.getLogger(this.getClass()).logMessage("Got master notify");
            Listeners.notifyListeners((Iterable)ZooKeeperHighAvailabilityEvents.this.haListeners, (Listeners.Notification)new Listeners.Notification<ClusterMemberListener>(){

                public void notify(ClusterMemberListener listener) {
                    listener.masterIsElected(URI.create(ZooKeeperHighAvailabilityEvents.this.client.getCachedMaster().getServerAsString()));
                }
            });
        }

        @Override
        public void masterRebound() {
            ZooKeeperHighAvailabilityEvents.this.logger.getLogger(this.getClass()).logMessage("Got master rebound");
            Listeners.notifyListeners((Iterable)ZooKeeperHighAvailabilityEvents.this.haListeners, (Listeners.Notification)new Listeners.Notification<ClusterMemberListener>(){

                public void notify(ClusterMemberListener listener) {
                    listener.memberIsAvailable("master", URI.create("cluster://" + ZooKeeperHighAvailabilityEvents.this.client.getCachedMaster().getServerAsString()), URI.create("ha://" + ZooKeeperHighAvailabilityEvents.this.client.getCachedMaster().getServerAsString()));
                }
            });
        }
    }
}

