/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.management;

import javax.management.NotCompliantMBeanException;
import org.neo4j.helpers.Format;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.management.HighlyAvailableKernelData;
import org.neo4j.management.ClusterMemberInfo;
import org.neo4j.management.HighAvailability;

public final class HighAvailabilityBean
extends ManagementBeanProvider {
    public HighAvailabilityBean() {
        super(HighAvailability.class);
    }

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        if (!HighAvailabilityBean.isHA(management)) {
            return null;
        }
        return new HighAvailabilityImpl(management, true);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        if (!HighAvailabilityBean.isHA(management)) {
            return null;
        }
        return new HighAvailabilityImpl(management);
    }

    private static boolean isHA(ManagementData management) {
        return management.getKernelData().graphDatabase() instanceof HighlyAvailableGraphDatabase;
    }

    private static class HighAvailabilityImpl
    extends Neo4jMBean
    implements HighAvailability {
        private final HighlyAvailableKernelData kernelData;

        HighAvailabilityImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.kernelData = (HighlyAvailableKernelData)management.getKernelData();
        }

        HighAvailabilityImpl(ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            this.kernelData = (HighlyAvailableKernelData)management.getKernelData();
        }

        public String getInstanceId() {
            return Integer.toString(this.kernelData.getMemberInfo().getServerId());
        }

        public ClusterMemberInfo[] getInstancesInCluster() {
            return this.kernelData.getClusterInfo();
        }

        public String getRole() {
            return this.kernelData.getMemberInfo().getHaRole();
        }

        public boolean isAvailable() {
            return this.kernelData.getMemberInfo().isAvailable();
        }

        public boolean isAlive() {
            return this.kernelData.getMemberInfo().isAlive();
        }

        public String getLastUpdateTime() {
            long lastUpdateTime = this.kernelData.getMemberInfo().getLastUpdateTime();
            return lastUpdateTime == 0L ? "N/A" : Format.date((long)lastUpdateTime);
        }

        public long getLastCommittedTxId() {
            return this.kernelData.getMemberInfo().getLastCommittedTxId();
        }

        public String update() {
            long time = System.currentTimeMillis();
            try {
                ((UpdatePuller)this.kernelData.graphDatabase().getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
            }
            catch (Exception e) {
                return "Update failed: " + e;
            }
            time = System.currentTimeMillis() - time;
            return "Update completed in " + time + "ms";
        }
    }
}

