/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.GCResistantCache;
import org.neo4j.kernel.impl.cache.GcrSettings;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;

public class GCResistantCacheProvider
extends CacheProvider {
    public static final String NAME = "gcr";

    public GCResistantCacheProvider() {
        super(NAME, "GC resistant cache");
    }

    public Cache<NodeImpl> newNodeCache(StringLogger logger, Config config) {
        Long rel;
        Long node = (Long)config.get(GcrSettings.node_cache_size);
        if (node == null) {
            node = Runtime.getRuntime().maxMemory() / 4L;
        }
        if ((rel = (Long)config.get(GcrSettings.relationship_cache_size)) == null) {
            rel = Runtime.getRuntime().maxMemory() / 4L;
        }
        this.checkMemToUse(logger, node, rel, Runtime.getRuntime().maxMemory());
        return new GCResistantCache<NodeImpl>(node, ((Float)config.get(GcrSettings.node_cache_array_fraction)).floatValue(), (Long)config.get(GcrSettings.log_interval), "NodeCache", logger);
    }

    public Cache<RelationshipImpl> newRelationshipCache(StringLogger logger, Config config) {
        Long rel;
        Long node = (Long)config.get(GcrSettings.node_cache_size);
        if (node == null) {
            node = Runtime.getRuntime().maxMemory() / 4L;
        }
        if ((rel = (Long)config.get(GcrSettings.relationship_cache_size)) == null) {
            rel = Runtime.getRuntime().maxMemory() / 4L;
        }
        this.checkMemToUse(logger, node, rel, Runtime.getRuntime().maxMemory());
        return new GCResistantCache<RelationshipImpl>(rel, ((Float)config.get(GcrSettings.relationship_cache_array_fraction)).floatValue(), (Long)config.get(GcrSettings.log_interval), "RelationshipCache", logger);
    }

    private void checkMemToUse(StringLogger logger, long node, long rel, long available) {
        long advicedMax = available / 2L;
        long total = 0L;
        node = Math.max(1L, node);
        total += node;
        if ((total += (rel = Math.max(1L, rel))) > available) {
            throw new IllegalArgumentException(String.format("Configured cache memory limits (node=%s, relationship=%s, total=%s) exceeds available heap space (%s)", node, rel, total, available));
        }
        if (total > advicedMax) {
            logger.logMessage(String.format("Configured cache memory limits(node=%s, relationship=%s, total=%s) exceeds recommended limit (%s)", node, rel, total, advicedMax));
        }
    }

    public Class getSettingsClass() {
        return GcrSettings.class;
    }
}

