/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.index;

import java.util.HashMap;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.ha.BeginTx;
import org.neo4j.ha.FinishTx;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.OtherThreadExecutor;

public class IndexOperationsIT
extends AbstractClusterTest {
    @Test
    public void index_modifications_are_propagated() throws Exception {
        String key = "name";
        String value = "Mattias";
        HighlyAvailableGraphDatabase author = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long node = this.createNode(author, key, value, true);
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            ((UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
            this.assertNodeAndIndexingExists(db, node, key, value);
        }
    }

    @Test
    public void index_objects_can_be_reused_after_role_switch() throws Exception {
        String key = "key";
        String value = "value";
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        long nodeId = this.createNode(master, key, value, true);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HashMap<HighlyAvailableGraphDatabase, IndexManager> indexManagers = new HashMap<HighlyAvailableGraphDatabase, IndexManager>();
        HashMap<HighlyAvailableGraphDatabase, Index> indexes = new HashMap<HighlyAvailableGraphDatabase, Index>();
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            indexManagers.put(db, db.index());
            indexes.put(db, db.index().forNodes(key));
        }
        this.cluster.shutdown(master);
        indexManagers.remove(master);
        indexes.remove(master);
        for (IndexManager indexManager : indexManagers.values()) {
            Assert.assertTrue((boolean)indexManager.existsForNodes(key));
            Assert.assertEquals((long)nodeId, (long)((Node)indexManager.forNodes(key).get(key, (Object)value).getSingle()).getId());
        }
        for (Index index : indexes.values()) {
            Assert.assertEquals((long)nodeId, (long)((Node)index.get(key, (Object)value).getSingle()).getId());
        }
    }

    @Test
    public void put_if_absent_works_across_instances() throws Exception {
        String key = "key";
        String value = "value";
        HighlyAvailableGraphDatabase db1 = this.cluster.getMaster();
        HighlyAvailableGraphDatabase db2 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long node = this.createNode(db1, key, value, false);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        OtherThreadExecutor w1 = new OtherThreadExecutor("w1", (Object)db1);
        OtherThreadExecutor w2 = new OtherThreadExecutor("w2", (Object)db2);
        Transaction tx1 = (Transaction)w1.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
        Transaction tx2 = (Transaction)w2.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
        Assert.assertNull((Object)w2.execute((OtherThreadExecutor.WorkerCommand)new PutIfAbsent(node, key, value)));
        Future w1Future = w1.executeDontWait((OtherThreadExecutor.WorkerCommand)new PutIfAbsent(node, key, value));
        w1.waitUntilWaiting();
        w2.execute((OtherThreadExecutor.WorkerCommand)new FinishTx(tx2, true));
        tx2.success();
        tx2.finish();
        Assert.assertNotNull(w1Future.get());
        w1.execute((OtherThreadExecutor.WorkerCommand)new FinishTx(tx1, true));
        this.assertNodeAndIndexingExists(db1, node, key, value);
        this.assertNodeAndIndexingExists(db2, node, key, value);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertNodeAndIndexingExists(this.cluster.getAnySlave(db1, db2), node, key, value);
        w2.shutdown();
        w1.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNode(HighlyAvailableGraphDatabase author, String key, Object value, boolean index) {
        Transaction tx = author.beginTx();
        try {
            Node node = author.createNode();
            node.setProperty(key, value);
            if (index) {
                author.index().forNodes(key).add((PropertyContainer)node, key, value);
            }
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    private void assertNodeAndIndexingExists(HighlyAvailableGraphDatabase db, long nodeId, String key, Object value) {
        Node node = db.getNodeById(nodeId);
        Assert.assertEquals((Object)value, (Object)node.getProperty(key));
        Assert.assertTrue((boolean)db.index().existsForNodes(key));
        Assert.assertEquals((Object)node, (Object)db.index().forNodes(key).get(key, value).getSingle());
    }

    private static class PutIfAbsent
    implements OtherThreadExecutor.WorkerCommand<HighlyAvailableGraphDatabase, Node> {
        private final long node;
        private final String key;
        private final String value;

        public PutIfAbsent(long node, String key, String value) {
            this.node = node;
            this.key = key;
            this.value = value;
        }

        public Node doWork(HighlyAvailableGraphDatabase state) {
            return (Node)state.index().forNodes(this.key).putIfAbsent((PropertyContainer)state.getNodeById(this.node), this.key, (Object)this.value);
        }
    }
}

