/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;

public class InstanceAccessGuard {
    private volatile CountDownLatch latch;

    public InstanceAccessGuard() {
        this.enter();
    }

    private synchronized void enter() {
        if (this.latch != null) {
            return;
        }
        this.latch = new CountDownLatch(1);
    }

    public boolean await(long millis) {
        CountDownLatch localLatch = this.latch;
        if (localLatch == null) {
            return true;
        }
        try {
            return localLatch.await(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private synchronized void exit() {
        if (this.latch == null) {
            return;
        }
        this.latch.countDown();
        this.latch = null;
    }

    public void setState(HighAvailabilityMemberState state) {
        if (state.isAccessAllowed(null)) {
            this.exit();
        } else {
            this.enter();
        }
    }
}

