/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcessTestRunner;

@ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.com.Client", method="makeSureNextTransactionIsFullyFetched", on=BreakPoint.Event.ENTRY), @ForeignBreakpoints.BreakpointDef(type="org.neo4j.com.DechunkingChannelBuffer", method="readNextChunk", on=BreakPoint.Event.EXIT)})
@RunWith(value=SubProcessTestRunner.class)
@Ignore(value="This test depends on chuncked requests, otherwise it will hang. So either reduce the Protocol.DEFAULT_FRAME_LENGTH to 1024or create a huge difference in the stores between master and slave which will lead to a multichunk response.")
public class TestClientThreadIsolation {
    private static DebuggedThread txCopyingThread;
    private static DebuggedThread interferingThread;
    private static CountDownLatch latch;

    @Test
    @EnabledBreakpoints(value={"makeSureNextTransactionIsFullyFetched", "readNextChunk", "waitTxCopyToStart", "finish"})
    public void testTransactionsPulled() throws Exception {
        HighlyAvailableGraphDatabase master = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(TargetDirectory.forTest(TestClientThreadIsolation.class).directory("master", true).getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").newGraphDatabase();
        HighlyAvailableGraphDatabase slave1 = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(TargetDirectory.forTest(TestClientThreadIsolation.class).directory("slave1", true).getAbsolutePath()).setConfig(ClusterSettings.cluster_server, "127.0.0.1:5002").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.max_concurrent_channels_per_slave, "2").setConfig(HaSettings.ha_server, "127.0.0.1:8001").newGraphDatabase();
        Transaction masterTx = master.beginTx();
        master.createNode().createRelationshipTo(master.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"master")).setProperty("largeArray", (Object)new int[20000]);
        masterTx.success();
        masterTx.finish();
        Thread thread1 = new Thread(new Runnable(){

            @Override
            public void run() {
            }
        }, "thread 1");
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
            }
        }, "thread 2");
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        Assert.assertTrue((boolean)master.getReferenceNode().getRelationships(new RelationshipType[]{DynamicRelationshipType.withName((String)"test")}).iterator().hasNext());
    }

    @BreakpointTrigger(value="waitTxCopyToStart")
    private void waitTxCopyToStart() {
    }

    @BreakpointTrigger(value="finish")
    private void finish() {
    }

    @BreakpointHandler(value={"waitTxCopyToStart"})
    public static void onWaitTxCopyToStart(BreakPoint self, DebugInterface di) {
        interferingThread = di.thread().suspend(null);
        latch.countDown();
    }

    @BreakpointHandler(value={"finish"})
    public static void onFinish(BreakPoint self, DebugInterface di) {
        txCopyingThread.resume();
    }

    @BreakpointHandler(value={"makeSureNextTransactionIsFullyFetched"})
    public static void onStartingStoreCopy(BreakPoint self, DebugInterface di, @BreakpointHandler(value={"readNextChunk"}) BreakPoint onReadNextChunk) throws Exception {
        latch.await();
        txCopyingThread = di.thread();
        self.disable();
    }

    @BreakpointHandler(value={"readNextChunk"})
    public static void onReadNextChunk(BreakPoint self, DebugInterface di) throws Exception {
        if (txCopyingThread != null && di.thread().name().equals(txCopyingThread.name())) {
            txCopyingThread.suspend(null);
            interferingThread.resume();
            self.disable();
        }
    }

    static {
        latch = new CountDownLatch(1);
    }
}

