/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TestSlaveOnlyCluster {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterElectionAfterMasterRecoversInSlaveOnlyCluster() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).directory("testCluster", true), MapUtil.stringMap((String[])new String[0]), MapUtil.genericMap((Object[])new Object[]{2, MapUtil.stringMap((String[])new String[]{HaSettings.slave_only.name(), "true"}), 3, MapUtil.stringMap((String[])new String[]{HaSettings.slave_only.name(), "true"})}));
        try {
            clusterManager.start();
            final CountDownLatch failedLatch = new CountDownLatch(2);
            final CountDownLatch electedLatch = new CountDownLatch(2);
            HeartbeatListener masterDownListener = new HeartbeatListener(){

                public void failed(InstanceId server) {
                    failedLatch.countDown();
                }

                public void alive(InstanceId server) {
                }
            };
            for (HighlyAvailableGraphDatabase highlyAvailableGraphDatabase : clusterManager.getDefaultCluster().getAllMembers()) {
                if (highlyAvailableGraphDatabase.isMaster()) continue;
                ((ClusterClient)highlyAvailableGraphDatabase.getDependencyResolver().resolveDependency(ClusterClient.class)).addHeartbeatListener(masterDownListener);
                ((ClusterClient)highlyAvailableGraphDatabase.getDependencyResolver().resolveDependency(ClusterClient.class)).addClusterListener((ClusterListener)new ClusterListener.Adapter(){

                    public void elected(String role, InstanceId electedMember, URI availableAtUri) {
                        electedLatch.countDown();
                    }
                });
            }
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            ClusterManager.RepairKit repairKit = clusterManager.getDefaultCluster().fail(master);
            failedLatch.await();
            repairKit.repair();
            electedLatch.await();
            HighlyAvailableGraphDatabase slaveDatabase = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            Transaction tx = slaveDatabase.beginTx();
            Node node = slaveDatabase.createNode();
            node.setProperty("foo", (Object)"bar");
            long nodeId = node.getId();
            tx.success();
            tx.finish();
            node = master.getNodeById(nodeId);
            Assert.assertThat((Object)node.getProperty("foo").toString(), (Matcher)CoreMatchers.equalTo((Object)"bar"));
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterElectionAfterSlaveOnlyInstancesStartFirst() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).directory("testCluster", true), MapUtil.stringMap((String[])new String[0]), MapUtil.genericMap((Object[])new Object[]{1, MapUtil.stringMap((String[])new String[]{HaSettings.slave_only.name(), "true"}), 2, MapUtil.stringMap((String[])new String[]{HaSettings.slave_only.name(), "true"})}));
        try {
            clusterManager.start();
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            Assert.assertThat((Object)clusterManager.getDefaultCluster().getServerId(master), (Matcher)CoreMatchers.equalTo((Object)3));
        }
        finally {
            clusterManager.stop();
        }
    }
}

