/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TargetDirectory;

@Ignore(value="Need to properly setup instances with priorities such that slave only instances are present")
public class TestTxPush {
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterCapableIsAheadOfSlaveOnlyRegardlessOfPriority() throws Exception {
        Object master = null;
        Object slave1 = null;
        Object slave2 = null;
        try {
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            long nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
            tx.finish();
            try {
                slave1.getNodeById(nodeId);
                Assert.fail((String)"It shouldn't be in the slave only instance");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            Assert.assertEquals((Object)"bar", (Object)slave2.getNodeById(nodeId).getProperty("foo"));
        }
        finally {
            if (slave2 != null) {
                slave2.shutdown();
            }
            if (slave1 != null) {
                slave1.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlaveOnlyWillNotGetPushedAtToMeetQuota() throws Exception {
        Object master = null;
        Object slave1 = null;
        Object slave2 = null;
        try {
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            long nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
            tx.finish();
            try {
                slave1.getNodeById(nodeId);
                Assert.fail((String)"It shouldn't be in the slave only instance");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            Assert.assertEquals((Object)"bar", (Object)slave2.getNodeById(nodeId).getProperty("foo"));
        }
        finally {
            if (slave2 != null) {
                slave2.shutdown();
            }
            if (slave1 != null) {
                slave1.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }
}

