/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.HighAvailabilitySlaves;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlaveFactory;

public class HighAvailabilitySlavesTest {
    private static InstanceId instanceId1 = new InstanceId(1);
    private static URI clusterUri1 = URI.create("cluster://server1");
    private static URI haUri1 = URI.create("ha://server1?serverId=" + instanceId1.toIntegerIndex());
    private static InstanceId instanceId2 = new InstanceId(2);
    private static URI clusterUri2 = URI.create("cluster://server2");
    private static URI haUri2 = URI.create("ha://server2?serverId=" + instanceId2.toIntegerIndex());
    private static InstanceId instanceId3 = new InstanceId(3);
    private static URI clusterUri3 = URI.create("cluster://server3");
    private static URI haUri3 = URI.create("ha://server3?serverId=" + instanceId3.toIntegerIndex());

    @Test
    public void shouldRegisterItselfOnMonitors() throws Throwable {
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory).init();
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)Mockito.any());
    }

    @Test
    public void shouldNotReturnUnavailableSlaves() throws Throwable {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn((Object)Iterables.iterable((Object[])new ClusterMember[]{new ClusterMember(instanceId1)}));
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        HighAvailabilitySlaves slaves = new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory);
        slaves.init();
        Iterable memberSlaves = slaves.getSlaves();
        Assert.assertThat((Object)Iterables.count((Iterable)memberSlaves), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldNotReturnAvailableButFailedSlaves() throws Throwable {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn((Object)Iterables.iterable((Object[])new ClusterMember[]{new ClusterMember(instanceId1).availableAs("SLAVE", haUri1).failed()}));
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        HighAvailabilitySlaves slaves = new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory);
        slaves.init();
        Iterable memberSlaves = slaves.getSlaves();
        Assert.assertThat((Object)Iterables.count((Iterable)memberSlaves), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldReturnAvailableAndAliveSlaves() throws Throwable {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn((Object)Iterables.iterable((Object[])new ClusterMember[]{new ClusterMember(instanceId1).availableAs("slave", haUri1)}));
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        Mockito.when((Object)slaveFactory.newSlave((ClusterMember)Matchers.any())).thenReturn(Mockito.mock(Slave.class));
        HighAvailabilitySlaves slaves = new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory);
        slaves.init();
        Iterable memberSlaves = slaves.getSlaves();
        Assert.assertThat((Object)Iterables.count((Iterable)memberSlaves), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldClearSlavesWhenNewMasterElected() throws Throwable {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn((Object)Iterables.iterable((Object[])new ClusterMember[]{new ClusterMember(instanceId1).availableAs("slave", haUri1)}));
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        Mockito.when((Object)slaveFactory.newSlave((ClusterMember)Matchers.any())).thenReturn(Mockito.mock(Slave.class), (Object[])new Slave[]{(Slave)Mockito.mock(Slave.class)});
        HighAvailabilitySlaves slaves = new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory);
        slaves.init();
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        Slave slave1 = (Slave)slaves.getSlaves().iterator().next();
        ((ClusterListener)listener.getValue()).elected("coordinator", instanceId1, clusterUri2);
        Slave slave2 = (Slave)slaves.getSlaves().iterator().next();
        Assert.assertThat((Object)slave2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)slave1)));
    }
}

