/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.ServerUtil;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.test.TargetDirectory;

public class TestInstanceJoin {
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void makeSureSlaveCanJoinEvenIfTooFarBackComparedToMaster() throws Exception {
        String key = "foo";
        String value = "bar";
        HighlyAvailableGraphDatabase master = null;
        HighlyAvailableGraphDatabase slave = null;
        try {
            master = TestInstanceJoin.start(this.dir.directory("master", true).getAbsolutePath(), 0, MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.keep_logical_logs.name(), "1 files", ClusterSettings.initial_hosts.name(), "127.0.0.1:5001"}));
            this.createNode(master, "something", "unimportant");
            slave = TestInstanceJoin.start(this.dir.directory("slave", true).getAbsolutePath(), 1, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), "127.0.0.1:5001,127.0.0.1:5002"}));
            slave.shutdown();
            long nodeId = this.createNode(master, key, value);
            this.createNode(master, "something", "unimportant");
            ServerUtil.rotateLogs((GraphDatabaseAPI)master);
            master.shutdown();
            master = TestInstanceJoin.start(this.dir.directory("master", false).getAbsolutePath(), 0, MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.keep_logical_logs.name(), "1 files", ClusterSettings.initial_hosts.name(), "127.0.0.1:5001"}));
            slave = TestInstanceJoin.start(this.dir.directory("slave", false).getAbsolutePath(), 1, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), "127.0.0.1:5001,127.0.0.1:5002"}));
            ((UpdatePuller)slave.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
            Assert.assertEquals((String)"store contents differ", (Object)value, (Object)slave.getNodeById(nodeId).getProperty(key));
        }
        finally {
            if (slave != null) {
                slave.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private long createNode(HighlyAvailableGraphDatabase db, String key, String value) {
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty(key, (Object)value);
        tx.success();
        tx.finish();
        return node.getId();
    }

    private static HighlyAvailableGraphDatabase start(String storeDir, int i) {
        return TestInstanceJoin.start(storeDir, i, MapUtil.stringMap((String[])new String[0]));
    }

    private static HighlyAvailableGraphDatabase start(String storeDir, int i, Map<String, String> additionalConfig) {
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + i)).setConfig(ClusterSettings.server_id, i + "").setConfig(HaSettings.ha_server, "127.0.0.1:" + (6666 + i)).setConfig(HaSettings.pull_interval, "0ms").setConfig(additionalConfig).newGraphDatabase();
        TestInstanceJoin.awaitStart(db);
        return db;
    }

    private static void awaitStart(HighlyAvailableGraphDatabase db) {
        db.beginTx().finish();
    }
}

