/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.neo4j.kernel.impl.util.FileUtils;

public enum BranchedDataPolicy {
    keep_all{

        @Override
        public void handle(File storeDir) throws IOException {
            this.moveAwayDb(storeDir, this.newBranchedDataDir(storeDir));
        }
    }
    ,
    keep_last{

        @Override
        public void handle(File storeDir) throws IOException {
            File branchedDataDir = this.newBranchedDataDir(storeDir);
            this.moveAwayDb(storeDir, branchedDataDir);
            for (File file : 2.getBranchedDataRootDirectory(storeDir).listFiles()) {
                if (!2.isBranchedDataDirectory(file) || file.equals(branchedDataDir)) continue;
                FileUtils.deleteRecursively((File)file);
            }
        }
    }
    ,
    keep_none{

        @Override
        public void handle(File storeDir) throws IOException {
            for (File file : this.relevantDbFiles(storeDir)) {
                FileUtils.deleteRecursively((File)file);
            }
        }
    };

    static String BRANCH_SUBDIRECTORY;

    public abstract void handle(File var1) throws IOException;

    protected void moveAwayDb(File storeDir, File branchedDataDir) throws IOException {
        for (File file : this.relevantDbFiles(storeDir)) {
            FileUtils.moveFileToDirectory((File)file, (File)branchedDataDir);
        }
    }

    File newBranchedDataDir(File storeDir) {
        File result = BranchedDataPolicy.getBranchedDataDirectory(storeDir, System.currentTimeMillis());
        result.mkdirs();
        return result;
    }

    File[] relevantDbFiles(File storeDir) {
        if (!storeDir.exists()) {
            return new File[0];
        }
        return storeDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("messages.log") && !BranchedDataPolicy.isBranchedDataRootDirectory(file);
            }
        });
    }

    public static boolean isBranchedDataRootDirectory(File directory) {
        return directory.isDirectory() && directory.getName().equals(BRANCH_SUBDIRECTORY);
    }

    public static boolean isBranchedDataDirectory(File directory) {
        return directory.isDirectory() && directory.getParentFile().getName().equals(BRANCH_SUBDIRECTORY) && BranchedDataPolicy.isAllDigits(directory.getName());
    }

    private static boolean isAllDigits(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static File getBranchedDataRootDirectory(File storeDir) {
        return new File(storeDir, BRANCH_SUBDIRECTORY);
    }

    public static File getBranchedDataDirectory(File storeDir, long timestamp) {
        return new File(BranchedDataPolicy.getBranchedDataRootDirectory(storeDir), "" + timestamp);
    }

    public static File[] listBranchedDataDirectories(File storeDir) {
        return BranchedDataPolicy.getBranchedDataRootDirectory(storeDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File directory) {
                return BranchedDataPolicy.isBranchedDataDirectory(directory);
            }
        });
    }

    static {
        BRANCH_SUBDIRECTORY = "branched";
    }
}

