/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import ch.qos.logback.classic.LoggerContext;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberAvailability;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberEvents;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataMigrator;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaCaches;
import org.neo4j.kernel.ha.HaKernelPanicHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.HighAvailabilityDiagnostics;
import org.neo4j.kernel.ha.HighAvailabilityMemberInfoProvider;
import org.neo4j.kernel.ha.InstanceAccessGuard;
import org.neo4j.kernel.ha.LabelTokenCreatorModeSwitcher;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.PropertyKeyCreatorModeSwitcher;
import org.neo4j.kernel.ha.RelationshipTypeCreatorModeSwitcher;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.ZooToPaxosSwitchover;
import org.neo4j.kernel.ha.cluster.DefaultElectionCredentialsProvider;
import org.neo4j.kernel.ha.cluster.HANewSnapshotFunction;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.HighAvailabilitySlaves;
import org.neo4j.kernel.ha.cluster.zoo.ZooKeeperHighAvailabilityEvents;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.DefaultSlaveFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.lock.LockManagerModeSwitcher;
import org.neo4j.kernel.ha.management.ClusterDatabaseInfoProvider;
import org.neo4j.kernel.ha.management.HighlyAvailableKernelData;
import org.neo4j.kernel.ha.transaction.OnDiskLastTxIdGetter;
import org.neo4j.kernel.ha.transaction.TxHookModeSwitcher;
import org.neo4j.kernel.ha.transaction.TxIdGeneratorModeSwitcher;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.LogbackWeakDependency;
import org.neo4j.kernel.logging.Logging;

public class HighlyAvailableGraphDatabase
extends InternalAbstractGraphDatabase {
    private RequestContextFactory requestContextFactory;
    private Slaves slaves;
    private ClusterMembers members;
    private DelegateInvocationHandler masterDelegateInvocationHandler;
    private LoggerContext loggerContext;
    private Master master;
    private final InstanceAccessGuard accessGuard;
    private HighAvailabilityMemberStateMachine memberStateMachine;
    private UpdatePuller updatePuller;
    private LastUpdateTime lastUpdateTime;
    private HighAvailabilityMemberContext memberContext;
    private ClusterClient clusterClient;
    private ClusterMemberEvents clusterEvents;
    private ClusterMemberAvailability clusterMemberAvailability;
    private long stateSwitchTimeoutMillis;
    private final LifeSupport paxosLife = new LifeSupport();
    private boolean compatibilityMode = false;
    List<Lifecycle> compatibilityLifecycle = new LinkedList<Lifecycle>();
    private DelegateInvocationHandler clusterEventsDelegateInvocationHandler;
    private DelegateInvocationHandler memberContextDelegateInvocationHandler;
    private DelegateInvocationHandler clusterMemberAvailabilityDelegateInvocationHandler;
    private HighAvailabilityModeSwitcher highAvailabilityModeSwitcher;

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> params, Iterable<IndexProvider> indexProviders, Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders, Iterable<TransactionInterceptorProvider> txInterceptorProviders) {
        super(storeDir, params, Iterables.iterable((Object[])new Class[]{GraphDatabaseSettings.class, HaSettings.class, ClusterSettings.class}), indexProviders, kernelExtensions, cacheProviders, txInterceptorProviders);
        this.accessGuard = new InstanceAccessGuard();
        this.run();
    }

    protected void create() {
        this.life.add((Object)new BranchedDataMigrator(this.storeDir));
        this.masterDelegateInvocationHandler = new DelegateInvocationHandler();
        this.master = (Master)Proxy.newProxyInstance(Master.class.getClassLoader(), new Class[]{Master.class}, (InvocationHandler)this.masterDelegateInvocationHandler);
        super.create();
        this.kernelEventHandlers.registerKernelEventHandler((KernelEventHandler)new HaKernelPanicHandler(this.xaDataSourceManager, (TxManager)this.txManager, this.accessGuard));
        this.updatePuller = new UpdatePuller((HaXaDataSourceManager)this.xaDataSourceManager, this.master, this.requestContextFactory, this.txManager, this.accessGuard, this.lastUpdateTime, this.config, this.msgLog);
        this.life.add((Object)this.updatePuller);
        this.stateSwitchTimeoutMillis = (Long)this.config.get(HaSettings.state_switch_timeout);
        if (!this.compatibilityMode) {
            this.life.add((Object)this.paxosLife);
        }
        this.life.add((Object)new StartupWaiter());
        this.diagnosticsManager.appendProvider((DiagnosticsProvider)new HighAvailabilityDiagnostics(this.memberStateMachine, this.clusterClient));
    }

    protected boolean isHighlyAvailable() {
        return true;
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    protected org.neo4j.graphdb.Transaction beginTx(ForceMode forceMode) {
        if (!this.accessGuard.await(this.stateSwitchTimeoutMillis)) {
            throw new TransactionFailureException("Timeout waiting for cluster to elect master");
        }
        return super.beginTx(forceMode);
    }

    protected Logging createLogging() {
        return (Logging)this.life.add((Object)new LogbackWeakDependency().tryLoadLogbackService(this.config, LogbackWeakDependency.NEW_LOGGER_CONTEXT, LogbackWeakDependency.DEFAULT_TO_CLASSIC));
    }

    protected TransactionStateFactory createTransactionStateFactory() {
        return new TransactionStateFactory(this.logging){

            public TransactionState create(Transaction tx) {
                return new WritableTransactionState(DelegateInvocationHandler.snapshot(this.lockManager), this.nodeManager, this.logging, tx, DelegateInvocationHandler.snapshot(this.txHook), DelegateInvocationHandler.snapshot(this.txIdGenerator));
            }
        };
    }

    protected XaDataSourceManager createXaDataSourceManager() {
        HaXaDataSourceManager toReturn = new HaXaDataSourceManager(this.logging.getMessagesLog(HaXaDataSourceManager.class));
        this.requestContextFactory = new RequestContextFactory((Integer)this.config.get(ClusterSettings.server_id), toReturn, this.dependencyResolver);
        return toReturn;
    }

    protected TxHook createTxHook() {
        this.clusterEventsDelegateInvocationHandler = new DelegateInvocationHandler();
        this.memberContextDelegateInvocationHandler = new DelegateInvocationHandler();
        this.clusterMemberAvailabilityDelegateInvocationHandler = new DelegateInvocationHandler();
        this.clusterEvents = (ClusterMemberEvents)Proxy.newProxyInstance(ClusterMemberEvents.class.getClassLoader(), new Class[]{ClusterMemberEvents.class, Lifecycle.class}, (InvocationHandler)this.clusterEventsDelegateInvocationHandler);
        this.memberContext = (HighAvailabilityMemberContext)Proxy.newProxyInstance(HighAvailabilityMemberContext.class.getClassLoader(), new Class[]{HighAvailabilityMemberContext.class}, (InvocationHandler)this.memberContextDelegateInvocationHandler);
        this.clusterMemberAvailability = (ClusterMemberAvailability)Proxy.newProxyInstance(ClusterMemberAvailability.class.getClassLoader(), new Class[]{ClusterMemberAvailability.class}, (InvocationHandler)this.clusterMemberAvailabilityDelegateInvocationHandler);
        Object electionCredentialsProvider = (Boolean)this.config.get(HaSettings.slave_only) != false ? new NotElectableElectionCredentialsProvider() : new DefaultElectionCredentialsProvider((Integer)this.config.get(ClusterSettings.server_id), new OnDiskLastTxIdGetter(new File(this.getStoreDir())), new HighAvailabilityMemberInfoProvider(){

            @Override
            public HighAvailabilityMemberState getHighAvailabilityMemberState() {
                return HighlyAvailableGraphDatabase.this.memberStateMachine.getCurrentState();
            }
        });
        this.clusterClient = new ClusterClient(ClusterClient.adapt((Config)this.config), this.logging, (ElectionCredentialsProvider)electionCredentialsProvider);
        PaxosClusterMemberEvents localClusterEvents = new PaxosClusterMemberEvents((Snapshot)this.clusterClient, (Cluster)this.clusterClient, (Heartbeat)this.clusterClient, (AtomicBroadcast)this.clusterClient, this.logging, (Predicate)new Predicate<PaxosClusterMemberEvents.ClusterMembersSnapshot>(){

            public boolean accept(PaxosClusterMemberEvents.ClusterMembersSnapshot item) {
                for (MemberIsAvailable member : item.getCurrentAvailableMembers()) {
                    if (!member.getRoleUri().getScheme().equals("ha") || HighAvailabilityModeSwitcher.getServerId(member.getRoleUri()) != (Integer)HighlyAvailableGraphDatabase.this.config.get(ClusterSettings.server_id)) continue;
                    HighlyAvailableGraphDatabase.this.msgLog.error(String.format("Instance %s has the same serverId as ours (%d) - will not join this cluster", member.getRoleUri(), HighlyAvailableGraphDatabase.this.config.get(ClusterSettings.server_id)));
                    return true;
                }
                return true;
            }
        }, (Function2)new HANewSnapshotFunction());
        this.clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){
            boolean hasRequestedElection = false;

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                this.hasRequestedElection = true;
                HighlyAvailableGraphDatabase.this.clusterClient.performRoleElections();
            }

            public void elected(String role, InstanceId instanceId, URI electedMember) {
                if (this.hasRequestedElection && role.equals("coordinator")) {
                    HighlyAvailableGraphDatabase.this.clusterClient.refreshSnapshot();
                    HighlyAvailableGraphDatabase.this.clusterClient.removeClusterListener((ClusterListener)this);
                }
            }
        });
        SimpleHighAvailabilityMemberContext localMemberContext = new SimpleHighAvailabilityMemberContext(this.clusterClient.getServerId());
        PaxosClusterMemberAvailability localClusterMemberAvailability = new PaxosClusterMemberAvailability(this.clusterClient.getServerId(), (BindingNotifier)this.clusterClient, (AtomicBroadcast)this.clusterClient, this.logging);
        if (!((List)this.config.get(HaSettings.coordinators)).isEmpty() && !((HostnamePort)((List)this.config.get(HaSettings.coordinators)).get(0)).toString().trim().equals("")) {
            this.compatibilityMode = true;
            this.compatibilityLifecycle = new LinkedList<Lifecycle>();
            ZooToPaxosSwitchover switchover = new ZooToPaxosSwitchover(this.life, this.paxosLife, this.compatibilityLifecycle, this.clusterEventsDelegateInvocationHandler, this.memberContextDelegateInvocationHandler, this.clusterMemberAvailabilityDelegateInvocationHandler, localClusterEvents, localMemberContext, localClusterMemberAvailability);
            ZooKeeperHighAvailabilityEvents zkEvents = new ZooKeeperHighAvailabilityEvents(this.logging, this.config, switchover);
            this.compatibilityLifecycle.add(zkEvents);
            this.memberContextDelegateInvocationHandler.setDelegate(new SimpleHighAvailabilityMemberContext(zkEvents.getInstanceId()));
            this.clusterEventsDelegateInvocationHandler.setDelegate(zkEvents);
            this.clusterMemberAvailabilityDelegateInvocationHandler.setDelegate(zkEvents);
            this.paxosLife.add((Object)localClusterEvents);
        } else {
            this.memberContextDelegateInvocationHandler.setDelegate(localMemberContext);
            this.clusterEventsDelegateInvocationHandler.setDelegate(localClusterEvents);
            this.clusterMemberAvailabilityDelegateInvocationHandler.setDelegate(localClusterMemberAvailability);
        }
        this.members = new ClusterMembers((Cluster)this.clusterClient, (Heartbeat)this.clusterClient, this.clusterEvents, new InstanceId(((Integer)this.config.get(ClusterSettings.server_id)).intValue()));
        this.memberStateMachine = new HighAvailabilityMemberStateMachine(this.memberContext, this.accessGuard, this.members, this.clusterEvents, (Election)this.clusterClient, this.logging.getMessagesLog(HighAvailabilityMemberStateMachine.class));
        if (this.compatibilityMode) {
            this.compatibilityLifecycle.add((Lifecycle)this.memberStateMachine);
            this.compatibilityLifecycle.add((Lifecycle)this.clusterEvents);
            this.life.add((Object)this.memberStateMachine);
            this.life.add((Object)this.clusterEvents);
        }
        this.paxosLife.add((Object)this.clusterClient);
        this.paxosLife.add((Object)this.memberStateMachine);
        this.paxosLife.add((Object)this.clusterEvents);
        this.paxosLife.add((Object)localClusterMemberAvailability);
        DelegateInvocationHandler<TxHook> txHookDelegate = new DelegateInvocationHandler<TxHook>();
        TxHook txHook = (TxHook)Proxy.newProxyInstance(TxHook.class.getClassLoader(), new Class[]{TxHook.class}, txHookDelegate);
        new TxHookModeSwitcher(this.memberStateMachine, txHookDelegate, this.master, new TxHookModeSwitcher.RequestContextFactoryResolver(){

            @Override
            public RequestContextFactory get() {
                return HighlyAvailableGraphDatabase.this.requestContextFactory;
            }
        }, this.dependencyResolver);
        return txHook;
    }

    protected TxIdGenerator createTxIdGenerator() {
        DelegateInvocationHandler<TxIdGenerator> txIdGeneratorDelegate = new DelegateInvocationHandler<TxIdGenerator>();
        TxIdGenerator txIdGenerator = (TxIdGenerator)Proxy.newProxyInstance(TxIdGenerator.class.getClassLoader(), new Class[]{TxIdGenerator.class}, txIdGeneratorDelegate);
        this.slaves = (Slaves)this.life.add((Object)new HighAvailabilitySlaves(this.members, (Cluster)this.clusterClient, new DefaultSlaveFactory(this.xaDataSourceManager, this.logging, ((Long)this.config.get(HaSettings.com_chunk_size)).intValue())));
        new TxIdGeneratorModeSwitcher(this.memberStateMachine, txIdGeneratorDelegate, (HaXaDataSourceManager)this.xaDataSourceManager, this.master, this.requestContextFactory, this.msgLog, this.config, this.slaves);
        return txIdGenerator;
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        this.idGeneratorFactory = new HaIdGeneratorFactory(this.master, this.memberStateMachine, this.logging);
        this.highAvailabilityModeSwitcher = new HighAvailabilityModeSwitcher(this.masterDelegateInvocationHandler, this.clusterMemberAvailability, this.memberStateMachine, (GraphDatabaseAPI)this, (HaIdGeneratorFactory)this.idGeneratorFactory, this.config, this.logging, this.updateableSchemaState);
        this.paxosLife.add((Object)this.highAvailabilityModeSwitcher);
        if (this.compatibilityMode) {
            this.compatibilityLifecycle.add(1, this.highAvailabilityModeSwitcher);
            this.life.add((Object)this.highAvailabilityModeSwitcher);
        }
        ((HaIdGeneratorFactory)this.idGeneratorFactory).switchToMaster();
        return this.idGeneratorFactory;
    }

    protected LockManager createLockManager() {
        DelegateInvocationHandler<LockManager> lockManagerDelegate = new DelegateInvocationHandler<LockManager>();
        LockManager lockManager = (LockManager)Proxy.newProxyInstance(LockManager.class.getClassLoader(), new Class[]{LockManager.class}, lockManagerDelegate);
        new LockManagerModeSwitcher(this.memberStateMachine, lockManagerDelegate, this.txManager, this.txHook, (HaXaDataSourceManager)this.xaDataSourceManager, this.master, this.requestContextFactory, this.accessGuard, this.config);
        return lockManager;
    }

    protected TokenCreator createRelationshipTypeCreator() {
        DelegateInvocationHandler<TokenCreator> relationshipTypeCreatorDelegate = new DelegateInvocationHandler<TokenCreator>();
        TokenCreator relationshipTypeCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, relationshipTypeCreatorDelegate);
        new RelationshipTypeCreatorModeSwitcher(this.memberStateMachine, relationshipTypeCreatorDelegate, (HaXaDataSourceManager)this.xaDataSourceManager, this.master, this.requestContextFactory, this.logging);
        return relationshipTypeCreator;
    }

    protected TokenCreator createPropertyKeyCreator() {
        DelegateInvocationHandler<TokenCreator> propertyKeyCreatorDelegate = new DelegateInvocationHandler<TokenCreator>();
        TokenCreator propertyTokenCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, propertyKeyCreatorDelegate);
        new PropertyKeyCreatorModeSwitcher(this.memberStateMachine, propertyKeyCreatorDelegate, (HaXaDataSourceManager)this.xaDataSourceManager, this.master, this.requestContextFactory, this.logging);
        return propertyTokenCreator;
    }

    protected TokenCreator createLabelIdCreator() {
        DelegateInvocationHandler<TokenCreator> labelIdCreatorDelegate = new DelegateInvocationHandler<TokenCreator>();
        TokenCreator labelIdCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, labelIdCreatorDelegate);
        new LabelTokenCreatorModeSwitcher(this.memberStateMachine, labelIdCreatorDelegate, (HaXaDataSourceManager)this.xaDataSourceManager, this.master, this.requestContextFactory, this.logging);
        return labelIdCreator;
    }

    protected Caches createCaches() {
        return new HaCaches(this.logging.getMessagesLog(Caches.class));
    }

    protected KernelData createKernelData() {
        this.lastUpdateTime = new LastUpdateTime();
        return new HighlyAvailableKernelData(this, this.members, new ClusterDatabaseInfoProvider(this.members, new OnDiskLastTxIdGetter(new File(this.getStoreDir())), this.lastUpdateTime));
    }

    protected void registerRecovery() {
        this.memberStateMachine.addHighAvailabilityMemberListener(new HighAvailabilityMemberListener(){

            @Override
            public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
            }

            @Override
            public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_MASTER) && event.getNewState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.doAfterRecoveryAndStartup(true);
                }
            }

            @Override
            public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_SLAVE) && event.getNewState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.doAfterRecoveryAndStartup(false);
                }
            }

            @Override
            public void instanceStops(HighAvailabilityMemberChangeEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doAfterRecoveryAndStartup(boolean isMaster) {
                try {
                    XaDataSourceManager xaDataSourceManager = HighlyAvailableGraphDatabase.this.xaDataSourceManager;
                    synchronized (xaDataSourceManager) {
                        HighlyAvailableGraphDatabase.this.doAfterRecoveryAndStartup(isMaster);
                    }
                }
                catch (Throwable throwable) {
                    HighlyAvailableGraphDatabase.this.msgLog.error("Post recovery error", throwable);
                    try {
                        HighlyAvailableGraphDatabase.this.memberStateMachine.stop();
                    }
                    catch (Throwable throwable1) {
                        HighlyAvailableGraphDatabase.this.msgLog.warn("Could not stop", throwable1);
                    }
                    try {
                        HighlyAvailableGraphDatabase.this.memberStateMachine.start();
                    }
                    catch (Throwable throwable1) {
                        HighlyAvailableGraphDatabase.this.msgLog.warn("Could not start", throwable1);
                    }
                }
            }
        });
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.storeDir + "]";
    }

    public String getInstanceState() {
        return this.memberStateMachine.getCurrentState().name();
    }

    public boolean isMaster() {
        return this.memberStateMachine.getCurrentState() == HighAvailabilityMemberState.MASTER;
    }

    public DependencyResolver getDependencyResolver() {
        return new DependencyResolver.Adapter(){

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy<T> selector) {
                Object result;
                try {
                    result = HighlyAvailableGraphDatabase.this.dependencyResolver.resolveDependency(type);
                }
                catch (IllegalArgumentException e) {
                    if (ClusterMemberEvents.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.clusterEvents);
                    }
                    if (ClusterMemberAvailability.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.clusterMemberAvailability);
                    }
                    if (UpdatePuller.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.updatePuller);
                    }
                    if (Slaves.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.slaves);
                    }
                    if (ClusterClient.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.clusterClient);
                    }
                    if (ClusterMembers.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.members);
                    }
                    if (RequestContextFactory.class.isAssignableFrom(type)) {
                        result = type.cast(HighlyAvailableGraphDatabase.this.requestContextFactory);
                    }
                    throw e;
                }
                return (T)selector.select(type, Iterables.option((Object)result));
            }
        };
    }

    private class StartupWaiter
    extends LifecycleAdapter {
        private StartupWaiter() {
        }

        public void start() throws Throwable {
            HighlyAvailableGraphDatabase.this.accessGuard.await(HighlyAvailableGraphDatabase.this.stateSwitchTimeoutMillis);
        }
    }
}

