/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.zoo;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.NeoStoreUtil;
import org.neo4j.kernel.ha.cluster.zoo.Machine;
import org.neo4j.kernel.ha.cluster.zoo.ZooKeeperException;
import org.neo4j.kernel.ha.cluster.zoo.ZooKeeperMachine;
import org.neo4j.kernel.ha.cluster.zoo.ZooListener;
import org.neo4j.kernel.ha.switchover.CompatibilityModeListener;
import org.neo4j.kernel.ha.switchover.CompatibilityMonitor;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.NullLogBuffer;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class ZooClient
implements Lifecycle,
CompatibilityMonitor {
    static final String MASTER_NOTIFY_CHILD = "master-notify";
    static final String MASTER_REBOUND_CHILD = "master-rebound";
    protected static final String HA_SERVERS_CHILD = "ha-servers";
    protected static final String FLUSH_REQUESTED_CHILD = "flush-requested";
    protected static final String COMPATIBILITY_CHILD_18 = "compatibility-1.8";
    protected static final String COMPATIBILITY_CHILD_19 = "compatibility-1.9";
    private ZooKeeper zooKeeper;
    private int machineId;
    private String sequenceNr;
    private long committedTx;
    private int masterForCommittedTx;
    private final Object keeperStateMonitor = new Object();
    private volatile Watcher.Event.KeeperState keeperState = Watcher.Event.KeeperState.Disconnected;
    private volatile boolean shutdown = false;
    private volatile boolean flushing = false;
    private String rootPath;
    private volatile StoreId storeId;
    private volatile TxIdUpdater updater = new NoUpdateTxIdUpdater();
    private String clusterServer;
    private File storeDir;
    private long sessionId = -1L;
    private HostnamePort backupPort;
    private String clusterName;
    private boolean allowCreateCluster;
    private WatcherImpl watcher;
    private Machine asMachine;
    private final Config conf;
    private Iterable<ZooListener> zooListeners = Listeners.newListeners();
    private Iterable<CompatibilityModeListener> compatibilityListeners = Listeners.newListeners();
    protected static final int STOP_FLUSHING = -6;
    private List<HostnamePort> servers;
    private final Map<Integer, Machine> haServersCache = new ConcurrentHashMap<Integer, Machine>();
    protected volatile Machine cachedMaster = NO_MACHINE;
    protected final StringLogger msgLog;
    private long sessionTimeout;
    private String haServer;
    private final FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
    public static final Machine NO_MACHINE = ZooKeeperMachine.NO_MACHINE;

    public ZooClient(StringLogger stringLogger, Config conf) {
        this.conf = conf;
        this.msgLog = stringLogger;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        this.storeDir = (File)this.conf.get((Setting)GraphDatabaseSettings.store_dir);
        this.machineId = (Integer)this.conf.get(ClusterSettings.server_id);
        this.backupPort = (HostnamePort)this.conf.get(OnlineBackupSettings.online_backup_server);
        this.clusterServer = "cluster://" + ((HostnamePort)this.conf.get(ClusterSettings.cluster_server)).getHost(this.defaultServer()) + ":" + ((HostnamePort)this.conf.get(ClusterSettings.cluster_server)).getPort();
        this.haServer = "ha://" + ((HostnamePort)this.conf.get(HaSettings.ha_server)).getHost(this.defaultServer()) + ":" + ((HostnamePort)this.conf.get(ClusterSettings.cluster_server)).getPort();
        this.clusterName = (String)this.conf.get(ClusterSettings.cluster_name);
        this.allowCreateCluster = (Boolean)this.conf.get(ClusterSettings.allow_init_cluster);
        this.asMachine = new Machine(this.machineId, 0, 0L, 0, this.haServer, this.backupPort.getPort());
        this.servers = (List)this.conf.get(HaSettings.coordinators);
        this.sessionTimeout = (Long)this.conf.get(HaSettings.zk_session_timeout);
        this.sequenceNr = "not initialized yet";
        try {
            this.watcher = new WatcherImpl();
            this.zooKeeper = new ZooKeeper(this.getServersAsString(), this.getSessionTimeout(), (Watcher)this.watcher);
            this.watcher.flushUnprocessedEvents(this.zooKeeper);
        }
        catch (IOException e) {
            throw new ZooKeeperException("Unable to create zoo keeper client", e);
        }
    }

    public void stop() throws Throwable {
    }

    public void shutdown() {
        try {
            this.watcher.shutdown();
            this.shutdown = true;
            this.invalidateMaster();
            this.cachedMaster = NO_MACHINE;
            this.getZooKeeper(false).close();
            this.msgLog.logMessage("zoo client shut down");
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Error closing zookeeper connection", e);
        }
    }

    public String refreshMasterFromZooKeeper() {
        return this.getMasterFromZooKeeper(true, WaitMode.SESSION, true);
    }

    private String getMasterFromZooKeeper(boolean wait, WaitMode mode, boolean allowChange) {
        ZooKeeperMachine master = this.getMasterBasedOn(this.getAllMachines(wait, mode).values());
        this.masterElectionHappened(this.cachedMaster, master);
        if (this.cachedMaster.getMachineId() != master.getMachineId()) {
            this.invalidateMaster();
            if (!allowChange) {
                return "";
            }
            this.cachedMaster = master;
        }
        return this.cachedMaster.getServerAsString();
    }

    protected void invalidateMaster() {
        if (this.cachedMaster != null) {
            this.cachedMaster = NO_MACHINE;
        }
    }

    public Machine getCachedMaster() {
        return this.cachedMaster;
    }

    private String defaultServer() {
        InetAddress host = null;
        try {
            host = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (host == null) {
            throw new IllegalStateException("Could not auto configure host name, please supply " + HaSettings.ha_server.name());
        }
        return host.getHostAddress();
    }

    protected StoreId getStoreId() {
        return this.storeId;
    }

    protected int getMyMachineId() {
        return this.machineId;
    }

    private int toInt(byte[] data) {
        return ByteBuffer.wrap(data).getInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForSyncConnected(WaitMode mode) {
        long startTime;
        if (this.keeperState == Watcher.Event.KeeperState.SyncConnected) {
            return;
        }
        if (this.shutdown) {
            throw new ZooKeeperException("ZooKeeper client has been shutdown");
        }
        WaitStrategy strategy = mode.getStrategy(this);
        long currentTime = startTime = System.currentTimeMillis();
        Object object = this.keeperStateMonitor;
        synchronized (object) {
            do {
                try {
                    this.keeperStateMonitor.wait(250L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                if (this.keeperState == Watcher.Event.KeeperState.SyncConnected) {
                    return;
                }
                if (!this.shutdown) continue;
                throw new ZooKeeperException("ZooKeeper client has been shutdown");
            } while (strategy.waitMore((currentTime = System.currentTimeMillis()) - startTime));
            if (this.keeperState != Watcher.Event.KeeperState.SyncConnected) {
                throw new ZooKeeperException("Connection to ZooKeeper server timed out, keeper state=" + this.keeperState);
            }
        }
    }

    protected void subscribeToDataChangeWatcher(String child) {
        block8: {
            String root = this.getRoot();
            String path = root + "/" + child;
            try {
                try {
                    this.zooKeeper.getData(path, true, null);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) {
                        byte[] data = new byte[4];
                        ByteBuffer.wrap(data).putInt(-1);
                        try {
                            this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                            break block8;
                        }
                        catch (KeeperException ce) {
                            if (e.code() != KeeperException.Code.NODEEXISTS) {
                                throw new ZooKeeperException("Creation error", ce);
                            }
                            break block8;
                        }
                    }
                    throw new ZooKeeperException("Couldn't get or create " + child, e);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Interrupted", e);
            }
        }
    }

    protected void subscribeToChildrenChangeWatcher(String child) {
        String path = this.getRoot() + "/" + child;
        try {
            this.zooKeeper.getChildren(path, true);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Couldn't subscribe getChildren at " + path, e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    protected void setDataChangeWatcher(String child, int currentMasterId) {
        this.setDataChangeWatcher(child, currentMasterId, true);
    }

    protected void setDataChangeWatcher(String child, int currentMasterId, boolean skipOnSame) {
        try {
            boolean exists;
            byte[] data;
            String path;
            block11: {
                String root = this.getRoot();
                path = root + "/" + child;
                data = null;
                exists = false;
                try {
                    data = this.zooKeeper.getData(path, true, null);
                    exists = true;
                    if (skipOnSame && ByteBuffer.wrap(data).getInt() == currentMasterId) {
                        this.msgLog.logMessage(child + " not set, is already " + currentMasterId);
                        return;
                    }
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) break block11;
                    throw new ZooKeeperException("Couldn't get master notify node", e);
                }
            }
            try {
                data = new byte[4];
                ByteBuffer.wrap(data).putInt(currentMasterId);
                if (!exists) {
                    this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    this.msgLog.logMessage(child + " created with " + currentMasterId);
                } else if (currentMasterId != -1) {
                    this.zooKeeper.setData(path, data, -1);
                    this.msgLog.logMessage(child + " set to " + currentMasterId);
                }
                this.zooKeeper.getData(path, true, null);
            }
            catch (KeeperException e) {
                if (e.code() != KeeperException.Code.NODEEXISTS) {
                    throw new ZooKeeperException("Couldn't set master notify node", e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    public String getRoot() {
        this.makeSureRootPathIsFound();
        byte[] rootData = null;
        do {
            try {
                rootData = this.zooKeeper.getData(this.rootPath, false, null);
                return this.rootPath;
            }
            catch (KeeperException e) {
                if (e.code() != KeeperException.Code.NONODE) {
                    throw new ZooKeeperException("Unable to get root node", e);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Got interrupted", e);
            }
            try {
                byte[] data = new byte[]{};
                this.zooKeeper.create(this.rootPath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) continue;
                throw new ZooKeeperException("Unable to create root", e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Got interrupted", e);
            }
        } while (rootData == null);
        throw new IllegalStateException("Root path couldn't be found");
    }

    private void makeSureRootPathIsFound() {
        if (this.rootPath == null) {
            this.storeId = this.getClusterStoreId(this.zooKeeper, this.clusterName);
            if (this.storeId != null) {
                this.rootPath = this.asRootPath(this.storeId);
                if (NeoStoreUtil.storeExists(this.storeDir)) {
                    NeoStoreUtil store = new NeoStoreUtil(this.storeDir);
                    this.committedTx = store.getLastCommittedTx();
                    if (!this.storeId.equals((Object)store.asStoreId())) {
                        throw new ZooKeeperException("StoreId in database doesn't match that of the ZK cluster");
                    }
                } else {
                    this.committedTx = 1L;
                }
            } else {
                if (!this.allowCreateCluster) {
                    throw new RuntimeException("Not allowed to create cluster");
                }
                StoreId storeIdSuggestion = NeoStoreUtil.storeExists(this.storeDir) ? new NeoStoreUtil(this.storeDir).asStoreId() : new StoreId();
                this.storeId = this.createCluster(storeIdSuggestion);
                this.makeSureRootPathIsFound();
            }
            this.masterForCommittedTx = this.getFirstMasterForTx(this.committedTx);
        }
    }

    private void cleanupChildren() {
        try {
            String root = this.getRoot();
            List children = this.zooKeeper.getChildren(root, false);
            for (String child : children) {
                Pair<Integer, Integer> parsedChild = this.parseChild(child);
                if (parsedChild == null || (Integer)parsedChild.first() != this.machineId) continue;
                this.zooKeeper.delete(root + "/" + child, -1);
            }
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to clean up old child", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted.", e);
        }
    }

    private byte[] dataRepresentingMe(long txId, int master) {
        byte[] array = new byte[12];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putLong(txId);
        buffer.putInt(master);
        return array;
    }

    private String setup() {
        try {
            this.cleanupChildren();
            this.writeHaServerConfig();
            String root = this.getRoot();
            String path = root + "/" + this.machineId + "_";
            String created = this.zooKeeper.create(path, this.dataRepresentingMe(this.committedTx, this.masterForCommittedTx), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            this.subscribeToDataChangeWatcher(MASTER_NOTIFY_CHILD);
            this.subscribeToDataChangeWatcher(MASTER_REBOUND_CHILD);
            this.subscribeToChildrenChangeWatcher(HA_SERVERS_CHILD);
            this.subscribeToChildrenChangeWatcher(COMPATIBILITY_CHILD_19);
            return created.substring(created.lastIndexOf("_") + 1);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to setup", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Setup got interrupted", e);
        }
        catch (Throwable t) {
            throw new ZooKeeperException("Unknown setup error", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHaServerConfig() throws InterruptedException, KeeperException {
        String compatibilityPath;
        String legacyCompatibilityPath;
        String serverRootPath;
        block17: {
            block16: {
                serverRootPath = this.rootPath + "/" + HA_SERVERS_CHILD;
                try {
                    this.zooKeeper.create(serverRootPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NODEEXISTS) break block16;
                    throw e;
                }
            }
            legacyCompatibilityPath = this.rootPath + "/" + COMPATIBILITY_CHILD_18;
            compatibilityPath = this.rootPath + "/" + COMPATIBILITY_CHILD_19;
            try {
                this.zooKeeper.create(compatibilityPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block17;
                throw e;
            }
        }
        String machinePath = serverRootPath + "/" + this.machineId;
        String legacyCompatibilityMachinePath = legacyCompatibilityPath + "/" + this.machineId;
        String compatibilityMachinePath = compatibilityPath + "/" + this.machineId;
        byte[] data = this.haServerAsData();
        boolean legacyCompatCreated = false;
        boolean compatCreated = false;
        boolean machineCreated = false;
        try {
            this.zooKeeper.create(legacyCompatibilityMachinePath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            legacyCompatCreated = true;
            this.zooKeeper.create(compatibilityMachinePath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            compatCreated = true;
            this.zooKeeper.create(machinePath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            machineCreated = true;
        }
        catch (KeeperException e) {
            if (e.code() != KeeperException.Code.NODEEXISTS) {
                throw e;
            }
            this.msgLog.logMessage("HA server info already present, trying again");
            Thread.sleep(3000L);
            try {
                if (legacyCompatCreated) {
                    this.zooKeeper.delete(legacyCompatibilityMachinePath, -1);
                }
                if (compatCreated) {
                    this.zooKeeper.delete(compatibilityMachinePath, -1);
                }
                if (machineCreated) {
                    this.zooKeeper.delete(machinePath, -1);
                }
            }
            catch (KeeperException ee) {
                if (ee.code() != KeeperException.Code.NONODE) {
                    this.msgLog.logMessage("Unable to delete " + ee.getPath(), (Throwable)ee);
                }
            }
            finally {
                this.writeHaServerConfig();
            }
        }
        this.zooKeeper.setData(machinePath, data, -1);
        this.msgLog.logMessage("Wrote HA server " + this.haServer + " to zoo keeper");
    }

    private byte[] haServerAsData() {
        byte[] array = new byte[this.haServer.length() * 2 + 100];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putInt(this.backupPort.getPort());
        buffer.put((byte)this.haServer.substring(5).length());
        buffer.asCharBuffer().put(this.haServer.substring(5).toCharArray()).flip();
        byte[] actualArray = new byte[buffer.limit()];
        System.arraycopy(array, 0, actualArray, 0, actualArray.length);
        return actualArray;
    }

    public int getCurrentMasterNotify() {
        String path = this.rootPath + "/" + MASTER_NOTIFY_CHILD;
        try {
            byte[] data = this.zooKeeper.getData(path, true, null);
            return ByteBuffer.wrap(data).getInt();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void startFlushing() {
        this.updater = new CompatibilitySlaveOnlyTxIdUpdater();
        this.updater.init();
    }

    private void stopFlushing() {
        this.updater = new CompatibilitySlaveOnlyTxIdUpdater();
        this.updater.init();
    }

    private void writeData(long tx, int masterForThat) {
        this.waitForSyncConnected();
        String root = this.getRoot();
        String path = root + "/" + this.machineId + "_" + this.sequenceNr;
        byte[] data = this.dataRepresentingMe(tx, masterForThat);
        try {
            this.zooKeeper.setData(path, data, -1);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to set current tx", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted...", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFirstMasterForTx(long committedTx) {
        if (committedTx == 1L) {
            return -1;
        }
        try (LogExtractor extractor = null;){
            extractor = LogExtractor.from((FileSystemAbstraction)this.fileSystem, (File)this.storeDir, (long)committedTx);
            long tx = extractor.extractNext(NullLogBuffer.INSTANCE);
            if (tx != committedTx) {
                this.msgLog.logMessage("Tried to extract master for tx " + committedTx + " at " + "initialization, but got tx " + tx + " back. Will be using " + -1 + " temporarily");
                int n = -1;
                return n;
            }
            int n = extractor.getLastStartEntry().getMasterId();
            return n;
        }
    }

    protected void masterElectionHappened(Machine previousMaster, Machine newMaster) {
        if (previousMaster == NO_MACHINE && newMaster.getMachineId() == this.getMyMachineId()) {
            this.setDataChangeWatcher(MASTER_REBOUND_CHILD, this.getMyMachineId(), false);
        }
    }

    public ZooKeeper getZooKeeper(boolean sync) {
        if (sync) {
            this.zooKeeper.sync(this.rootPath, null, null);
        }
        return this.zooKeeper;
    }

    private boolean checkCompatibilityMode() {
        try {
            this.refreshHaServers();
            int totalCount = this.getNumberOfServers();
            int myVersionCount = this.zooKeeper.getChildren(this.getRoot() + "/" + COMPATIBILITY_CHILD_19, false).size();
            boolean result = myVersionCount <= totalCount - 1;
            this.msgLog.logMessage("Checking compatibility mode, read " + totalCount + " as all machines, " + myVersionCount + " as myVersion machines. Based on that I return " + result);
            return result;
        }
        catch (Exception e) {
            this.msgLog.logMessage("Tried to discover if we are in compatibility mode, got this exception instead", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private synchronized StoreId createCluster(StoreId storeIdSuggestion) {
        String path = "/" + this.clusterName;
        try {
            try {
                this.zooKeeper.create(path, storeIdSuggestion.serialize(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                return storeIdSuggestion;
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    try {
                        return StoreId.deserialize((byte[])this.zooKeeper.getData(path, false, null));
                    }
                    catch (KeeperException ex) {
                        throw new ZooKeeperException("Unable to read cluster store id", ex);
                    }
                }
                throw new ZooKeeperException("Unable to write cluster store id", e);
            }
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("createCluster interrupted", e);
        }
    }

    public StoreId getClusterStoreId(WaitMode mode) {
        this.waitForSyncConnected(mode);
        this.makeSureRootPathIsFound();
        return this.storeId;
    }

    protected StoreId getClusterStoreId(ZooKeeper keeper, String clusterName) {
        try {
            byte[] child = keeper.getData("/" + clusterName, false, null);
            return StoreId.deserialize((byte[])child);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE) {
                return null;
            }
            throw new ZooKeeperException("Error getting store id", e);
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    protected String asRootPath(StoreId storeId) {
        return "/" + storeId.getCreationTime() + "_" + storeId.getRandomId();
    }

    protected Pair<Integer, Integer> parseChild(String child) {
        int index = child.indexOf(95);
        if (index == -1) {
            return null;
        }
        int id = Integer.parseInt(child.substring(0, index));
        int seq = Integer.parseInt(child.substring(index + 1));
        return Pair.of((Object)id, (Object)seq);
    }

    protected Pair<Long, Integer> readDataRepresentingInstance(String path) throws InterruptedException, KeeperException {
        this.log("reading data for instance " + path);
        byte[] data = this.getZooKeeper(false).getData(path, false, null);
        ByteBuffer buf = ByteBuffer.wrap(data);
        return Pair.of((Object)buf.getLong(), (Object)buf.getInt());
    }

    protected String getSequenceNr() {
        return this.sequenceNr;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[serverId:" + this.machineId + ", seq:" + this.sequenceNr + ", lastCommittedTx:" + this.committedTx + " w/ master:" + this.masterForCommittedTx + ", session:" + this.sessionId + "]";
    }

    public void addZooListener(ZooListener zooListener) {
        this.zooListeners = Listeners.addListener((Object)zooListener, this.zooListeners);
    }

    @Override
    public void addCompatibilityModeListener(CompatibilityModeListener listener) {
        this.compatibilityListeners = Listeners.addListener((Object)listener, this.compatibilityListeners);
    }

    @Override
    public void removeCompatibilityModeListener(CompatibilityModeListener listener) {
        this.compatibilityListeners = Listeners.removeListener((Object)listener, this.compatibilityListeners);
    }

    protected ZooKeeperMachine getMasterBasedOn(Collection<ZooKeeperMachine> machines) {
        Machine master = null;
        int lowestSeq = Integer.MAX_VALUE;
        long highestTxId = -1L;
        for (ZooKeeperMachine info : machines) {
            if (info.getLastCommittedTxId() == -1L || info.getLastCommittedTxId() < highestTxId || info.getLastCommittedTxId() <= highestTxId && !info.wasCommittingMaster() && (master.wasCommittingMaster() || info.getSequenceId() >= lowestSeq)) continue;
            master = info;
            lowestSeq = info.getSequenceId();
            highestTxId = info.getLastCommittedTxId();
        }
        this.log("getMaster " + (master != null ? Integer.valueOf(master.getMachineId()) : "none") + " based on " + machines);
        if (master != null) {
            try {
                this.getZooKeeper(false).getData(this.getRoot() + "/" + ((ZooKeeperMachine)master).getZooKeeperPath(), true, null);
            }
            catch (KeeperException e) {
                throw new ZooKeeperException("Unable to get master data while setting watch", e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Interrupted while setting watch on master.", e);
            }
            return master;
        }
        return ZooKeeperMachine.NO_MACHINE;
    }

    protected Map<Integer, ZooKeeperMachine> getAllMachines(boolean wait) {
        return this.getAllMachines(wait, WaitMode.SESSION);
    }

    protected Map<Integer, ZooKeeperMachine> getAllMachines(boolean wait, WaitMode mode) {
        Map<Integer, ZooKeeperMachine> result = null;
        while (result == null) {
            result = this.getAllMachinesInner(wait, mode);
        }
        return result;
    }

    protected Map<Integer, ZooKeeperMachine> getAllMachinesInner(boolean wait, WaitMode mode) {
        if (wait) {
            this.waitForSyncConnected(mode);
        }
        try {
            int mySequenceNumber = -1;
            try {
                mySequenceNumber = Integer.parseInt(this.getSequenceNr());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.writeFlush(this.getMyMachineId());
            long endTime = System.currentTimeMillis() + this.sessionTimeout;
            block11: do {
                Thread.sleep(100L);
                HashMap<Integer, ZooKeeperMachine> result = new HashMap<Integer, ZooKeeperMachine>();
                String root = this.getRoot();
                List children = this.getZooKeeper(true).getChildren(root, false);
                for (String child : children) {
                    Pair<Integer, Integer> parsedChild = this.parseChild(child);
                    if (parsedChild == null) continue;
                    try {
                        int id = (Integer)parsedChild.first();
                        int seq = (Integer)parsedChild.other();
                        Pair<Long, Integer> instanceData = this.readDataRepresentingInstance(root + "/" + child);
                        long lastCommittedTxId = (Long)instanceData.first();
                        int masterId = (Integer)instanceData.other();
                        if (id == this.getMyMachineId() && mySequenceNumber == -1) continue;
                        if (lastCommittedTxId == -2L) continue block11;
                        if (result.containsKey(id) && seq <= ((ZooKeeperMachine)result.get(id)).getSequenceId()) continue;
                        Machine haServer = this.getHaServer(id, wait);
                        ZooKeeperMachine toAdd = new ZooKeeperMachine(id, seq, lastCommittedTxId, masterId, haServer.getServerAsString(), haServer.getBackupPort(), "ha-servers/" + id);
                        result.put(id, toAdd);
                    }
                    catch (KeeperException inner) {
                        if (inner.code() == KeeperException.Code.NONODE) continue;
                        throw new ZooKeeperException("Unable to get master.", inner);
                    }
                }
                HashMap<Integer, ZooKeeperMachine> hashMap = result;
                return hashMap;
            } while (System.currentTimeMillis() < endTime);
            Map<Integer, ZooKeeperMachine> map = null;
            return map;
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to get master", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted.", e);
        }
        finally {
            this.writeFlush(-6);
        }
    }

    protected Machine getHaServer(int machineId, boolean wait) {
        if (machineId == this.machineId) {
            return this.asMachine;
        }
        Machine result = this.haServersCache.get(machineId);
        if (result == null) {
            result = this.readHaServer(machineId, wait);
            this.haServersCache.put(machineId, result);
        }
        return result;
    }

    public String getClusterServer() {
        return this.clusterServer;
    }

    public String getHaServer() {
        return this.haServer;
    }

    protected void refreshHaServers() throws KeeperException {
        try {
            HashSet<Integer> visitedChildren = new HashSet<Integer>();
            for (String child : this.getZooKeeper(true).getChildren(this.getRoot() + "/" + HA_SERVERS_CHILD, false)) {
                int id;
                try {
                    id = this.idFromPath(child);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                this.haServersCache.put(id, this.readHaServer(id, false));
                visitedChildren.add(id);
            }
            this.haServersCache.keySet().retainAll(visitedChildren);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    protected Iterable<Machine> getHaServers() {
        return this.haServersCache.values();
    }

    protected int getNumberOfServers() {
        return this.haServersCache.size();
    }

    protected Machine readHaServer(int machineId, boolean wait) {
        if (wait) {
            this.waitForSyncConnected();
        }
        String rootPath = this.getRoot();
        String haServerPath = rootPath + "/" + HA_SERVERS_CHILD + "/" + machineId;
        try {
            byte[] serverData = this.getZooKeeper(true).getData(haServerPath, false, null);
            ByteBuffer buffer = ByteBuffer.wrap(serverData);
            int backupPort = buffer.getInt();
            byte length = buffer.get();
            char[] chars = new char[length];
            buffer.asCharBuffer().get(chars);
            String result = String.valueOf(chars);
            this.log("Read HA server:" + result + " (for machineID " + machineId + ") from zoo keeper");
            return new Machine(machineId, 0, 0L, 0, result, backupPort);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Couldn't find the HA server: " + rootPath, e);
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    private void log(String string) {
        if (this.msgLog != null) {
            this.msgLog.logMessage(string);
        }
    }

    public final void waitForSyncConnected() {
        this.waitForSyncConnected(WaitMode.SESSION);
    }

    protected int getSessionTimeout() {
        return (int)this.sessionTimeout;
    }

    private String getServersAsString() {
        if (this.servers.size() == 0) {
            return "";
        }
        StringBuilder string = new StringBuilder(this.servers.get(0).toString());
        for (int i = 1; i < this.servers.size(); ++i) {
            string.append(",").append(this.servers.get(i).toString());
        }
        return string.toString();
    }

    protected int idFromPath(String path) {
        return Integer.parseInt(path.substring(path.lastIndexOf(47) + 1));
    }

    private void writeFlush(int toWrite) {
        String path = this.getRoot() + "/" + FLUSH_REQUESTED_CHILD;
        byte[] data = new byte[4];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.putInt(toWrite);
        boolean created = false;
        try {
            block9: {
                if (this.getZooKeeper(true).exists(path, false) == null) {
                    try {
                        this.getZooKeeper(true).create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                        created = true;
                    }
                    catch (KeeperException inner) {
                        if (inner.code() == KeeperException.Code.NODEEXISTS) break block9;
                        throw inner;
                    }
                }
            }
            if (!created) {
                int current = ByteBuffer.wrap(this.getZooKeeper(true).getData(path, false, null)).getInt();
                if (current != -6 && toWrite == -6 && current != this.getMyMachineId()) {
                    this.msgLog.logMessage("Conflicted with " + current + " on getAllMachines() - will reset but waiting a bit");
                    Thread.sleep(300L);
                }
                if (current != toWrite) {
                    this.msgLog.logMessage("Writing at flush-requested: " + toWrite);
                    this.getZooKeeper(true).setData(path, data, -1);
                }
            }
            this.getZooKeeper(true).getData(path, true, null);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to write to flush-requested", e);
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Interrupted while trying to write to flush-requested", e);
        }
    }

    private static class StartupWaitStrategy
    implements WaitStrategy {
        static final long SECONDS_TO_WAIT_BETWEEN_NOTIFICATIONS = 30L;
        private long lastNotification = 0L;
        private final StringLogger msgLog;

        public StartupWaitStrategy(StringLogger msgLog) {
            this.msgLog = msgLog;
        }

        @Override
        public boolean waitMore(long waitedSoFar) {
            long currentNotification = waitedSoFar / 30000L;
            if (currentNotification > this.lastNotification) {
                this.lastNotification = currentNotification;
                this.msgLog.logMessage("Have been waiting for " + 30L * currentNotification + " seconds for the ZooKeeper cluster to respond.");
            }
            return true;
        }
    }

    private static class SessionWaitStrategy
    implements WaitStrategy {
        private final long sessionTimeout;

        SessionWaitStrategy(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Override
        public boolean waitMore(long waitedSoFar) {
            return waitedSoFar < this.sessionTimeout;
        }
    }

    static interface WaitStrategy {
        public boolean waitMore(long var1);
    }

    static enum WaitMode {
        STARTUP{

            @Override
            public WaitStrategy getStrategy(ZooClient zooClient) {
                return new StartupWaitStrategy(zooClient.msgLog);
            }
        }
        ,
        SESSION{

            @Override
            public WaitStrategy getStrategy(ZooClient zooClient) {
                return new SessionWaitStrategy(zooClient.getSessionTimeout());
            }
        };


        public abstract WaitStrategy getStrategy(ZooClient var1);
    }

    private class CompatibilitySlaveOnlyTxIdUpdater
    extends AbstractTxIdUpdater {
        private CompatibilitySlaveOnlyTxIdUpdater() {
        }

        @Override
        public void init() {
            ZooClient.this.writeData(-1L, -1);
            ZooClient.this.msgLog.logMessage("Set to defaults (-1 for txid, -1 for master) since we are running in compatibility mode, while at txid " + ZooClient.this.committedTx);
        }
    }

    private class NoUpdateTxIdUpdater
    extends AbstractTxIdUpdater {
        private NoUpdateTxIdUpdater() {
        }

        @Override
        public void init() {
            ZooClient.this.writeData(-2L, -2);
            ZooClient.this.msgLog.logMessage("Stopping flushing of txids to zk, while at txid " + ZooClient.this.committedTx);
        }
    }

    private abstract class AbstractTxIdUpdater
    implements TxIdUpdater {
        private AbstractTxIdUpdater() {
        }

        @Override
        public void updatedTxId(long txId) {
        }
    }

    private static interface TxIdUpdater {
        public void updatedTxId(long var1);

        public void init();
    }

    private class WatcherImpl
    implements Watcher {
        private final Queue<WatchedEvent> unprocessedEvents = new LinkedList<WatchedEvent>();
        private final ExecutorService threadPool = Executors.newCachedThreadPool();
        private final AtomicInteger count = new AtomicInteger(0);
        private volatile boolean electionHappening = false;

        private WatcherImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void flushUnprocessedEvents(ZooKeeper zooKeeper) {
            Queue<WatchedEvent> queue = this.unprocessedEvents;
            synchronized (queue) {
                WatchedEvent e = null;
                while ((e = this.unprocessedEvents.poll()) != null) {
                    this.runEventInThread(e, zooKeeper);
                }
            }
        }

        public void shutdown() {
            this.threadPool.shutdown();
            try {
                this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                ZooClient.this.msgLog.logMessage(ZooClient.this + " couldn't flush pending events in time " + "during shutdown", true);
            }
            ZooClient.this.log("zoo watcher shut down");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            Queue<WatchedEvent> queue = this.unprocessedEvents;
            synchronized (queue) {
                if (ZooClient.this.zooKeeper == null || !this.unprocessedEvents.isEmpty()) {
                    this.unprocessedEvents.add(event);
                    return;
                }
            }
            this.runEventInThread(event, ZooClient.this.zooKeeper);
        }

        private synchronized void runEventInThread(final WatchedEvent event, final ZooKeeper zoo) {
            if (ZooClient.this.shutdown) {
                return;
            }
            if (this.count.get() > 10) {
                ZooClient.this.msgLog.logMessage("Thread count is already at " + this.count.get() + " and added another ZK event handler thread.");
            }
            this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    WatcherImpl.this.processEvent(event, zoo);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvent(WatchedEvent event, ZooKeeper zooKeeper) {
            block35: {
                try {
                    this.count.incrementAndGet();
                    String path = event.getPath();
                    ZooClient.this.msgLog.logMessage(this + ", " + new Date() + " Got event: " + event + " " + "(path=" + path + ")", true);
                    if (path == null && event.getState() == Watcher.Event.KeeperState.Expired) {
                        ZooClient.this.keeperState = Watcher.Event.KeeperState.Expired;
                        Listeners.notifyListeners((Iterable)ZooClient.this.zooListeners, (Listeners.Notification)new Listeners.Notification<ZooListener>(){

                            public void notify(ZooListener listener) {
                                listener.reconnect();
                            }
                        });
                        break block35;
                    }
                    if (path == null && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                        long newSessionId = zooKeeper.getSessionId();
                        if (newSessionId != ZooClient.this.sessionId) {
                            ZooClient.this.sequenceNr = ZooClient.this.setup();
                            ZooClient.this.msgLog.logMessage("Did setup, seq=" + ZooClient.this.sequenceNr + " new sessionId=" + newSessionId);
                            int previousMaster = ZooClient.this.getCurrentMasterNotify();
                            if (ZooClient.this.sessionId != -1L) {
                                Listeners.notifyListeners((Iterable)ZooClient.this.zooListeners, (Listeners.Notification)new Listeners.Notification<ZooListener>(){

                                    public void notify(ZooListener listener) {
                                        listener.newMasterRequired();
                                    }
                                });
                                if (ZooClient.this.getCurrentMasterNotify() == ZooClient.this.getMyMachineId() && previousMaster == ZooClient.this.getMyMachineId()) {
                                    ZooClient.this.setDataChangeWatcher(ZooClient.MASTER_REBOUND_CHILD, ZooClient.this.getMyMachineId(), false);
                                }
                            }
                            ZooClient.this.sessionId = newSessionId;
                            ZooClient.this.keeperState = Watcher.Event.KeeperState.SyncConnected;
                            if (ZooClient.this.checkCompatibilityMode()) {
                                ZooClient.this.msgLog.logMessage("Discovered compatibility node, will remain in compatibility mode until the node is removed");
                                ZooClient.this.updater = new CompatibilitySlaveOnlyTxIdUpdater();
                            } else {
                                ZooClient.this.msgLog.logMessage("Was the only one in the cluster, restarting in Paxos mode");
                                Listeners.notifyListeners((Iterable)ZooClient.this.compatibilityListeners, (Listeners.Notification)new Listeners.Notification<CompatibilityModeListener>(){

                                    public void notify(CompatibilityModeListener listener) {
                                        listener.leftCompatibilityMode();
                                    }
                                });
                            }
                        } else {
                            ZooClient.this.msgLog.logMessage("SyncConnected with same session id: " + ZooClient.this.sessionId);
                            ZooClient.this.keeperState = Watcher.Event.KeeperState.SyncConnected;
                        }
                        break block35;
                    }
                    if (path == null && event.getState() == Watcher.Event.KeeperState.Disconnected) {
                        ZooClient.this.keeperState = Watcher.Event.KeeperState.Disconnected;
                        break block35;
                    }
                    if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                        ZooClient.this.msgLog.logMessage("Got a NodeDeleted event for " + path);
                        ZooKeeperMachine currentMaster = (ZooKeeperMachine)ZooClient.this.getCachedMaster();
                        if (path.contains(currentMaster.getZooKeeperPath()) && ZooClient.this.checkCompatibilityMode()) {
                            ZooClient.this.msgLog.logMessage("Acting on it, calling newMaster()");
                            Listeners.notifyListeners((Iterable)ZooClient.this.zooListeners, (Listeners.Notification)new Listeners.Notification<ZooListener>(){

                                public void notify(ZooListener listener) {
                                    listener.newMasterRequired();
                                }
                            });
                        }
                        break block35;
                    }
                    if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                        if (path.endsWith(ZooClient.HA_SERVERS_CHILD)) {
                            try {
                                ZooClient.this.refreshHaServers();
                                ZooClient.this.subscribeToChildrenChangeWatcher(ZooClient.HA_SERVERS_CHILD);
                            }
                            catch (ZooKeeperException e) {}
                        } else if (path.endsWith(ZooClient.COMPATIBILITY_CHILD_19)) {
                            ZooClient.this.msgLog.logMessage("-> got compatibility event");
                            ZooClient.this.subscribeToChildrenChangeWatcher(ZooClient.COMPATIBILITY_CHILD_19);
                        }
                        if (!ZooClient.this.checkCompatibilityMode()) {
                            ZooClient.this.msgLog.logMessage("No longer in compatibility mode, notifying listeners");
                            Listeners.notifyListeners((Iterable)ZooClient.this.compatibilityListeners, (Listeners.Notification)new Listeners.Notification<CompatibilityModeListener>(){

                                public void notify(CompatibilityModeListener listener) {
                                    listener.leftCompatibilityMode();
                                }
                            });
                        }
                        break block35;
                    }
                    if (event.getType() != Watcher.Event.EventType.NodeDataChanged) break block35;
                    int updatedData = ZooClient.this.toInt(ZooClient.this.getZooKeeper(true).getData(path, true, null));
                    ZooClient.this.msgLog.logMessage("Got event data " + updatedData);
                    if (path.contains(ZooClient.MASTER_NOTIFY_CHILD)) {
                        if (updatedData != ZooClient.this.machineId || this.electionHappening) break block35;
                        try {
                            this.electionHappening = true;
                            Listeners.notifyListeners((Iterable)ZooClient.this.zooListeners, (Listeners.Notification)new Listeners.Notification<ZooListener>(){

                                public void notify(ZooListener listener) {
                                    listener.masterNotify();
                                }
                            });
                            break block35;
                        }
                        finally {
                            this.electionHappening = false;
                        }
                    }
                    if (path.contains(ZooClient.MASTER_REBOUND_CHILD)) {
                        if (updatedData == ZooClient.this.machineId || this.electionHappening) break block35;
                        try {
                            this.electionHappening = true;
                            Listeners.notifyListeners((Iterable)ZooClient.this.zooListeners, (Listeners.Notification)new Listeners.Notification<ZooListener>(){

                                public void notify(ZooListener listener) {
                                    listener.masterRebound();
                                }
                            });
                            break block35;
                        }
                        finally {
                            this.electionHappening = false;
                        }
                    }
                    if (path.contains(ZooClient.FLUSH_REQUESTED_CHILD)) {
                        if (updatedData == -6) {
                            ZooClient.this.stopFlushing();
                        } else {
                            ZooClient.this.startFlushing();
                        }
                    } else {
                        ZooClient.this.msgLog.logMessage("Unrecognized data change " + path);
                    }
                }
                catch (Throwable e) {
                    ZooClient.this.msgLog.logMessage("Error in ZooClient.process", e, true);
                    throw Exceptions.launderedException((Throwable)e);
                }
                finally {
                    ZooClient.this.msgLog.flush();
                    this.count.decrementAndGet();
                }
            }
        }
    }
}

