/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.upgrade;

import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ha.upgrade.LegacyDatabase;
import org.neo4j.ha.upgrade.Utils;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Exceptions;
import org.neo4j.shell.impl.RmiLocation;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.tooling.GlobalGraphOperations;

public class LegacyDatabaseImpl
extends UnicastRemoteObject
implements LegacyDatabase {
    private GraphDatabaseService db;
    private String storeDir;

    public static void main(String[] args) throws Exception {
        Args arguments = new Args(args);
        File storeDir = new File((String)arguments.orphans().get(0));
        GraphDatabaseService db = (GraphDatabaseService)Class.forName("org.neo4j.kernel.HighlyAvailableGraphDatabase").getConstructor(String.class, Map.class).newInstance(storeDir.getAbsolutePath(), arguments.asMap());
        LegacyDatabaseImpl legacyDb = new LegacyDatabaseImpl(storeDir.getAbsolutePath(), db);
        LegacyDatabaseImpl.rmiLocation(Integer.parseInt((String)arguments.orphans().get(1))).bind((Remote)legacyDb);
    }

    public LegacyDatabaseImpl(String storeDir, GraphDatabaseService db) throws RemoteException {
        this.storeDir = storeDir;
        this.db = db;
    }

    public static LegacyDatabase start(String classpath, File storeDir, Map<String, String> config) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add(storeDir.getAbsolutePath());
        int rmiPort = 7000 + Integer.parseInt(config.get("ha.server_id"));
        args.add("" + rmiPort);
        args.addAll(Arrays.asList(new Args(config).asArgs()));
        Process process = Utils.execJava(LegacyDatabaseImpl.appendNecessaryTestClasses(classpath), LegacyDatabaseImpl.class.getName(), args.toArray(new String[0]));
        new ProcessStreamHandler(process, false).launch();
        RmiLocation rmiLocation = LegacyDatabaseImpl.rmiLocation(rmiPort);
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10000L);
        while (System.currentTimeMillis() < endTime) {
            try {
                return (LegacyDatabase)rmiLocation.getBoundObject();
            }
            catch (RemoteException e) {
                Thread.sleep(100L);
            }
        }
        process.destroy();
        throw new IllegalStateException("Couldn't get remote to legacy database");
    }

    private static String appendNecessaryTestClasses(String classpath) {
        for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (!path.contains("test-classes")) continue;
            classpath = classpath + File.pathSeparator + path;
        }
        return classpath;
    }

    private static RmiLocation rmiLocation(int rmiPort) {
        return RmiLocation.location((String)"127.0.0.1", (int)rmiPort, (String)"remote");
    }

    @Override
    public int stop() {
        this.db.shutdown();
        System.exit(0);
        return 0;
    }

    @Override
    public String getStoreDir() {
        return this.storeDir;
    }

    @Override
    public void awaitStarted(long time, TimeUnit unit) {
        this.db.beginTx().finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createNode(String name) {
        Transaction tx = this.db.beginTx();
        try {
            Node node = this.db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public void verifyNodeExists(long id, String name) {
        try {
            this.db.getClass().getDeclaredMethod("pullUpdates", new Class[0]).invoke((Object)this.db, new Object[0]);
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)this.db).getAllNodes()) {
            if (!name.equals(node.getProperty("name", null))) continue;
            return;
        }
        Assert.fail((String)("Node " + id + " with name '" + name + "' not found"));
    }
}

