/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class SchemaIndexHaIT {
    private final File storeDir = TargetDirectory.forTest(this.getClass()).graphDbDir(true);
    private ClusterManager clusterManager;
    private final String key = "key";
    private final Label label = DynamicLabel.label((String)"label");
    public static final SchemaIndexProvider.Descriptor CONTROLLED_PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("controlled", "1.0");

    @Test
    public void creatingIndexOnMasterShouldHaveSlavesBuildItAsWell() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.startCluster(ClusterManager.clusterOfSize(3));
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        Map<Object, Node> data = this.createSomeData((GraphDatabaseService)master);
        IndexDefinition index = this.createIndex((GraphDatabaseService)master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        SchemaIndexHaIT.awaitIndexOnline(index, cluster, data);
    }

    @Test
    public void creatingIndexOnSlaveShouldHaveOtherSlavesAndMasterBuiltItAsWell() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.startCluster(ClusterManager.clusterOfSize(3));
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        Map<Object, Node> data = this.createSomeData((GraphDatabaseService)master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        IndexDefinition index = this.createIndex((GraphDatabaseService)slave);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        SchemaIndexHaIT.awaitIndexOnline(index, cluster, data);
    }

    @Test
    public void indexPopulationJobsShouldContinueThroughRoleSwitch() throws Throwable {
        ControlledGraphDatabaseFactory dbFactory = new ControlledGraphDatabaseFactory();
        ClusterManager.ManagedCluster cluster = this.startCluster(ClusterManager.clusterOfSize(3), dbFactory);
        HighlyAvailableGraphDatabase firstMaster = cluster.getMaster();
        Map<Object, Node> data = this.createSomeData((GraphDatabaseService)firstMaster);
        this.createIndex((GraphDatabaseService)firstMaster);
        dbFactory.triggerFinish((GraphDatabaseService)firstMaster);
        HighlyAvailableGraphDatabase aSlave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ((UpdatePuller)aSlave.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        dbFactory.awaitPopulationStarted((GraphDatabaseService)aSlave);
        cluster.shutdown(firstMaster);
        dbFactory.triggerFinish((GraphDatabaseService)aSlave);
        cluster.await(ClusterManager.masterAvailable(firstMaster));
        HighlyAvailableGraphDatabase newMaster = cluster.getMaster();
        Assert.assertEquals((String)"Unexpected new master", (Object)aSlave, (Object)newMaster);
        try (Transaction tx = newMaster.beginTx();){
            IndexDefinition index = (IndexDefinition)IteratorUtil.single((Iterable)newMaster.schema().getIndexes());
            SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)newMaster, data);
            tx.success();
        }
    }

    private ClusterManager.ManagedCluster startCluster(ClusterManager.Provider provider) throws Throwable {
        return this.startCluster(provider, new HighlyAvailableGraphDatabaseFactory());
    }

    private ClusterManager.ManagedCluster startCluster(ClusterManager.Provider provider, HighlyAvailableGraphDatabaseFactory dbFactory) throws Throwable {
        this.clusterManager = new ClusterManager(provider, this.storeDir, MapUtil.stringMap((String[])new String[]{ClusterSettings.default_timeout.name(), "1s", HaSettings.tx_push_factor.name(), "0"}), new HashMap<Integer, Map<String, String>>(), dbFactory);
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        return cluster;
    }

    @After
    public void after() throws Throwable {
        if (this.clusterManager != null) {
            this.clusterManager.stop();
        }
    }

    private Map<Object, Node> createSomeData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            HashMap<Object, Node> result = new HashMap<Object, Node>();
            for (int i = 0; i < 10; ++i) {
                Node node = db.createNode(new Label[]{this.label});
                Integer propertyValue = i;
                node.setProperty("key", (Object)propertyValue);
                result.put(propertyValue, node);
            }
            tx.success();
            HashMap<Object, Node> hashMap = result;
            return hashMap;
        }
    }

    private IndexDefinition createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = db.schema().indexFor(this.label).on("key").create();
            tx.success();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    private static void awaitIndexOnline(IndexDefinition index, ClusterManager.ManagedCluster cluster, Map<Object, Node> expectedDdata) throws InterruptedException {
        for (GraphDatabaseService graphDatabaseService : cluster.getAllMembers()) {
            SchemaIndexHaIT.awaitIndexOnline(index, graphDatabaseService, expectedDdata);
        }
    }

    private static IndexDefinition reHomedIndexDefinition(GraphDatabaseService db, IndexDefinition definition) {
        for (IndexDefinition candidate : db.schema().getIndexes()) {
            if (!candidate.equals(definition)) continue;
            return candidate;
        }
        throw new NoSuchElementException("New database doesn't have requested index");
    }

    private static void awaitIndexOnline(IndexDefinition requestedIndex, GraphDatabaseService db, Map<Object, Node> expectedData) throws InterruptedException {
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = SchemaIndexHaIT.reHomedIndexDefinition(db, requestedIndex);
            long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
            while (!SchemaIndexHaIT.indexOnline(index, db)) {
                Thread.sleep(1L);
                if (System.currentTimeMillis() <= timeout) continue;
                Assert.fail((String)"Expected index to come online within a reasonable time.");
            }
            SchemaIndexHaIT.assertIndexContents(index, db, expectedData);
            tx.success();
        }
    }

    private static void assertIndexContents(IndexDefinition index, GraphDatabaseService db, Map<Object, Node> expectedData) {
        for (Map.Entry<Object, Node> entry : expectedData.entrySet()) {
            Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{entry.getValue()}), (Object)IteratorUtil.asUniqueSet((Iterable)db.findNodesByLabelAndProperty(index.getLabel(), (String)IteratorUtil.single((Iterable)index.getPropertyKeys()), entry.getKey())));
        }
    }

    private static boolean indexOnline(IndexDefinition index, GraphDatabaseService db) {
        try {
            return db.schema().getIndexState(index) == Schema.IndexState.ONLINE;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    protected static GraphDatabaseBuilder dbReferenceCapturingBuilder(final Map<GraphDatabaseService, ControlledSchemaIndexProvider> perDbIndexProvider, final ControlledSchemaIndexProvider provider, GraphDatabaseBuilder actual) {
        return new GraphDatabaseBuilder.Delegator(actual){

            public GraphDatabaseService newGraphDatabase() {
                GraphDatabaseService db = super.newGraphDatabase();
                perDbIndexProvider.put(db, provider);
                return db;
            }
        };
    }

    private static class ControlledGraphDatabaseFactory
    extends HighlyAvailableGraphDatabaseFactory {
        final Map<GraphDatabaseService, ControlledSchemaIndexProvider> perDbIndexProvider = new ConcurrentHashMap<GraphDatabaseService, ControlledSchemaIndexProvider>();

        private ControlledGraphDatabaseFactory() {
        }

        public GraphDatabaseBuilder newHighlyAvailableDatabaseBuilder(String path) {
            ControlledSchemaIndexProvider provider = new ControlledSchemaIndexProvider();
            KernelExtensionFactory factory = SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory((String)"controlled", (SchemaIndexProvider)provider);
            this.getCurrentState().addKernelExtensions(Arrays.asList(factory));
            return SchemaIndexHaIT.dbReferenceCapturingBuilder(this.perDbIndexProvider, provider, super.newHighlyAvailableDatabaseBuilder(path));
        }

        void awaitPopulationStarted(GraphDatabaseService db) {
            DoubleLatch latch = this.perDbIndexProvider.get(db).latch;
            latch.awaitStart();
        }

        void triggerFinish(GraphDatabaseService db) {
            ControlledSchemaIndexProvider provider = this.perDbIndexProvider.get(db);
            provider.latch.finish();
        }
    }

    private static class ControlledSchemaIndexProvider
    extends SchemaIndexProvider {
        private final SchemaIndexProvider inMemoryDelegate = new InMemoryIndexProvider();
        private final DoubleLatch latch = new DoubleLatch();

        public ControlledSchemaIndexProvider() {
            super(CONTROLLED_PROVIDER_DESCRIPTOR, 100);
        }

        public IndexPopulator getPopulator(long indexId, IndexConfiguration config) {
            return new ControlledIndexPopulator(this.inMemoryDelegate.getPopulator(indexId, config), this.latch);
        }

        public IndexAccessor getOnlineAccessor(long indexId, IndexConfiguration config) throws IOException {
            return this.inMemoryDelegate.getOnlineAccessor(indexId, config);
        }

        public InternalIndexState getInitialState(long indexId) {
            return this.inMemoryDelegate.getInitialState(indexId);
        }

        public String getPopulationFailure(long indexId) throws IllegalStateException {
            return this.inMemoryDelegate.getPopulationFailure(indexId);
        }
    }

    private static class ControlledIndexPopulator
    extends IndexPopulator.Adapter {
        private final DoubleLatch latch;
        private final IndexPopulator inMemoryDelegate;

        public ControlledIndexPopulator(IndexPopulator inMemoryDelegate, DoubleLatch latch) {
            this.inMemoryDelegate = inMemoryDelegate;
            this.latch = latch;
        }

        public void add(long nodeId, Object propertyValue) throws IndexEntryConflictException, IOException {
            this.inMemoryDelegate.add(nodeId, propertyValue);
            this.latch.startAndAwaitFinish();
        }

        public void close(boolean populationCompletedSuccessfully) throws IOException {
            this.inMemoryDelegate.close(populationCompletedSuccessfully);
            Assert.assertTrue((boolean)populationCompletedSuccessfully);
            this.latch.finish();
        }
    }
}

