/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.management.ClusterMemberInfo;

public class ClusterMemberMatcher
extends BaseMatcher<Iterable<ClusterMemberInfo>> {
    private boolean trueForExactFalseForContains;
    private ClusterMemberMatch[] expectedMembers;

    public ClusterMemberMatcher(boolean trueForExactFalseForContains, ClusterMemberMatch[] expected) {
        this.trueForExactFalseForContains = trueForExactFalseForContains;
        this.expectedMembers = expected;
    }

    public void describeTo(Description description) {
        description.appendText(Arrays.toString(this.expectedMembers));
    }

    public static Matcher<ClusterMember> sameMemberAs(final ClusterMember clusterMember) {
        return new BaseMatcher<ClusterMember>(){

            public boolean matches(Object instance) {
                HashSet clusterMemberUris;
                if (!(instance instanceof ClusterMember)) {
                    return false;
                }
                ClusterMember member = (ClusterMember)ClusterMember.class.cast(instance);
                if (!member.getMemberId().equals((Object)clusterMember.getMemberId())) {
                    return false;
                }
                if (!member.isAlive() == clusterMember.isAlive()) {
                    return false;
                }
                HashSet memberUris = new HashSet(Iterables.toList((Iterable)member.getRoleURIs()));
                return memberUris.equals(clusterMemberUris = new HashSet(Iterables.toList((Iterable)clusterMember.getRoleURIs())));
            }

            public void describeTo(Description description) {
                description.appendText("member should match ").appendValue((Object)clusterMember);
            }
        };
    }

    public boolean matches(Object item) {
        if (!(item instanceof Iterable)) {
            return false;
        }
        Iterable other = (Iterable)item;
        int foundCount = 0;
        for (ClusterMemberMatch expectedMember : this.expectedMembers) {
            boolean found = false;
            for (ClusterMemberInfo member : other) {
                if (!expectedMember.match(member)) continue;
                found = true;
                ++foundCount;
                break;
            }
            if (found) continue;
            return false;
        }
        return !this.trueForExactFalseForContains || foundCount == this.expectedMembers.length;
    }

    public static ClusterMemberMatch member(URI member) {
        return new ClusterMemberMatch(member);
    }

    public static ClusterMemberMatcher containsMembers(ClusterMemberMatch ... expected) {
        return new ClusterMemberMatcher(false, expected);
    }

    public static ClusterMemberMatcher containsOnlyMembers(ClusterMemberMatch ... expected) {
        return new ClusterMemberMatcher(true, expected);
    }

    public static class ClusterMemberMatch {
        private URI member;
        private Boolean available;
        private Boolean alive;
        private String haRole;
        private Set<String> uris;

        ClusterMemberMatch(URI member) {
            this.member = member;
        }

        public ClusterMemberMatch available(boolean available) {
            this.available = available;
            return this;
        }

        public ClusterMemberMatch alive(boolean alive) {
            this.alive = alive;
            return this;
        }

        private boolean match(ClusterMemberInfo toMatch) {
            if (!this.member.toString().equals(toMatch.getInstanceId())) {
                return false;
            }
            if (this.available != null && toMatch.isAvailable() != this.available.booleanValue()) {
                return false;
            }
            if (this.alive != null && toMatch.isAlive() != this.alive.booleanValue()) {
                return false;
            }
            if (this.haRole != null && !this.haRole.equals(toMatch.getHaRole())) {
                return false;
            }
            return this.uris == null || this.uris.equals(new HashSet<String>(Arrays.asList(toMatch.getUris())));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Member[" + this.member);
            if (this.available != null) {
                builder.append(", available:" + this.available);
            }
            if (this.alive != null) {
                builder.append(", alive:" + this.alive);
            }
            if (this.haRole != null) {
                builder.append(", haRole:" + this.haRole);
            }
            if (this.uris != null) {
                builder.append(", uris:" + this.uris);
            }
            return builder.append("]").toString();
        }

        public ClusterMemberMatch haRole(String role) {
            this.haRole = role;
            return this;
        }

        public ClusterMemberMatch uris(URI ... uris) {
            this.uris = new HashSet<String>();
            for (URI uri : uris) {
                this.uris.add(uri.toString());
            }
            return this;
        }
    }
}

