/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;
import org.neo4j.tooling.GlobalGraphOperations;

public class HighAvailabilitySlavesIT {
    private final TargetDirectory DIR = TargetDirectory.forTest(this.getClass());
    private ClusterManager clusterManager;

    @After
    public void after() throws Throwable {
        this.clusterManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void transactionsGetsPushedToSlaves() throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), this.DIR.directory("dbs", true), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"}));
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        String name = "a node";
        long node = this.createNode(cluster.getMaster(), name);
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
            Transaction transaction = db.beginTx();
            try {
                Assert.assertEquals((long)node, (long)this.getNodeByName(db, name));
            }
            finally {
                transaction.finish();
            }
        }
    }

    private long getNodeByName(HighlyAvailableGraphDatabase db, String name) {
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
            if (!name.equals(node.getProperty("name", null))) continue;
            return node.getId();
        }
        Assert.fail((String)("No node '" + name + "' found in " + db));
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNode(HighlyAvailableGraphDatabase db, String name) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }
}

