/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.kernel.ha.InstanceAccessGuard;
import org.neo4j.kernel.logging.ConsoleLogger;

public class HighAvailabilityConsoleLogger
implements ClusterMemberListener,
ClusterListener,
InstanceAccessGuard.AccessListener {
    private ConsoleLogger console;

    public HighAvailabilityConsoleLogger(ConsoleLogger console) {
        this.console = console;
    }

    public void enteredCluster(ClusterConfiguration clusterConfiguration) {
        this.console.log("Joined cluster:" + clusterConfiguration);
    }

    public void leftCluster() {
        this.console.log("Left cluster");
    }

    public void joinedCluster(InstanceId instanceId, URI member) {
        this.console.log("Instance " + instanceId + " joined the cluster");
    }

    public void leftCluster(InstanceId instanceId) {
        this.console.log("Instance " + instanceId + " left the cluster");
    }

    public void elected(String role, InstanceId instanceId, URI electedMember) {
        this.console.log("Instance " + instanceId + " was elected as " + role);
    }

    public void unelected(String role, InstanceId instanceId, URI electedMember) {
        this.console.log("Instance " + instanceId + " was demoted as " + role);
    }

    public void coordinatorIsElected(InstanceId coordinatorId) {
    }

    public void memberIsAvailable(String role, InstanceId availableId, URI atUri) {
        this.console.log("Instance " + availableId + " is available as " + role + " at " + atUri.toASCIIString());
    }

    public void memberIsUnavailable(String role, InstanceId unavailableId) {
        this.console.log("Instance " + unavailableId + " is unavailable as " + role);
    }

    public void memberIsFailed(InstanceId instanceId) {
        this.console.log("Instance " + instanceId + " has failed");
    }

    public void memberIsAlive(InstanceId instanceId) {
        this.console.log("Instance " + instanceId + " is alive");
    }

    @Override
    public void accessGranted() {
        this.console.log("Database access granted");
    }

    @Override
    public void accessDenied() {
        this.console.log("Database access denied");
    }
}

