/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.GcrSettings;
import org.neo4j.test.TestGraphDatabaseFactory;

@Ignore(value="Impermanent graph database doesn't use GC resistant cache")
public class TestCacheObjectReuse {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gcrCachesCanBeReusedBetweenSessions() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "gcr").newGraphDatabase();
        Cache firstCache = (Cache)IteratorUtil.first((Iterable)db.getNodeManager().caches());
        db.shutdown();
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "gcr").newGraphDatabase();
        try {
            Cache secondCache = (Cache)IteratorUtil.first((Iterable)db.getNodeManager().caches());
            Assert.assertEquals((Object)firstCache, (Object)secondCache);
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gcrCachesAreRecreatedBetweenSessionsIfConfigChanges() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "gcr").newGraphDatabase();
        Cache firstCache = (Cache)IteratorUtil.first((Iterable)db.getNodeManager().caches());
        db.shutdown();
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "gcr").setConfig(GcrSettings.node_cache_array_fraction, "10").newGraphDatabase();
        try {
            Cache secondCache = (Cache)IteratorUtil.first((Iterable)db.getNodeManager().caches());
            Assert.assertFalse((boolean)firstCache.equals(secondCache));
        }
        finally {
            db.shutdown();
        }
    }
}

