/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;
import org.neo4j.kernel.impl.cache.GCResistantCache;

public class TestGCResistantCache {
    private GCResistantCache<Entity> cache;

    @Before
    public void setup() {
        this.cache = new GCResistantCache(new AtomicReferenceArray(10));
    }

    @Test
    public void assertThatPutPutsSomething() {
        long key = 5L;
        Entity entity = new Entity(key, 10);
        this.cache.put((EntityWithSizeObject)entity);
        Assert.assertEquals((Object)entity, (Object)this.cache.get(key));
    }

    @Test
    public void assertThatRemoveRemovesSomething() {
        long key = 5L;
        Entity entity = new Entity(key, 10);
        this.cache.put((EntityWithSizeObject)entity);
        Assert.assertEquals((Object)entity, (Object)this.cache.get(key));
        this.cache.remove(key);
        Assert.assertEquals(null, (Object)this.cache.get(key));
    }

    @Test
    public void assertThatPutKeepsCorrectSize() {
        this.cache = new GCResistantCache<Entity>(new AtomicReferenceArray(10)){

            protected int getPosition(EntityWithSizeObject obj) {
                return 1;
            }
        };
        int size = 10;
        SneakyEntity oldEntity = new SneakyEntity(0L, 10){

            @Override
            void doThisBadStuffInSizeCall() {
                this.updateSize(11);
                TestGCResistantCache.this.cache.updateSize((EntityWithSizeObject)this, 11);
            }
        };
        this.cache.put((EntityWithSizeObject)oldEntity);
        oldEntity.updateSize(10);
        Entity newEntity = new Entity(1L, 11);
        this.cache.put((EntityWithSizeObject)newEntity);
        Assert.assertEquals((long)11L, (long)this.cache.size());
    }

    @Test
    public void assertThatRemoveKeepsCorrectSize() {
        int size = 10;
        SneakyEntity entity = new SneakyEntity(0L, 10){

            @Override
            void doThisBadStuffInSizeCall() {
                this.updateSize(11);
                TestGCResistantCache.this.cache.updateSize((EntityWithSizeObject)this, 11);
            }
        };
        this.cache.put((EntityWithSizeObject)entity);
        entity.updateSize(10);
        this.cache.remove(entity.getId());
        Assert.assertEquals((long)0L, (long)this.cache.size());
    }

    @Test(expected=NullPointerException.class)
    public void assertNullPutTriggersNPE() {
        this.cache.put(null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void assertPutCanHandleWrongId() {
        Entity entity = new Entity(-1L, 1);
        this.cache.put((EntityWithSizeObject)entity);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void assertGetCanHandleWrongId() {
        this.cache.get(-1L);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void assertRemoveCanHandleWrongId() {
        this.cache.remove(-1L);
    }

    @Test
    public void shouldReturnExistingObjectIfDifferentObjectButSameId() throws Exception {
        int id = 10;
        Entity version1 = new Entity(id, 0);
        Assert.assertTrue((version1 == this.cache.put((EntityWithSizeObject)version1) ? 1 : 0) != 0);
        Entity version2 = new Entity(id, 0);
        Assert.assertTrue((version1 == this.cache.put((EntityWithSizeObject)version2) ? 1 : 0) != 0);
    }

    private static abstract class SneakyEntity
    extends Entity {
        SneakyEntity(long id, int size) {
            super(id, size);
        }

        @Override
        public int sizeOfObjectInBytesIncludingOverhead() {
            int size = super.sizeOfObjectInBytesIncludingOverhead();
            this.doThisBadStuffInSizeCall();
            return size;
        }

        abstract void doThisBadStuffInSizeCall();
    }

    private static class Entity
    implements EntityWithSizeObject {
        private final long id;
        private int size;
        private int registeredSize;

        Entity(long id, int size) {
            this.id = id;
            this.size = size;
        }

        public int sizeOfObjectInBytesIncludingOverhead() {
            return this.size;
        }

        public long getId() {
            return this.id;
        }

        public void updateSize(int newSize) {
            this.size = newSize;
        }

        public void setRegisteredSize(int size) {
            this.registeredSize = size;
        }

        public int getRegisteredSize() {
            return this.registeredSize;
        }
    }
}

