/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Listeners;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;

public class InstanceAccessGuard {
    private Iterable<AccessListener> listeners = Listeners.newListeners();
    private volatile CountDownLatch latch;

    public InstanceAccessGuard() {
        this.enter();
    }

    synchronized void enter() {
        if (this.latch != null) {
            return;
        }
        this.latch = new CountDownLatch(1);
        Listeners.notifyListeners(this.listeners, (Listeners.Notification)new Listeners.Notification<AccessListener>(){

            public void notify(AccessListener listener) {
                listener.accessDenied();
            }
        });
    }

    public boolean await(long millis) {
        CountDownLatch localLatch = this.latch;
        if (localLatch == null) {
            return true;
        }
        try {
            return localLatch.await(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    synchronized void exit() {
        if (this.latch == null) {
            return;
        }
        this.latch.countDown();
        this.latch = null;
        Listeners.notifyListeners(this.listeners, (Listeners.Notification)new Listeners.Notification<AccessListener>(){

            public void notify(AccessListener listener) {
                listener.accessGranted();
            }
        });
    }

    public void setState(HighAvailabilityMemberState state) {
        if (state.isAccessAllowed(null)) {
            this.exit();
        } else {
            this.enter();
        }
    }

    public void addListener(AccessListener listener) {
        this.listeners = Listeners.addListener((Object)listener, this.listeners);
    }

    public void removeListener(AccessListener listener) {
        this.listeners = Listeners.removeListener((Object)listener, this.listeners);
    }

    public static interface AccessListener {
        public void accessGranted();

        public void accessDenied();
    }
}

