/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TransactionNotPresentOnMasterException;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.ha.lock.LockableNode;
import org.neo4j.kernel.ha.lock.LockableRelationship;
import org.neo4j.kernel.ha.transaction.UnableToResumeTransactionException;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.IndexLock;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.SchemaLock;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.locking.IndexEntryLock;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;

public class MasterImpl
extends LifecycleAdapter
implements Master {
    private static final int ID_GRAB_SIZE = 1000;
    public static final int UNFINISHED_TRANSACTION_CLEANUP_DELAY = 1;
    private final GraphDatabaseAPI graphDb;
    private final StringLogger msgLog;
    private final Config config;
    private Map<RequestContext, MasterTransaction> transactions = new ConcurrentHashMap<RequestContext, MasterTransaction>();
    private ScheduledExecutorService unfinishedTransactionsExecutor;
    private long unfinishedTransactionThresholdMillis;
    private final GraphProperties graphProperties;
    private final TransactionManager txManager;
    private static LockGrabber READ_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, TransactionState state, Object entity) {
            state.acquireReadLock(entity);
        }
    };
    private static LockGrabber WRITE_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, TransactionState state, Object entity) {
            state.acquireWriteLock(entity);
        }
    };

    public MasterImpl(GraphDatabaseAPI db, Logging logging, Config config) {
        this.graphDb = db;
        this.msgLog = logging.getMessagesLog(this.getClass());
        this.config = config;
        this.graphProperties = ((NodeManager)this.graphDb.getDependencyResolver().resolveDependency(NodeManager.class)).getGraphProperties();
        this.txManager = (TransactionManager)this.graphDb.getDependencyResolver().resolveDependency(TransactionManager.class);
    }

    public void start() throws Throwable {
        this.unfinishedTransactionThresholdMillis = (Long)this.config.get(HaSettings.lock_read_timeout);
        this.unfinishedTransactionsExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Unfinished transaction reaper"));
        this.unfinishedTransactionsExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Map.Entry<RequestContext, MasterTransaction> entry : this.transactions()) {
                        long time = entry.getValue().timeLastSuspended.get();
                        if ((time == 0L || System.currentTimeMillis() - time < MasterImpl.this.unfinishedTransactionThresholdMillis) && !entry.getValue().finishAsap()) continue;
                        long displayableTime = time == 0L ? 0L : System.currentTimeMillis() - time;
                        MasterImpl.this.msgLog.logMessage("Found old tx " + entry.getKey() + ", " + "" + entry.getValue().transaction + ", " + displayableTime);
                        try {
                            Transaction otherTx = MasterImpl.this.suspendOtherAndResumeThis(entry.getKey(), false);
                            MasterImpl.this.finishThisAndResumeOther(otherTx, entry.getKey(), false);
                            MasterImpl.this.msgLog.logMessage("Rolled back old tx " + entry.getKey() + ", " + "" + entry.getValue().transaction + ", " + displayableTime);
                        }
                        catch (IllegalStateException e) {
                        }
                        catch (Throwable t) {
                            MasterImpl.this.msgLog.logMessage("Unable to roll back old tx " + entry.getKey() + ", " + "" + entry.getValue().transaction + ", " + displayableTime, t);
                        }
                    }
                }
                catch (Throwable t) {
                    MasterImpl.this.msgLog.logMessage("Exception in MasterImpl", t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Iterable<Map.Entry<RequestContext, MasterTransaction>> transactions() {
                Map transactions;
                Map map = transactions = MasterImpl.this.transactions;
                synchronized (map) {
                    return new HashMap(transactions).entrySet();
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.unfinishedTransactionsExecutor.shutdown();
        this.transactions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Void> initializeTx(RequestContext context) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context, true);
        try {
            Response<Object> response = this.packResponse(context, null);
            return response;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response<LockResult> acquireLock(RequestContext context, LockGrabber lockGrabber, Object ... entities) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context, false);
        try {
            LockManager lockManager = this.graphDb.getLockManager();
            TransactionState state = ((AbstractTransactionManager)this.graphDb.getTxManager()).getTransactionState();
            for (Object entity : entities) {
                lockGrabber.grab(lockManager, state, entity);
            }
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.OK_LOCKED));
            return response;
        }
        catch (DeadlockDetectedException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(e.getMessage()));
            return response;
        }
        catch (IllegalResourceException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.NOT_LOCKED));
            return response;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    private <T> Response<T> packResponse(RequestContext context, T response) {
        return this.packResponse(context, response, (Predicate<Long>)ServerUtil.ALL);
    }

    private <T> Response<T> packResponse(RequestContext context, T response, Predicate<Long> filter) {
        return ServerUtil.packResponse((GraphDatabaseAPI)this.graphDb, (RequestContext)context, response, filter);
    }

    private Transaction getTx(RequestContext txId) {
        MasterTransaction result = this.transactions.get(txId);
        if (result != null) {
            result.resetTime();
            return result.transaction;
        }
        return null;
    }

    private Transaction beginTx(RequestContext txId) {
        try {
            this.txManager.begin();
            Transaction tx = this.txManager.getTransaction();
            this.transactions.put(txId, new MasterTransaction(tx));
            return tx;
        }
        catch (NotSupportedException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Transaction suspendOtherAndResumeThis(RequestContext txId, boolean allowBegin) {
        try {
            Transaction otherTx = this.txManager.getTransaction();
            Transaction transaction = this.getTx(txId);
            if (otherTx != null && otherTx == transaction) {
                return null;
            }
            if (otherTx != null) {
                this.txManager.suspend();
            }
            if (transaction == null) {
                if (!allowBegin) throw new TransactionNotPresentOnMasterException("Transaction " + txId + " has either timed " + "out on the master or was not started on this master. There may have been a master " + "switch between the time this transaction started and up to now. This transaction" + " cannot continue since the state from the previous master isn't transferred.");
                this.beginTx(txId);
                return otherTx;
            }
            try {
                this.txManager.resume(transaction);
                return otherTx;
            }
            catch (IllegalStateException e) {
                throw new UnableToResumeTransactionException(e);
            }
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    void suspendThisAndResumeOther(Transaction otherTx, RequestContext txId) {
        try {
            MasterTransaction tx = this.transactions.get(txId);
            if (tx.finishAsap()) {
                this.finishThisAndResumeOther(otherTx, txId, false);
                return;
            }
            tx.updateTime();
            this.txManager.suspend();
            if (otherTx != null) {
                this.txManager.resume(otherTx);
            }
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    void finishThisAndResumeOther(Transaction otherTx, RequestContext txId, boolean success) {
        try {
            if (success) {
                this.txManager.commit();
            } else {
                this.txManager.rollback();
            }
            this.transactions.remove(txId);
            if (otherTx != null) {
                this.txManager.resume(otherTx);
            }
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    @Override
    public Response<LockResult> acquireNodeReadLock(RequestContext context, long ... nodes) {
        return this.acquireLock(context, READ_LOCK_GRABBER, this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireNodeWriteLock(RequestContext context, long ... nodes) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireRelationshipReadLock(RequestContext context, long ... relationships) {
        return this.acquireLock(context, READ_LOCK_GRABBER, this.relationshipsById(relationships));
    }

    @Override
    public Response<LockResult> acquireRelationshipWriteLock(RequestContext context, long ... relationships) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, this.relationshipsById(relationships));
    }

    @Override
    public Response<LockResult> acquireGraphReadLock(RequestContext context) {
        return this.acquireLock(context, READ_LOCK_GRABBER, this.graphProperties());
    }

    @Override
    public Response<LockResult> acquireGraphWriteLock(RequestContext context) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, this.graphProperties());
    }

    private PropertyContainer graphProperties() {
        return this.graphProperties;
    }

    private Node[] nodesById(long[] ids) {
        Node[] result = new Node[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableNode(ids[i]);
        }
        return result;
    }

    private Relationship[] relationshipsById(long[] ids) {
        Relationship[] result = new Relationship[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableRelationship(ids[i]);
        }
        return result;
    }

    @Override
    public Response<IdAllocation> allocateIds(IdType idType) {
        IdGenerator generator = this.graphDb.getIdGeneratorFactory().get(idType);
        IdAllocation result = new IdAllocation(generator.nextIdBatch(1000), generator.getHighId(), generator.getDefragCount());
        return ServerUtil.packResponseWithoutTransactionStream((StoreId)this.graphDb.getStoreId(), (Object)result);
    }

    @Override
    public Response<Long> commitSingleResourceTransaction(RequestContext context, String resource, TxExtractor txGetter) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context, false);
        try {
            XaDataSource dataSource = this.graphDb.getXaDataSourceManager().getXaDataSource(resource);
            final long txId = dataSource.applyPreparedTransaction(txGetter.extract());
            Predicate<Long> upUntilThisTx = new Predicate<Long>(){

                public boolean accept(Long item) {
                    return item < txId;
                }
            };
            Response<Long> response = this.packResponse(context, txId, upUntilThisTx);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    @Override
    public Response<Void> finishTransaction(RequestContext context, boolean success) {
        Transaction otherTx;
        try {
            otherTx = this.suspendOtherAndResumeThis(context, false);
        }
        catch (Exception e) {
            MasterTransaction masterTransaction = this.transactions.get(context);
            if (masterTransaction != null) {
                masterTransaction.markAsFinishAsap();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.finishThisAndResumeOther(otherTx, context, success);
        return this.packResponse(context, null);
    }

    @Override
    public Response<Integer> createRelationshipType(RequestContext context, String name) {
        this.graphDb.getRelationshipTypeTokenHolder().getOrCreateId(name);
        return this.packResponse(context, this.graphDb.getRelationshipTypeTokenHolder().getIdByName(name));
    }

    @Override
    public Response<Integer> createPropertyKey(RequestContext context, String name) {
        PropertyKeyTokenHolder propertyKeyHolder = (PropertyKeyTokenHolder)this.graphDb.getDependencyResolver().resolveDependency(PropertyKeyTokenHolder.class);
        return this.packResponse(context, propertyKeyHolder.getOrCreateId(name));
    }

    @Override
    public Response<Integer> createLabel(RequestContext context, String name) {
        LabelTokenHolder labels = (LabelTokenHolder)this.graphDb.getDependencyResolver().resolveDependency(LabelTokenHolder.class);
        return this.packResponse(context, labels.getOrCreateId(name));
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context) {
        return this.packResponse(context, null);
    }

    @Override
    public Response<Pair<Integer, Long>> getMasterIdForCommittedTx(long txId, StoreId storeId) {
        NeoStoreXaDataSource nioneoDataSource = this.graphDb.getXaDataSourceManager().getNeoStoreDataSource();
        try {
            Pair masterId = nioneoDataSource.getMasterForCommittedTx(txId);
            return ServerUtil.packResponseWithoutTransactionStream((StoreId)this.graphDb.getStoreId(), (Object)masterId);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get master ID for " + txId, e);
        }
    }

    @Override
    public Response<Void> copyStore(RequestContext context, StoreWriter writer) {
        context = ServerUtil.rotateLogsAndStreamStoreFiles((GraphDatabaseAPI)this.graphDb, (boolean)true, (StoreWriter)writer);
        writer.done();
        return this.packResponse(context, null);
    }

    @Override
    public Response<Void> copyTransactions(RequestContext context, String dsName, long startTxId, long endTxId) {
        return ServerUtil.getTransactions((GraphDatabaseAPI)this.graphDb, (String)dsName, (long)startTxId, (long)endTxId);
    }

    @Override
    public Response<LockResult> acquireIndexReadLock(RequestContext context, String index, String key) {
        return this.acquireLock(context, READ_LOCK_GRABBER, new IndexLock(index, key));
    }

    @Override
    public Response<LockResult> acquireIndexWriteLock(RequestContext context, String index, String key) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, new IndexLock(index, key));
    }

    @Override
    public Response<LockResult> acquireSchemaReadLock(RequestContext context) {
        return this.acquireLock(context, READ_LOCK_GRABBER, new SchemaLock());
    }

    @Override
    public Response<LockResult> acquireSchemaWriteLock(RequestContext context) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, new SchemaLock());
    }

    @Override
    public Response<LockResult> acquireIndexEntryWriteLock(RequestContext context, long labelId, long propertyKeyId, String propertyValue) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, new IndexEntryLock(IoPrimitiveUtils.safeCastLongToInt((long)labelId), IoPrimitiveUtils.safeCastLongToInt((long)propertyKeyId), propertyValue));
    }

    @Override
    public Response<Void> pushTransaction(RequestContext context, String resourceName, long tx) {
        this.graphDb.getTxIdGenerator().committed(this.graphDb.getXaDataSourceManager().getXaDataSource(resourceName), context.getEventIdentifier(), tx, Integer.valueOf(context.machineId()));
        return new Response(null, this.graphDb.getStoreId(), TransactionStream.EMPTY, ResourceReleaser.NO_OP);
    }

    public Map<Integer, Collection<RequestContext>> getOngoingTransactions() {
        HashMap<Integer, Collection<RequestContext>> result = new HashMap<Integer, Collection<RequestContext>>();
        Set<RequestContext> contexts = this.transactions.keySet();
        for (RequestContext context : contexts.toArray(new RequestContext[contexts.size()])) {
            ArrayList<RequestContext> txs = (ArrayList<RequestContext>)result.get(context.machineId());
            if (txs == null) {
                txs = new ArrayList<RequestContext>();
                result.put(context.machineId(), txs);
            }
            txs.add(context);
        }
        return result;
    }

    private static class MasterTransaction {
        private final Transaction transaction;
        private final AtomicLong timeLastSuspended = new AtomicLong();
        private volatile boolean finishAsap;

        MasterTransaction(Transaction transaction) {
            this.transaction = transaction;
        }

        void updateTime() {
            this.timeLastSuspended.set(System.currentTimeMillis());
        }

        void resetTime() {
            this.timeLastSuspended.set(0L);
        }

        void markAsFinishAsap() {
            this.finishAsap = true;
        }

        public String toString() {
            return this.transaction + "[lastSuspended=" + this.timeLastSuspended + ", finishAsap=" + this.finishAsap + "]";
        }

        boolean finishAsap() {
            return this.finishAsap;
        }
    }

    private static interface LockGrabber {
        public void grab(LockManager var1, TransactionState var2, Object var3);
    }
}

