/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.transaction.xaframework.EideticTransactionMonitor;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TransactionMonitoringIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void injectedTransactionCountShouldBeMonitored() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).cleanDirectory("testCluster"), MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), ":6001-6005", HaSettings.tx_push_factor.name(), "2"}));
        EideticTransactionMonitor masterMonitor = new EideticTransactionMonitor();
        EideticTransactionMonitor firstSlaveMonitor = new EideticTransactionMonitor();
        EideticTransactionMonitor secondSlaveMonitor = new EideticTransactionMonitor();
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            ((Monitors)master.getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)masterMonitor, new String[]{XaResourceManager.class.getName(), "nioneodb"});
            HighlyAvailableGraphDatabase firstSlave = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            ((Monitors)firstSlave.getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)firstSlaveMonitor, new String[]{XaResourceManager.class.getName(), "nioneodb"});
            HighlyAvailableGraphDatabase secondSlave = clusterManager.getDefaultCluster().getAnySlave(firstSlave);
            ((Monitors)secondSlave.getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)secondSlaveMonitor, new String[]{XaResourceManager.class.getName(), "nioneodb"});
            Transaction tx = master.beginTx();
            master.createNode();
            tx.success();
            tx.finish();
            tx = firstSlave.beginTx();
            firstSlave.createNode();
            tx.success();
            tx.finish();
            tx = secondSlave.beginTx();
            secondSlave.createNode();
            tx.success();
            tx.finish();
        }
        finally {
            clusterManager.stop();
        }
        Assert.assertEquals((long)3L, (long)masterMonitor.getCommitCount());
        Assert.assertEquals((long)0L, (long)masterMonitor.getInjectOnePhaseCommitCount());
        Assert.assertEquals((long)0L, (long)masterMonitor.getInjectTwoPhaseCommitCount());
        Assert.assertEquals((long)1L, (long)firstSlaveMonitor.getCommitCount());
        Assert.assertEquals((long)2L, (long)firstSlaveMonitor.getInjectOnePhaseCommitCount());
        Assert.assertEquals((long)0L, (long)firstSlaveMonitor.getInjectTwoPhaseCommitCount());
        Assert.assertEquals((long)1L, (long)secondSlaveMonitor.getCommitCount());
        Assert.assertEquals((long)2L, (long)secondSlaveMonitor.getInjectOnePhaseCommitCount());
        Assert.assertEquals((long)0L, (long)secondSlaveMonitor.getInjectTwoPhaseCommitCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pullUpdatesShouldUpdateCounters() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).cleanDirectory("testCluster"), MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), ":6001-6005", HaSettings.tx_push_factor.name(), "0"}));
        EideticTransactionMonitor masterMonitor = new EideticTransactionMonitor();
        EideticTransactionMonitor firstSlaveMonitor = new EideticTransactionMonitor();
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            ((Monitors)master.getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)masterMonitor, new String[]{XaResourceManager.class.getName(), "nioneodb"});
            HighlyAvailableGraphDatabase firstSlave = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            ((Monitors)firstSlave.getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)firstSlaveMonitor, new String[]{XaResourceManager.class.getName(), "nioneodb"});
            for (int i = 0; i < 10; ++i) {
                Transaction tx = master.beginTx();
                master.createNode();
                tx.success();
                tx.finish();
            }
            ((UpdatePuller)firstSlave.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        }
        finally {
            clusterManager.stop();
        }
        Assert.assertEquals((long)0L, (long)firstSlaveMonitor.getCommitCount());
        Assert.assertEquals((long)10L, (long)firstSlaveMonitor.getInjectOnePhaseCommitCount());
        Assert.assertEquals((long)0L, (long)firstSlaveMonitor.getInjectTwoPhaseCommitCount());
    }
}

