/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class ConflictingServerIdIT {
    private static final File path = TargetDirectory.forTest(ConflictingServerIdIT.class).makeGraphDbDir();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConflictingIdDoesNotSilentlyFail() throws Exception {
        HighlyAvailableGraphDatabase master = null;
        HighlyAvailableGraphDatabase dbWithId21 = null;
        HighlyAvailableGraphDatabase dbWithId22 = null;
        try {
            GraphDatabaseBuilder masterBuilder = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(ConflictingServerIdIT.path(1)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5002").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5002").setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, ":8002").setConfig(HaSettings.tx_push_factor, "0");
            master = (HighlyAvailableGraphDatabase)masterBuilder.newGraphDatabase();
            GraphDatabaseBuilder db21Builder = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(ConflictingServerIdIT.path(2)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5002,127.0.0.1:5003").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5003").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, ":8003").setConfig(HaSettings.tx_push_factor, "0");
            dbWithId21 = (HighlyAvailableGraphDatabase)db21Builder.newGraphDatabase();
            GraphDatabaseBuilder db22Builder = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(ConflictingServerIdIT.path(3)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5002").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5004").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, ":8004").setConfig(HaSettings.tx_push_factor, "0");
            try {
                dbWithId22 = (HighlyAvailableGraphDatabase)db22Builder.newGraphDatabase();
                Assert.fail((String)"Should not be able to startup when a cluster already has my id");
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertTrue((boolean)master.isMaster());
            Assert.assertTrue((!dbWithId21.isMaster() ? 1 : 0) != 0);
            Transaction tx1 = dbWithId21.beginTx();
            tx1.success();
            tx1.finish();
        }
        finally {
            if (dbWithId21 != null) {
                dbWithId21.shutdown();
            }
            if (dbWithId22 != null) {
                dbWithId22.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private static String path(int i) {
        return new File(path, "" + i).getAbsolutePath();
    }
}

