/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.reflect.Array;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.SizeOfs;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestSizeOf {
    private static GraphDatabaseAPI db;
    public static final int _8_BYTES_FOR_VALUE = 8;

    @BeforeClass
    public static void setupDB() {
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "hpc").newGraphDatabase();
    }

    @AfterClass
    public static void shutdown() throws Exception {
        db.shutdown();
    }

    @Before
    public void clearCache() {
        this.nodeManager().clearCache();
    }

    private Cache<NodeImpl> getNodeCache() {
        return (Cache)IteratorUtil.first((Iterable)this.nodeManager().caches());
    }

    private NodeManager nodeManager() {
        return (NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class);
    }

    private Node createNodeAndLoadFresh(Map<String, Object> properties, int nrOfRelationships, int nrOfTypes) {
        return this.createNodeAndLoadFresh(properties, nrOfRelationships, nrOfTypes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNodeAndLoadFresh(Map<String, Object> properties, int nrOfRelationships, int nrOfTypes, int directionStride) {
        Node node = null;
        Transaction tx = db.beginTx();
        try {
            node = db.createNode();
            this.setProperties(properties, (PropertyContainer)node);
            for (int t = 0; t < nrOfTypes; ++t) {
                DynamicRelationshipType type = DynamicRelationshipType.withName((String)this.relTypeName(t));
                int dir = 0;
                for (int i = 0; i < nrOfRelationships; ++i) {
                    switch (dir) {
                        case 0: {
                            node.createRelationshipTo(db.createNode(), (RelationshipType)type);
                            break;
                        }
                        case 1: {
                            db.createNode().createRelationshipTo(node, (RelationshipType)type);
                            break;
                        }
                        case 2: {
                            node.createRelationshipTo(node, (RelationshipType)type);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid direction " + dir);
                        }
                    }
                    dir = (dir + directionStride) % 3;
                }
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        this.clearCache();
        if (!properties.isEmpty()) {
            this.loadProperties((PropertyContainer)node);
        }
        if (nrOfRelationships * nrOfTypes > 0) {
            this.countRelationships(node);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countRelationships(Node node) {
        Transaction transaction = db.beginTx();
        try {
            IteratorUtil.count((Iterable)node.getRelationships());
        }
        finally {
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(PropertyContainer entity) {
        Transaction transaction = db.beginTx();
        try {
            for (String key : entity.getPropertyKeys()) {
                entity.getProperty(key);
            }
        }
        finally {
            transaction.finish();
        }
    }

    private void setProperties(Map<String, Object> properties, PropertyContainer entity) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            entity.setProperty(property.getKey(), property.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Relationship createRelationshipAndLoadFresh(Map<String, Object> properties) {
        Relationship relationship = null;
        Transaction tx = db.beginTx();
        try {
            relationship = db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            this.setProperties(properties, (PropertyContainer)relationship);
            tx.success();
        }
        finally {
            tx.finish();
        }
        this.clearCache();
        if (!properties.isEmpty()) {
            this.loadProperties((PropertyContainer)relationship);
        }
        return relationship;
    }

    private String relTypeName(int t) {
        return "mytype" + t;
    }

    @Test
    public void cacheSizeCorrelatesWithNodeSizeAfterFullyLoadingRelationships() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 10, 1);
        Cache<NodeImpl> nodeCache = this.getNodeCache();
        this.clearCache();
        Assert.assertEquals((long)0L, (long)nodeCache.size());
        this.countRelationships(node);
        Assert.assertEquals((long)this.nodeManager().getNodeForProxy(node.getId(), null).sizeOfObjectInBytesIncludingOverhead(), (long)nodeCache.size());
    }

    private int sizeOfNode(Node node) {
        try (Transaction ignore = db.beginTx();){
            int n = this.nodeManager().getNodeForProxy(node.getId(), null).sizeOfObjectInBytesIncludingOverhead();
            return n;
        }
    }

    private int sizeOfRelationship(Relationship relationship) {
        try (Transaction ignore = db.beginTx();){
            int n = this.nodeManager().getRelationshipForProxy(relationship.getId()).sizeOfObjectInBytesIncludingOverhead();
            return n;
        }
    }

    private int withNodeOverhead(int size) {
        return SizeOfs.withObjectOverhead((int)(48 + size));
    }

    private int withRelationshipOverhead(int size) {
        return SizeOfs.withObjectOverhead((int)(32 + size));
    }

    public static RelationshipArraySize array() {
        return new RelationshipArraySize();
    }

    static RelationshipsSize relationships() {
        return new RelationshipsSize();
    }

    static PropertiesSize properties() {
        return new PropertiesSize();
    }

    private void assertArraySize(Object array, int sizePerItem) {
        Assert.assertEquals((long)SizeOfs.withArrayOverhead((int)(Array.getLength(array) * sizePerItem)), (long)SizeOfs.sizeOfArray((Object)array));
    }

    @Test
    public void sizeOfEmptyNode() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 0, 0);
        Assert.assertEquals((long)this.withNodeOverhead(0), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithOneProperty() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 5}), 0, 0);
        Assert.assertEquals((long)this.withNodeOverhead(TestSizeOf.properties().withSmallPrimitiveProperty().size()), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithSomeProperties() throws Exception {
        String name = "Mattias";
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 5, "name", name}), 0, 0);
        Assert.assertEquals((long)this.withNodeOverhead(TestSizeOf.properties().withSmallPrimitiveProperty().withStringProperty(name).size()), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithOneRelationship() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 1, 1);
        Assert.assertEquals((long)this.withNodeOverhead(TestSizeOf.relationships().add(TestSizeOf.array().withOutRelationships(1)).size()), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithSomeRelationshipsOfSameType() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 10, 1);
        Assert.assertEquals((long)this.withNodeOverhead(TestSizeOf.relationships().add(TestSizeOf.array().withOutRelationships(10)).size()), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithSomeRelationshipOfDifferentTypes() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 3, 3);
        Assert.assertEquals((long)this.withNodeOverhead(TestSizeOf.relationships().add(TestSizeOf.array().withOutRelationships(3)).add(TestSizeOf.array().withOutRelationships(3)).add(TestSizeOf.array().withOutRelationships(3)).size()), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithSomeRelationshipOfDifferentTypesAndDirections() throws Exception {
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[0]), 9, 3, 1);
        Assert.assertEquals((long)this.withNodeOverhead(TestSizeOf.relationships().add(TestSizeOf.array().withRelationshipInAllDirections(3)).add(TestSizeOf.array().withRelationshipInAllDirections(3)).add(TestSizeOf.array().withRelationshipInAllDirections(3)).size()), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfNodeWithRelationshipsAndProperties() throws Exception {
        int[] array = new int[]{10, 11, 12, 13};
        Node node = this.createNodeAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 10, "array", array}), 9, 3, 1);
        Assert.assertEquals((long)this.withNodeOverhead(TestSizeOf.relationships().add(TestSizeOf.array().withRelationshipInAllDirections(3)).add(TestSizeOf.array().withRelationshipInAllDirections(3)).add(TestSizeOf.array().withRelationshipInAllDirections(3)).size() + TestSizeOf.properties().withSmallPrimitiveProperty().withArrayProperty(array).size()), (long)this.sizeOfNode(node));
    }

    @Test
    public void sizeOfEmptyRelationship() throws Exception {
        Relationship relationship = this.createRelationshipAndLoadFresh(MapUtil.map((Object[])new Object[0]));
        Assert.assertEquals((long)this.withRelationshipOverhead(0), (long)this.sizeOfRelationship(relationship));
    }

    @Test
    public void sizeOfRelationshipWithOneProperty() throws Exception {
        Relationship relationship = this.createRelationshipAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 5}));
        Assert.assertEquals((long)this.withRelationshipOverhead(TestSizeOf.properties().withSmallPrimitiveProperty().size()), (long)this.sizeOfRelationship(relationship));
    }

    @Test
    public void sizeOfRelationshipWithSomeProperties() throws Exception {
        String name = "Mattias";
        Relationship relationship = this.createRelationshipAndLoadFresh(MapUtil.map((Object[])new Object[]{"age", 5, "name", name}));
        Assert.assertEquals((long)this.withRelationshipOverhead(TestSizeOf.properties().withSmallPrimitiveProperty().withStringProperty(name).size()), (long)this.sizeOfRelationship(relationship));
    }

    @Test
    public void assumeWorstCaseJavaObjectOverhead() throws Exception {
        int size = 88;
        Assert.assertEquals((long)(size + 16), (long)SizeOfs.withObjectOverhead((int)size));
    }

    @Test
    public void assumeWorstCaseJavaArrayObjectOverhead() throws Exception {
        int size = 88;
        Assert.assertEquals((long)(size + 24), (long)SizeOfs.withArrayOverhead((int)size));
    }

    @Test
    public void assumeWorstCaseJavaArrayObjectOverheadIncludingReferences() throws Exception {
        int size = 24;
        int length = 5;
        Assert.assertEquals((long)SizeOfs.withArrayOverhead((int)(size + 8 * length)), (long)SizeOfs.withArrayOverheadIncludingReferences((int)size, (int)length));
    }

    @Test
    public void assumeWorstCaseReferenceToJavaObject() throws Exception {
        int size = 24;
        Assert.assertEquals((long)(size + 8), (long)SizeOfs.withReference((int)size));
    }

    @Test
    public void sizeOfPrimitiveArrayIsCorrectlyCalculated() throws Exception {
        this.assertArraySize(new boolean[]{true, false}, 1);
        this.assertArraySize(new byte[]{1, 2, 3}, 1);
        this.assertArraySize(new short[]{23, 21, 1, 45}, 2);
        this.assertArraySize(new int[]{100, 121, 1, 3, 45}, 4);
        this.assertArraySize(new long[]{403L, 3849329L, 23829L}, 8);
        this.assertArraySize(new float[]{342.0f, 21.0f, 43.4567f}, 4);
        this.assertArraySize(new double[]{45748.98, 38493.0}, 8);
        this.assertArraySize(new Integer[]{123, 456, 789}, 32);
    }

    private static class PropertiesSize {
        private int length;
        private int size;

        private PropertiesSize() {
        }

        private PropertiesSize add(int size) {
            ++this.length;
            this.size += SizeOfs.withObjectOverhead((int)size);
            return this;
        }

        PropertiesSize withSmallPrimitiveProperty() {
            return this.add(8);
        }

        PropertiesSize withStringProperty(String value) {
            return this.add(SizeOfs.withReference((int)SizeOfs.sizeOf((String)value)));
        }

        PropertiesSize withArrayProperty(Object array) {
            return this.add(SizeOfs.withReference((int)SizeOfs.sizeOfArray((Object)array)));
        }

        public int size() {
            return SizeOfs.withArrayOverheadIncludingReferences((int)this.size, (int)this.length);
        }
    }

    private static class RelationshipsSize {
        private int length;
        private int size;

        private RelationshipsSize() {
        }

        RelationshipsSize add(RelationshipArraySize array) {
            this.size += array.size();
            ++this.length;
            return this;
        }

        int size() {
            return SizeOfs.withArrayOverheadIncludingReferences((int)this.size, (int)this.length);
        }
    }

    private static class RelationshipArraySize {
        private int nrOut;
        private int nrIn;
        private int nrLoop;

        private RelationshipArraySize() {
        }

        RelationshipArraySize withOutRelationships(int nrOut) {
            this.nrOut = nrOut;
            return this;
        }

        RelationshipArraySize withRelationshipInAllDirections(int nr) {
            this.nrIn = this.nrLoop = nr;
            this.nrOut = this.nrLoop;
            return this;
        }

        int size() {
            int size = 24;
            for (int rels : new int[]{this.nrOut, this.nrIn, this.nrLoop}) {
                if (rels <= 0) continue;
                size += SizeOfs.withObjectOverhead((int)SizeOfs.withReference((int)SizeOfs.withArrayOverhead((int)(4 * (rels + 1)))));
            }
            if (this.nrLoop > 0) {
                size += 8;
            }
            return SizeOfs.withObjectOverhead((int)size);
        }
    }
}

