/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.InetSocketAddress;
import java.net.URI;
import javax.transaction.TransactionManager;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.Server;
import org.neo4j.com.ServerUtil;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.BranchDetectingTxVerifier;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.cluster.DefaultMasterImplSPI;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class SwitchToMaster {
    private final Logging logging;
    private final StringLogger msgLog;
    private final GraphDatabaseAPI graphDb;
    private final HaIdGeneratorFactory idGeneratorFactory;
    private final Config config;
    private final DependencyResolver resolver;
    private final DelegateInvocationHandler<Master> masterDelegateHandler;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final Monitors monitors;

    public SwitchToMaster(Logging logging, StringLogger msgLog, GraphDatabaseAPI graphDb, HaIdGeneratorFactory idGeneratorFactory, Config config, DependencyResolver resolver, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, Monitors monitors) {
        this.logging = logging;
        this.msgLog = msgLog;
        this.graphDb = graphDb;
        this.idGeneratorFactory = idGeneratorFactory;
        this.config = config;
        this.resolver = resolver;
        this.masterDelegateHandler = masterDelegateHandler;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.monitors = monitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI switchToMaster(LifeSupport haCommunicationLife, URI me) {
        HaXaDataSourceManager xaDataSourceManager;
        this.msgLog.logMessage("I am " + this.config.get(ClusterSettings.server_id) + ", moving to master");
        HaXaDataSourceManager haXaDataSourceManager = xaDataSourceManager = (HaXaDataSourceManager)((Object)this.resolver.resolveDependency(HaXaDataSourceManager.class));
        synchronized (haXaDataSourceManager) {
            TransactionManager txManager = (TransactionManager)this.resolver.resolveDependency(TransactionManager.class);
            this.idGeneratorFactory.switchToMaster();
            NeoStoreXaDataSource neoStoreXaDataSource = (NeoStoreXaDataSource)xaDataSourceManager.getXaDataSource("nioneodb");
            neoStoreXaDataSource.reloadSchemaCache();
            Monitors monitors = (Monitors)this.resolver.resolveDependency(Monitors.class);
            DefaultMasterImplSPI spi = new DefaultMasterImplSPI(this.graphDb, this.logging, txManager, monitors);
            MasterImpl masterImpl = new MasterImpl(spi, (MasterImpl.Monitor)monitors.newMonitor(MasterImpl.Monitor.class, new String[0]), this.logging, this.config);
            MasterServer masterServer = new MasterServer(masterImpl, this.logging, this.serverConfig(), new BranchDetectingTxVerifier(this.resolver), monitors);
            haCommunicationLife.add((Object)masterImpl);
            haCommunicationLife.add((Object)masterServer);
            this.masterDelegateHandler.setDelegate(masterImpl);
            haCommunicationLife.start();
            URI masterHaURI = URI.create("ha://" + (ServerUtil.getHostString((InetSocketAddress)masterServer.getSocketAddress()).contains("0.0.0.0") ? me.getHost() : ServerUtil.getHostString((InetSocketAddress)masterServer.getSocketAddress())) + ":" + masterServer.getSocketAddress().getPort() + "?serverId=" + this.config.get(ClusterSettings.server_id));
            this.clusterMemberAvailability.memberIsAvailable("master", masterHaURI);
            this.msgLog.logMessage("I am " + this.config.get(ClusterSettings.server_id) + ", successfully moved to master");
            return masterHaURI;
        }
    }

    private Server.Configuration serverConfig() {
        Server.Configuration serverConfig = new Server.Configuration(){

            public long getOldChannelThreshold() {
                return (Long)SwitchToMaster.this.config.get(HaSettings.lock_read_timeout);
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)SwitchToMaster.this.config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)SwitchToMaster.this.config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)SwitchToMaster.this.config.get(HaSettings.ha_server);
            }
        };
        return serverConfig;
    }
}

