/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.transaction.TransactionManager;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.storecopy.RemoteStoreCopier;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.StoreOutOfDateException;
import org.neo4j.kernel.ha.StoreUnableToParticipateInClusterException;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveImpl;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class SwitchToSlave {
    private static final Class[] SERVICES_TO_RESTART_FOR_STORE_COPY = new Class[]{StoreLockerLifecycleAdapter.class, XaDataSourceManager.class, TransactionManager.class, NodeManager.class, IndexStore.class};
    private final Logging logging;
    private final StringLogger msgLog;
    private final ConsoleLogger console;
    private final Config config;
    private final DependencyResolver resolver;
    private final HaIdGeneratorFactory idGeneratorFactory;
    private final DelegateInvocationHandler<Master> masterDelegateHandler;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final RequestContextFactory requestContextFactory;
    private final UpdateableSchemaState updateableSchemaState;
    private final Monitors monitors;
    private final Iterable<KernelExtensionFactory<?>> kernelExtensions;
    private MasterClientResolver masterClientResolver;

    public SwitchToSlave(ConsoleLogger console, Config config, DependencyResolver resolver, HaIdGeneratorFactory idGeneratorFactory, Logging logging, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, RequestContextFactory requestContextFactory, UpdateableSchemaState updateableSchemaState, Monitors monitors, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        this.console = console;
        this.config = config;
        this.resolver = resolver;
        this.idGeneratorFactory = idGeneratorFactory;
        this.logging = logging;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.requestContextFactory = requestContextFactory;
        this.updateableSchemaState = updateableSchemaState;
        this.monitors = monitors;
        this.kernelExtensions = kernelExtensions;
        this.msgLog = logging.getMessagesLog(this.getClass());
        this.masterDelegateHandler = masterDelegateHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI switchToSlave(LifeSupport haCommunicationLife, URI me, URI masterUri) throws Throwable {
        this.console.log("ServerId " + this.config.get(ClusterSettings.server_id) + ", moving to slave for master " + masterUri);
        assert (masterUri != null);
        this.masterClientResolver = new MasterClientResolver(this.logging, ((Long)this.config.get(HaSettings.read_timeout)).intValue(), ((Long)this.config.get(HaSettings.lock_read_timeout)).intValue(), (Integer)this.config.get(HaSettings.max_concurrent_channels_per_slave), ((Long)this.config.get(HaSettings.com_chunk_size)).intValue());
        HaXaDataSourceManager xaDataSourceManager = (HaXaDataSourceManager)((Object)this.resolver.resolveDependency(HaXaDataSourceManager.class));
        this.idGeneratorFactory.switchToSlave();
        HaXaDataSourceManager haXaDataSourceManager = xaDataSourceManager;
        synchronized (haXaDataSourceManager) {
            if (!NeoStore.isStorePresent((FileSystemAbstraction)((FileSystemAbstraction)this.resolver.resolveDependency(FileSystemAbstraction.class)), (Config)this.config)) {
                this.copyStoreFromMaster(masterUri);
            }
            NeoStoreXaDataSource nioneoDataSource = this.ensureDataSourceStarted(xaDataSourceManager, this.resolver);
            this.checkDataConsistency(xaDataSourceManager, (RequestContextFactory)this.resolver.resolveDependency(RequestContextFactory.class), nioneoDataSource, masterUri);
            URI slaveUri = this.startHaCommunication(haCommunicationLife, xaDataSourceManager, nioneoDataSource, me, masterUri);
            this.console.log("ServerId " + this.config.get(ClusterSettings.server_id) + ", successfully moved to slave for master " + masterUri);
            return slaveUri;
        }
    }

    private void checkDataConsistency(HaXaDataSourceManager xaDataSourceManager, RequestContextFactory requestContextFactory, NeoStoreXaDataSource nioneoDataSource, URI masterUri) throws Throwable {
        LifeSupport checkConsistencyLife = new LifeSupport();
        try {
            MasterClient checkConsistencyMaster = this.newMasterClient(masterUri, nioneoDataSource.getStoreId(), checkConsistencyLife);
            checkConsistencyLife.start();
            this.console.log("Checking store consistency with master");
            this.checkDataConsistencyWithMaster(masterUri, checkConsistencyMaster, nioneoDataSource);
            this.console.log("Store is consistent");
            this.console.log("Catching up with master");
            RequestContext context = requestContextFactory.newRequestContext(-1);
            xaDataSourceManager.applyTransactions(checkConsistencyMaster.pullUpdates(context));
            this.console.log("Now consistent with master");
        }
        catch (NoSuchLogVersionException e) {
            this.msgLog.logMessage("Cannot catch up to master by pulling updates, because I cannot find the archived logical log file that has the transaction I would start from. I'm going to copy the whole store from the master instead.");
            try {
                this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)));
            }
            catch (Throwable throwable) {
                this.msgLog.warn("Failed preparing for copying the store from the master instance", throwable);
            }
            throw e;
        }
        catch (StoreUnableToParticipateInClusterException upe) {
            this.console.log("The store is inconsistent. Will treat it as branched and fetch a new one from the master");
            this.msgLog.warn("Current store is unable to participate in the cluster; fetching new store from master", (Throwable)upe);
            try {
                xaDataSourceManager.unregisterDataSource("nioneodb");
                this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)));
            }
            catch (IOException e) {
                this.msgLog.warn("Failed while trying to handle branched data", (Throwable)e);
            }
            throw upe;
        }
        catch (MismatchingStoreIdException e) {
            this.console.log("The store does not represent the same database as master. Will remove and fetch a new one from master");
            if (nioneoDataSource.getNeoStore().getLastCommittedTx() == 1L) {
                this.msgLog.warn("Found and deleting empty store with mismatching store id " + e.getMessage());
                this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
            } else {
                this.msgLog.error("Store cannot participate in cluster due to mismatching store IDs");
            }
            throw e;
        }
        finally {
            checkConsistencyLife.shutdown();
        }
    }

    private URI startHaCommunication(LifeSupport haCommunicationLife, HaXaDataSourceManager xaDataSourceManager, NeoStoreXaDataSource nioneoDataSource, URI me, URI masterUri) {
        MasterClient master = this.newMasterClient(masterUri, nioneoDataSource.getStoreId(), haCommunicationLife);
        SlaveImpl slaveImpl = new SlaveImpl(nioneoDataSource.getStoreId(), master, new RequestContextFactory(HighAvailabilityModeSwitcher.getServerId(masterUri).toIntegerIndex(), xaDataSourceManager, this.resolver), xaDataSourceManager);
        SlaveServer server = new SlaveServer(slaveImpl, this.serverConfig(), this.logging, (Monitors)this.resolver.resolveDependency(Monitors.class));
        this.masterDelegateHandler.setDelegate(master);
        haCommunicationLife.add((Object)slaveImpl);
        haCommunicationLife.add((Object)server);
        haCommunicationLife.start();
        URI slaveHaURI = this.createHaURI(me, server);
        this.clusterMemberAvailability.memberIsAvailable("slave", slaveHaURI);
        return slaveHaURI;
    }

    private Server.Configuration serverConfig() {
        Server.Configuration serverConfig = new Server.Configuration(){

            public long getOldChannelThreshold() {
                return (Long)SwitchToSlave.this.config.get(HaSettings.lock_read_timeout);
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)SwitchToSlave.this.config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)SwitchToSlave.this.config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)SwitchToSlave.this.config.get(HaSettings.ha_server);
            }
        };
        return serverConfig;
    }

    private URI createHaURI(URI me, Server<?, ?> server) {
        String hostString = ServerUtil.getHostString((InetSocketAddress)server.getSocketAddress());
        int port = server.getSocketAddress().getPort();
        InstanceId serverId = (InstanceId)this.config.get(ClusterSettings.server_id);
        String host = hostString.contains("0.0.0.0") ? me.getHost() : hostString;
        return URI.create("ha://" + host + ":" + port + "?serverId=" + serverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMaster(URI masterUri) throws Throwable {
        FileSystemAbstraction fs = (FileSystemAbstraction)this.resolver.resolveDependency(FileSystemAbstraction.class);
        LifeSupport life = new LifeSupport();
        try {
            this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
            final MasterClient copyMaster = this.newMasterClient(masterUri, null, life);
            life.start();
            this.console.log("Copying store from master");
            new RemoteStoreCopier(this.config, this.kernelExtensions, this.console, fs).copyStore(new RemoteStoreCopier.StoreCopyRequester(){

                public Response<?> copyStore(StoreWriter writer) {
                    return copyMaster.copyStore(new RequestContext(0L, ((InstanceId)SwitchToSlave.this.config.get(ClusterSettings.server_id)).toIntegerIndex(), 0, new RequestContext.Tx[0], 0, 0L), writer);
                }

                public void done() {
                }
            });
            this.startServicesAgain();
            this.console.log("Finished copying store from master");
        }
        finally {
            life.stop();
        }
    }

    private MasterClient newMasterClient(URI masterUri, StoreId storeId, LifeSupport life) {
        return this.masterClientResolver.instantiate(masterUri.getHost(), masterUri.getPort(), (Monitors)this.resolver.resolveDependency(Monitors.class), storeId, life);
    }

    private void startServicesAgain() throws Throwable {
        ArrayList<Class> services = new ArrayList<Class>(Arrays.asList(SERVICES_TO_RESTART_FOR_STORE_COPY));
        for (Class serviceClass : services) {
            Lifecycle service = (Lifecycle)this.resolver.resolveDependency(serviceClass);
            service.start();
        }
    }

    private void stopServicesAndHandleBranchedStore(BranchedDataPolicy branchPolicy) throws Throwable {
        ArrayList<Class> services = new ArrayList<Class>(Arrays.asList(SERVICES_TO_RESTART_FOR_STORE_COPY));
        Collections.reverse(services);
        for (Class serviceClass : services) {
            ((Lifecycle)this.resolver.resolveDependency(serviceClass)).stop();
        }
        branchPolicy.handle((File)this.config.get(InternalAbstractGraphDatabase.Configuration.store_dir));
    }

    private void checkDataConsistencyWithMaster(URI availableMasterId, Master master, NeoStoreXaDataSource nioneoDataSource) throws NoSuchLogVersionException {
        HandshakeResult handshake;
        Pair myMaster;
        long myLastCommittedTx = nioneoDataSource.getLastCommittedTxId();
        try {
            myMaster = nioneoDataSource.getMasterForCommittedTx(myLastCommittedTx);
        }
        catch (IOException e) {
            this.msgLog.logMessage("Failed to get master ID for txId " + myLastCommittedTx + ".", (Throwable)e);
            return;
        }
        catch (Exception e) {
            throw new BranchedDataException("Exception while getting master ID for txId " + myLastCommittedTx + ".", e);
        }
        try (Response<HandshakeResult> response = master.handshake(myLastCommittedTx, nioneoDataSource.getStoreId());){
            handshake = (HandshakeResult)response.response();
            this.requestContextFactory.setEpoch(handshake.epoch());
        }
        catch (BranchedDataException e) {
            throw new BranchedDataException("Master detected branched data for this machine.", e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MissingLogDataException) {
                throw new StoreOutOfDateException("The master is missing the log required to complete the consistency check", e.getCause());
            }
            throw e;
        }
        if ((Integer)myMaster.first() != -1 && (((Integer)myMaster.first()).intValue() != handshake.txAuthor() || ((Long)myMaster.other()).longValue() != handshake.txChecksum())) {
            String msg = "Branched data, I (machineId:" + this.config.get(ClusterSettings.server_id) + ") think machineId for" + " txId (" + myLastCommittedTx + ") is " + myMaster + ", but master (machineId:" + HighAvailabilityModeSwitcher.getServerId(availableMasterId) + ") says that it's " + handshake;
            throw new BranchedDataException(msg);
        }
        this.msgLog.logMessage("Master id for last committed tx ok with highestTxId=" + myLastCommittedTx + " with masterId=" + myMaster, true);
    }

    private NeoStoreXaDataSource ensureDataSourceStarted(XaDataSourceManager xaDataSourceManager, DependencyResolver resolver) throws IOException {
        NeoStoreXaDataSource nioneoDataSource = (NeoStoreXaDataSource)xaDataSourceManager.getXaDataSource("nioneodb");
        if (nioneoDataSource == null) {
            nioneoDataSource = new NeoStoreXaDataSource(this.config, (StoreFactory)resolver.resolveDependency(StoreFactory.class), (StringLogger)resolver.resolveDependency(StringLogger.class), (XaFactory)resolver.resolveDependency(XaFactory.class), (TransactionStateFactory)resolver.resolveDependency(TransactionStateFactory.class), (TransactionInterceptorProviders)resolver.resolveDependency(TransactionInterceptorProviders.class), (JobScheduler)resolver.resolveDependency(JobScheduler.class), this.logging, this.updateableSchemaState, (TokenNameLookup)new NonTransactionalTokenNameLookup((LabelTokenHolder)resolver.resolveDependency(LabelTokenHolder.class), (PropertyKeyTokenHolder)resolver.resolveDependency(PropertyKeyTokenHolder.class)), resolver, (AbstractTransactionManager)resolver.resolveDependency(AbstractTransactionManager.class), (PropertyKeyTokenHolder)resolver.resolveDependency(PropertyKeyTokenHolder.class), (LabelTokenHolder)resolver.resolveDependency(LabelTokenHolder.class), (RelationshipTypeTokenHolder)resolver.resolveDependency(RelationshipTypeTokenHolder.class), (PersistenceManager)resolver.resolveDependency(PersistenceManager.class), (LockManager)resolver.resolveDependency(LockManager.class), (SchemaWriteGuard)resolver.resolveDependency(SchemaWriteGuard.class), (IndexingService.Monitor)this.monitors.newMonitor(IndexingService.Monitor.class, new String[0]));
            xaDataSourceManager.registerDataSource((XaDataSource)nioneoDataSource);
            ((NodeManager)resolver.resolveDependency(NodeManager.class)).start();
        }
        return nioneoDataSource;
    }
}

