/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.BlockLogReader;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.TxExtractor;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.ToNetworkStoreWriter;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClient18;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.nioneo.store.IdRange;
import org.neo4j.kernel.monitoring.Monitors;

public enum HaRequestType18 implements RequestType<Master>
{
    ALLOCATE_IDS((TargetCaller)new TargetCaller<Master, IdAllocation>(){

        public Response<IdAllocation> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            IdType idType = IdType.values()[input.readByte()];
            return master.allocateIds(context, idType);
        }
    }, new ObjectSerializer<IdAllocation>(){

        public void write(IdAllocation idAllocation, ChannelBuffer result) throws IOException {
            IdRange idRange = idAllocation.getIdRange();
            result.writeInt(idRange.getDefragIds().length);
            for (long id : idRange.getDefragIds()) {
                result.writeLong(id);
            }
            result.writeLong(idRange.getRangeStart());
            result.writeInt(idRange.getRangeLength());
            result.writeLong(idAllocation.getHighestIdInUse());
            result.writeLong(idAllocation.getDefragCount());
        }
    }, false),
    CREATE_RELATIONSHIP_TYPE((TargetCaller)new TargetCaller<Master, Integer>(){

        public Response<Integer> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.createRelationshipType(context, Protocol.readString((ChannelBuffer)input));
        }
    }, Protocol.INTEGER_SERIALIZER, true),
    ACQUIRE_NODE_WRITE_LOCK((TargetCaller)new MasterClient18.AquireLockCall(){

        @Override
        protected Response<LockResult> lock(Master master, RequestContext context, long ... ids) {
            return master.acquireNodeWriteLock(context, ids);
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER, true){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    ACQUIRE_NODE_READ_LOCK((TargetCaller)new MasterClient18.AquireLockCall(){

        @Override
        protected Response<LockResult> lock(Master master, RequestContext context, long ... ids) {
            return master.acquireNodeReadLock(context, ids);
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER, true){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    ACQUIRE_RELATIONSHIP_WRITE_LOCK((TargetCaller)new MasterClient18.AquireLockCall(){

        @Override
        protected Response<LockResult> lock(Master master, RequestContext context, long ... ids) {
            return master.acquireRelationshipWriteLock(context, ids);
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER, true){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    ACQUIRE_RELATIONSHIP_READ_LOCK((TargetCaller)new MasterClient18.AquireLockCall(){

        @Override
        protected Response<LockResult> lock(Master master, RequestContext context, long ... ids) {
            return master.acquireRelationshipReadLock(context, ids);
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER, true){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    COMMIT((TargetCaller)new TargetCaller<Master, Long>(){

        public Response<Long> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            String resource = Protocol.readString((ChannelBuffer)input);
            BlockLogReader reader = new BlockLogReader(input);
            return master.commitSingleResourceTransaction(context, resource, TxExtractor.create((ReadableByteChannel)reader));
        }
    }, Protocol.LONG_SERIALIZER, true),
    PULL_UPDATES((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.pullUpdates(context);
        }
    }, Protocol.VOID_SERIALIZER, true),
    FINISH((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.finishTransaction(context, Protocol.readBoolean((ChannelBuffer)input));
        }
    }, Protocol.VOID_SERIALIZER, true),
    HANDSHAKE((TargetCaller)new TargetCaller<Master, HandshakeResult>(){

        public Response<HandshakeResult> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.handshake(input.readLong(), null);
        }
    }, new ObjectSerializer<HandshakeResult>(){

        public void write(HandshakeResult responseObject, ChannelBuffer result) throws IOException {
            result.writeInt(responseObject.txAuthor());
            result.writeLong(responseObject.txChecksum());
        }
    }, false),
    COPY_STORE((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.copyStore(context, (StoreWriter)new ToNetworkStoreWriter(target, new Monitors()));
        }
    }, Protocol.VOID_SERIALIZER, true),
    COPY_TRANSACTIONS((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.copyTransactions(context, Protocol.readString((ChannelBuffer)input), input.readLong(), input.readLong());
        }
    }, Protocol.VOID_SERIALIZER, true),
    INITIALIZE_TX((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.initializeTx(context);
        }
    }, Protocol.VOID_SERIALIZER, true),
    ACQUIRE_GRAPH_WRITE_LOCK((TargetCaller)new TargetCaller<Master, LockResult>(){

        public Response<LockResult> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.acquireGraphWriteLock(context);
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER, true){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    ACQUIRE_GRAPH_READ_LOCK((TargetCaller)new TargetCaller<Master, LockResult>(){

        public Response<LockResult> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.acquireGraphReadLock(context);
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER, true){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    ACQUIRE_INDEX_READ_LOCK((TargetCaller)new TargetCaller<Master, LockResult>(){

        public Response<LockResult> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.acquireIndexReadLock(context, Protocol.readString((ChannelBuffer)input), Protocol.readString((ChannelBuffer)input));
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER, true){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    ACQUIRE_INDEX_WRITE_LOCK((TargetCaller)new TargetCaller<Master, LockResult>(){

        public Response<LockResult> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.acquireIndexWriteLock(context, Protocol.readString((ChannelBuffer)input), Protocol.readString((ChannelBuffer)input));
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER, true){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    PUSH_TRANSACTION((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.pushTransaction(context, Protocol.readString((ChannelBuffer)input), input.readLong());
        }
    }, Protocol.VOID_SERIALIZER, true);

    final TargetCaller caller;
    final ObjectSerializer serializer;
    private final boolean includesSlaveContext;

    private <T> HaRequestType18(TargetCaller caller, ObjectSerializer<T> serializer, boolean includesSlaveContext) {
        this.caller = caller;
        this.serializer = serializer;
        this.includesSlaveContext = includesSlaveContext;
    }

    public ObjectSerializer getObjectSerializer() {
        return this.serializer;
    }

    public TargetCaller getTargetCaller() {
        return this.caller;
    }

    public byte id() {
        return (byte)this.ordinal();
    }

    public boolean includesSlaveContext() {
        return this.includesSlaveContext;
    }

    public boolean isLock() {
        return false;
    }
}

