/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.net.URI;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockManagerImpl;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;

public class LockManagerModeSwitcher
extends AbstractModeSwitcher<LockManager> {
    private final HaXaDataSourceManager xaDsm;
    private final DelegateInvocationHandler<Master> master;
    private final RequestContextFactory requestContextFactory;
    private final AbstractTransactionManager txManager;
    private final RemoteTxHook remoteTxHook;
    private final AvailabilityGuard availabilityGuard;
    private final Config config;

    public LockManagerModeSwitcher(HighAvailabilityMemberStateMachine stateMachine, DelegateInvocationHandler<LockManager> delegate, HaXaDataSourceManager xaDsm, DelegateInvocationHandler<Master> master, RequestContextFactory requestContextFactory, AbstractTransactionManager txManager, RemoteTxHook remoteTxHook, AvailabilityGuard availabilityGuard, Config config) {
        super(stateMachine, delegate);
        this.xaDsm = xaDsm;
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.txManager = txManager;
        this.remoteTxHook = remoteTxHook;
        this.availabilityGuard = availabilityGuard;
        this.config = config;
    }

    @Override
    protected LockManager getMasterImpl() {
        return new LockManagerImpl(new RagManager());
    }

    @Override
    protected LockManager getSlaveImpl(URI serverHaUri) {
        return new SlaveLockManager(new RagManager(), this.requestContextFactory, this.master.cement(), this.xaDsm, this.txManager, this.remoteTxHook, this.availabilityGuard, new SlaveLockManager.Configuration(){

            @Override
            public long getAvailabilityTimeout() {
                return (Long)LockManagerModeSwitcher.this.config.get(HaSettings.lock_read_timeout);
            }
        });
    }
}

