/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.management;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.DataSourceRegistrationListener;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.BranchedStoreInfo;

public final class BranchedStoreBean
extends ManagementBeanProvider {
    public BranchedStoreBean() {
        super(BranchedStore.class);
    }

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management, true);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management);
    }

    private static boolean isHA(ManagementData management) {
        return management.getKernelData().graphDatabase() instanceof HighlyAvailableGraphDatabase;
    }

    private static class BranchedStoreImpl
    extends Neo4jMBean
    implements BranchedStore {
        private File storePath;

        protected BranchedStoreImpl(final ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            XaDataSourceManager xadsm = (XaDataSourceManager)management.getKernelData().graphDatabase().getDependencyResolver().resolveDependency(XaDataSourceManager.class);
            xadsm.addDataSourceRegistrationListener(new DataSourceRegistrationListener(){

                public void registeredDataSource(XaDataSource ds) {
                    if (ds instanceof NeoStoreXaDataSource) {
                        BranchedStoreImpl.this.storePath = BranchedStoreImpl.this.extractStorePath(management);
                    }
                }

                public void unregisteredDataSource(XaDataSource ds) {
                    if (ds instanceof NeoStoreXaDataSource) {
                        BranchedStoreImpl.this.storePath = null;
                    }
                }
            });
        }

        protected BranchedStoreImpl(final ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            XaDataSourceManager xadsm = (XaDataSourceManager)management.getKernelData().graphDatabase().getDependencyResolver().resolveDependency(XaDataSourceManager.class);
            xadsm.addDataSourceRegistrationListener(new DataSourceRegistrationListener(){

                public void registeredDataSource(XaDataSource ds) {
                    if (ds instanceof NeoStoreXaDataSource) {
                        BranchedStoreImpl.this.storePath = BranchedStoreImpl.this.extractStorePath(management);
                    }
                }

                public void unregisteredDataSource(XaDataSource ds) {
                    if (ds instanceof NeoStoreXaDataSource) {
                        BranchedStoreImpl.this.storePath = null;
                    }
                }
            });
        }

        private File extractStorePath(ManagementData management) {
            File path;
            NeoStoreXaDataSource nioneodb = ((XaDataSourceManager)management.getKernelData().graphDatabase().getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource();
            try {
                path = new File(nioneodb.getStoreDir()).getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                path = new File(nioneodb.getStoreDir()).getAbsoluteFile();
            }
            return path;
        }

        public BranchedStoreInfo[] getBranchedStores() {
            if (this.storePath == null) {
                return new BranchedStoreInfo[0];
            }
            LinkedList<BranchedStoreInfo> toReturn = new LinkedList<BranchedStoreInfo>();
            for (File branchDirectory : BranchedDataPolicy.getBranchedDataRootDirectory(this.storePath).listFiles()) {
                if (!branchDirectory.isDirectory()) continue;
                toReturn.add(this.parseBranchedStore(branchDirectory));
            }
            return toReturn.toArray(new BranchedStoreInfo[0]);
        }

        private BranchedStoreInfo parseBranchedStore(File branchDirectory) {
            File neostoreFile = new File(branchDirectory, "neostore");
            long txId = NeoStore.getTxId((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (File)neostoreFile);
            long timestamp = Long.parseLong(branchDirectory.getName());
            return new BranchedStoreInfo(branchDirectory.getName(), txId, timestamp);
        }
    }
}

