/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TestClusterClientPadding {
    private static TargetDirectory dir = TargetDirectory.forTest(TestClusterClientPadding.class);
    private ClusterManager clusterManager;
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void before() throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterWithAdditionalClients(2, 1), dir.cleanDirectory("dbs"), MapUtil.stringMap((String[])new String[0]));
        this.clusterManager.start();
        this.cluster = this.clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesMembers(3));
        this.cluster.await(ClusterManager.allSeesAllAsJoined());
    }

    @After
    public void after() throws Throwable {
        this.clusterManager.shutdown();
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterIsShutDown() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = this.cluster.getMaster();
        this.cluster.shutdown(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable(sittingMaster));
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterFails() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = null;
        sittingMaster = this.cluster.getMaster();
        this.cluster.fail(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable(sittingMaster));
    }
}

