/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.TargetDirectory;

public class TestEnterpriseCacheType {
    private String storeDir = TargetDirectory.forTest(this.getClass()).makeGraphDbDir().getAbsolutePath();
    private GraphDatabaseAPI db;

    @Test
    public void defaultEmbeddedGraphDbShouldUseHighPerformanceCache() throws Exception {
        this.db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir);
        Assert.assertEquals((Object)"hpc", (Object)this.getCacheTypeUsed());
    }

    @Test
    public void defaultHaGraphDbShouldUseHighPerformanceCache() throws Exception {
        this.db = (GraphDatabaseAPI)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.storeDir).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, ":5001").newGraphDatabase();
        Assert.assertEquals((Object)"hpc", (Object)this.getCacheTypeUsed());
    }

    private String getCacheTypeUsed() {
        return (String)((Config)this.db.getDependencyResolver().resolveDependency(Config.class)).get(GraphDatabaseSettings.cache_type);
    }

    @After
    public void after() throws Exception {
        if (this.db != null) {
            this.db.shutdown();
        }
    }
}

