/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.BlockLogBuffer;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaRequestType201;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.nioneo.store.IdRange;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.TransactionAlreadyActiveException;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class MasterClient201
extends Client<Master>
implements MasterClient {
    public static final byte PROTOCOL_VERSION = 6;
    private final long lockReadTimeout;
    private final ByteCounterMonitor monitor;

    public MasterClient201(String hostNameOrIp, int port, Logging logging, Monitors monitors, StoreId storeId, long readTimeoutSeconds, long lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
        super(hostNameOrIp, port, logging, monitors, storeId, 0x1000000, (byte)6, readTimeoutSeconds, maxConcurrentChannels, chunkSize);
        this.lockReadTimeout = lockReadTimeout;
        this.monitor = (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, this.getClass(), new String[0]);
    }

    public MasterClient201(URI masterUri, Logging logging, Monitors monitors, StoreId storeId, Config config) {
        this(masterUri.getHost(), masterUri.getPort(), logging, monitors, storeId, (Long)config.get(HaSettings.read_timeout), (Long)config.get(HaSettings.lock_read_timeout), (Integer)config.get(HaSettings.max_concurrent_channels_per_slave), ((Long)config.get(HaSettings.com_chunk_size)).intValue());
    }

    protected long getReadTimeout(RequestType<Master> type, long readTimeout) {
        HaRequestType201 specificType = (HaRequestType201)type;
        if (specificType.isLock()) {
            return this.lockReadTimeout;
        }
        if (specificType == HaRequestType201.COPY_STORE) {
            return readTimeout * 2L;
        }
        return readTimeout;
    }

    protected boolean shouldCheckStoreId(RequestType<Master> type) {
        return type != HaRequestType201.COPY_STORE;
    }

    @Override
    public Response<IdAllocation> allocateIds(RequestContext context, final IdType idType) {
        return this.sendRequest(HaRequestType201.ALLOCATE_IDS, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                buffer.writeByte(idType.ordinal());
            }
        }, (Deserializer)new Deserializer<IdAllocation>(){

            public IdAllocation read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) {
                return MasterClient201.readIdAllocation(buffer);
            }
        });
    }

    @Override
    public Response<Integer> createRelationshipType(RequestContext context, final String name) {
        return this.sendRequest(HaRequestType201.CREATE_RELATIONSHIP_TYPE, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Integer> createPropertyKey(RequestContext context, final String name) {
        return this.sendRequest(HaRequestType201.CREATE_PROPERTY_KEY, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Integer> createLabel(RequestContext context, final String name) {
        return this.sendRequest(HaRequestType201.CREATE_LABEL, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Void> initializeTx(RequestContext context) {
        return this.sendRequest(HaRequestType201.INITIALIZE_TX, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireNodeWriteLock(RequestContext context, long ... nodes) {
        return this.sendRequest(HaRequestType201.ACQUIRE_NODE_WRITE_LOCK, context, new AcquireLockSerializer(nodes), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireNodeReadLock(RequestContext context, long ... nodes) {
        return this.sendRequest(HaRequestType201.ACQUIRE_NODE_READ_LOCK, context, new AcquireLockSerializer(nodes), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireRelationshipWriteLock(RequestContext context, long ... relationships) {
        return this.sendRequest(HaRequestType201.ACQUIRE_RELATIONSHIP_WRITE_LOCK, context, new AcquireLockSerializer(relationships), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireRelationshipReadLock(RequestContext context, long ... relationships) {
        return this.sendRequest(HaRequestType201.ACQUIRE_RELATIONSHIP_READ_LOCK, context, new AcquireLockSerializer(relationships), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireGraphWriteLock(RequestContext context) {
        return this.sendRequest(HaRequestType201.ACQUIRE_GRAPH_WRITE_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireGraphReadLock(RequestContext context) {
        return this.sendRequest(HaRequestType201.ACQUIRE_GRAPH_READ_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireIndexReadLock(RequestContext context, String index, String key) {
        return this.sendRequest(HaRequestType201.ACQUIRE_INDEX_READ_LOCK, context, new AcquireIndexLockSerializer(index, key), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireIndexWriteLock(RequestContext context, String index, String key) {
        return this.sendRequest(HaRequestType201.ACQUIRE_INDEX_WRITE_LOCK, context, new AcquireIndexLockSerializer(index, key), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireSchemaReadLock(RequestContext context) {
        return this.sendRequest(HaRequestType201.ACQUIRE_SCHEMA_READ_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireSchemaWriteLock(RequestContext context) {
        return this.sendRequest(HaRequestType201.ACQUIRE_SCHEMA_WRITE_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireIndexEntryWriteLock(RequestContext context, long labelId, long propertyKeyId, String propertyValue) {
        return this.sendRequest(HaRequestType201.ACQUIRE_INDEX_ENTRY_WRITE_LOCK, context, new AcquireIndexEntryLockSerializer(labelId, propertyKeyId, propertyValue), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<Long> commitSingleResourceTransaction(RequestContext context, final String resource, final TxExtractor txGetter) {
        return this.sendRequest(HaRequestType201.COMMIT, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)resource);
                BlockLogBuffer blockLogBuffer = new BlockLogBuffer(buffer, MasterClient201.this.monitor);
                txGetter.extract((LogBuffer)blockLogBuffer);
                blockLogBuffer.done();
            }
        }, (Deserializer)new Deserializer<Long>(){

            public Long read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readLong();
            }
        });
    }

    @Override
    public Response<Void> finishTransaction(RequestContext context, final boolean success) {
        try {
            return this.sendRequest(HaRequestType201.FINISH, context, new Serializer(){

                public void write(ChannelBuffer buffer) throws IOException {
                    buffer.writeByte(success ? 1 : 0);
                }
            }, Protocol.VOID_DESERIALIZER);
        }
        catch (TransactionAlreadyActiveException e) {
            if (!success) {
                return new Response(null, this.getStoreId(), TransactionStream.EMPTY, ResourceReleaser.NO_OP);
            }
            throw e;
        }
    }

    @Override
    public void rollbackOngoingTransactions(RequestContext context) {
        throw new UnsupportedOperationException("Should never be called from the client side");
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context) {
        return this.sendRequest(HaRequestType201.PULL_UPDATES, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<HandshakeResult> handshake(final long txId, StoreId storeId) {
        return this.sendRequest(HaRequestType201.HANDSHAKE, RequestContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                buffer.writeLong(txId);
            }
        }, (Deserializer)new Deserializer<HandshakeResult>(){

            public HandshakeResult read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return new HandshakeResult(buffer.readInt(), buffer.readLong(), buffer.readLong());
            }
        }, storeId);
    }

    @Override
    public Response<Void> copyStore(RequestContext context, StoreWriter writer) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(HaRequestType201.COPY_STORE, context, Protocol.EMPTY_SERIALIZER, (Deserializer)new Protocol.FileStreamsDeserializer(writer));
    }

    private RequestContext stripFromTransactions(RequestContext context) {
        return new RequestContext(context.getEpoch(), context.machineId(), context.getEventIdentifier(), new RequestContext.Tx[0], context.getMasterId(), context.getChecksum());
    }

    @Override
    public Response<Void> copyTransactions(RequestContext context, final String ds, final long startTxId, final long endTxId) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(HaRequestType201.COPY_TRANSACTIONS, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)ds);
                buffer.writeLong(startTxId);
                buffer.writeLong(endTxId);
            }
        }, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<Void> pushTransaction(RequestContext context, final String resourceName, final long tx) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(HaRequestType201.PUSH_TRANSACTION, context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)resourceName);
                buffer.writeLong(tx);
            }
        }, Protocol.VOID_DESERIALIZER);
    }

    protected static IdAllocation readIdAllocation(ChannelBuffer buffer) {
        int numberOfDefragIds = buffer.readInt();
        long[] defragIds = new long[numberOfDefragIds];
        for (int i = 0; i < numberOfDefragIds; ++i) {
            defragIds[i] = buffer.readLong();
        }
        long rangeStart = buffer.readLong();
        int rangeLength = buffer.readInt();
        long highId = buffer.readLong();
        long defragCount = buffer.readLong();
        return new IdAllocation(new IdRange(defragIds, rangeStart, rangeLength), highId, defragCount);
    }

    protected static class AcquireIndexEntryLockSerializer
    implements Serializer {
        private final long labelId;
        private final long propertyKeyId;
        private final String value;

        AcquireIndexEntryLockSerializer(long labelId, long propertyKeyId, String value) {
            this.labelId = labelId;
            this.propertyKeyId = propertyKeyId;
            this.value = value;
        }

        public void write(ChannelBuffer buffer) throws IOException {
            buffer.writeLong(this.labelId);
            buffer.writeLong(this.propertyKeyId);
            Protocol.writeString((ChannelBuffer)buffer, (String)this.value);
        }
    }

    protected static class AcquireIndexLockSerializer
    implements Serializer {
        private final String index;
        private final String key;

        AcquireIndexLockSerializer(String index, String key) {
            this.index = index;
            this.key = key;
        }

        public void write(ChannelBuffer buffer) throws IOException {
            Protocol.writeString((ChannelBuffer)buffer, (String)this.index);
            Protocol.writeString((ChannelBuffer)buffer, (String)this.key);
        }
    }

    protected static class AcquireLockSerializer
    implements Serializer {
        private final long[] entities;

        AcquireLockSerializer(long ... entities) {
            this.entities = entities;
        }

        public void write(ChannelBuffer buffer) throws IOException {
            buffer.writeInt(this.entities.length);
            for (long entity : this.entities) {
                buffer.writeLong(entity);
            }
        }
    }
}

