/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.StoreCopyMonitor;

class DefaultMasterImplSPI
implements MasterImpl.SPI {
    private static final int ID_GRAB_SIZE = 1000;
    private final DependencyResolver dependencyResolver;
    private final GraphDatabaseAPI graphDb;
    private final Logging logging;
    private final TransactionManager txManager;
    private final Monitors monitors;

    public DefaultMasterImplSPI(GraphDatabaseAPI graphDb, Logging logging, TransactionManager txManager, Monitors monitors) {
        this.graphDb = graphDb;
        this.logging = logging;
        this.txManager = txManager;
        this.dependencyResolver = graphDb.getDependencyResolver();
        this.monitors = monitors;
    }

    @Override
    public boolean isAccessible() {
        return this.graphDb.isAvailable(5000L);
    }

    @Override
    public void acquireLock(MasterImpl.LockGrabber grabber, Object ... entities) {
        LockManager lockManager = this.resolve(LockManager.class);
        AbstractTransactionManager dbTxManager = this.resolve(AbstractTransactionManager.class);
        TransactionState state = dbTxManager.getTransactionState();
        for (Object entity : entities) {
            grabber.grab(lockManager, state, entity);
        }
    }

    @Override
    public Transaction beginTx() throws SystemException, NotSupportedException {
        this.txManager.begin();
        return this.txManager.getTransaction();
    }

    @Override
    public void finishTransaction(boolean success) {
        try {
            if (success) {
                this.txManager.commit();
            } else {
                this.txManager.rollback();
            }
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    @Override
    public void suspendTransaction() throws SystemException {
        this.txManager.suspend();
    }

    @Override
    public void resumeTransaction(Transaction transaction) {
        try {
            this.txManager.resume(transaction);
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    @Override
    public GraphProperties graphProperties() {
        return this.resolve(NodeManager.class).getGraphProperties();
    }

    @Override
    public int getOrCreateLabel(String name) {
        LabelTokenHolder labels = this.resolve(LabelTokenHolder.class);
        return labels.getOrCreateId(name);
    }

    @Override
    public int getOrCreateProperty(String name) {
        PropertyKeyTokenHolder propertyKeyHolder = this.resolve(PropertyKeyTokenHolder.class);
        return propertyKeyHolder.getOrCreateId(name);
    }

    @Override
    public IdAllocation allocateIds(IdType idType) {
        IdGenerator generator = this.resolve(IdGeneratorFactory.class).get(idType);
        return new IdAllocation(generator.nextIdBatch(1000), generator.getHighId(), generator.getDefragCount());
    }

    @Override
    public StoreId storeId() {
        return this.graphDb.storeId();
    }

    @Override
    public long applyPreparedTransaction(String resource, ReadableByteChannel preparedTransaction) throws IOException {
        XaDataSource dataSource = this.resolve(XaDataSourceManager.class).getXaDataSource(resource);
        return dataSource.applyPreparedTransaction(preparedTransaction);
    }

    @Override
    public Integer createRelationshipType(String name) {
        return this.resolve(RelationshipTypeTokenHolder.class).getOrCreateId(name);
    }

    @Override
    public Pair<Integer, Long> getMasterIdForCommittedTx(long txId) throws IOException {
        NeoStoreXaDataSource nioneoDataSource = this.resolve(XaDataSourceManager.class).getNeoStoreDataSource();
        return nioneoDataSource.getMasterForCommittedTx(txId);
    }

    @Override
    public RequestContext rotateLogsAndStreamStoreFiles(StoreWriter writer) {
        XaDataSourceManager xaDataSourceManager = this.resolve(XaDataSourceManager.class);
        KernelPanicEventGenerator kernelPanicEventGenerator = this.resolve(KernelPanicEventGenerator.class);
        return ServerUtil.rotateLogsAndStreamStoreFiles((String)this.graphDb.getStoreDir(), (XaDataSourceManager)xaDataSourceManager, (KernelPanicEventGenerator)kernelPanicEventGenerator, (StringLogger)this.logging.getMessagesLog(MasterImpl.class), (boolean)true, (StoreWriter)writer, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), (StoreCopyMonitor)((StoreCopyMonitor)this.monitors.newMonitor(StoreCopyMonitor.class, this.getClass(), new String[0])));
    }

    @Override
    public Response<Void> copyTransactions(String dsName, long startTxId, long endTxId) {
        return ServerUtil.getTransactions((GraphDatabaseAPI)this.graphDb, (String)dsName, (long)startTxId, (long)endTxId);
    }

    @Override
    public <T> Response<T> packResponse(RequestContext context, T response, Predicate<Long> filter) {
        XaDataSourceManager xaDataSourceManager = this.resolve(XaDataSourceManager.class);
        return ServerUtil.packResponse((StoreId)this.storeId(), (XaDataSourceManager)xaDataSourceManager, (RequestContext)context, response, filter);
    }

    @Override
    public void pushTransaction(String resourceName, int eventIdentifier, long tx, int machineId) {
        XaDataSourceManager xaDataSourceManager = this.resolve(XaDataSourceManager.class);
        TxIdGenerator txIdGenerator = this.resolve(TxIdGenerator.class);
        txIdGenerator.committed(xaDataSourceManager.getXaDataSource(resourceName), eventIdentifier, tx, Integer.valueOf(machineId));
    }

    private <T> T resolve(Class<T> dependencyType) {
        return (T)this.dependencyResolver.resolveDependency(dependencyType);
    }
}

