/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.TransactionNotPresentOnMasterException;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.ha.lock.LockableNode;
import org.neo4j.kernel.ha.lock.LockableRelationship;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.IndexLock;
import org.neo4j.kernel.impl.core.SchemaLock;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.locking.IndexEntryLock;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TransactionAlreadyActiveException;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;

public class MasterImpl
extends LifecycleAdapter
implements Master {
    public static final int TX_TIMEOUT_ADDITION = 5000;
    public static final int UNFINISHED_TRANSACTION_CLEANUP_DELAY = 1;
    private final SPI spi;
    private final StringLogger msgLog;
    private final Config config;
    private final Monitor monitor;
    private final long epoch;
    private Map<RequestContext, MasterTransaction> transactions = new ConcurrentHashMap<RequestContext, MasterTransaction>();
    private ScheduledExecutorService unfinishedTransactionsExecutor;
    private long unfinishedTransactionThresholdMillis;
    private static LockGrabber READ_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, TransactionState state, Object entity) {
            state.acquireReadLock(entity);
        }
    };
    private static LockGrabber WRITE_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, TransactionState state, Object entity) {
            state.acquireWriteLock(entity);
        }
    };

    public MasterImpl(SPI spi, Monitor monitor, Logging logging, Config config) {
        this.spi = spi;
        this.msgLog = logging.getMessagesLog(this.getClass());
        this.config = config;
        this.monitor = monitor;
        this.epoch = this.generateEpoch();
    }

    private long generateEpoch() {
        return (long)((InstanceId)this.config.get(ClusterSettings.server_id)).toIntegerIndex() << 48 | System.currentTimeMillis();
    }

    public void start() throws Throwable {
        this.unfinishedTransactionThresholdMillis = (Long)this.config.get(HaSettings.lock_read_timeout) + 5000L;
        this.unfinishedTransactionsExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Unfinished transaction reaper"));
        this.unfinishedTransactionsExecutor.scheduleWithFixedDelay(new UnfinishedTransactionReaper(), 1L, 1L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.unfinishedTransactionsExecutor.shutdown();
        this.transactions = null;
    }

    @Override
    public Response<Void> initializeTx(RequestContext context) {
        this.monitor.initializeTx(context);
        if (!this.spi.isAccessible()) {
            throw new TransactionFailureException("Database is currently not available");
        }
        this.assertCorrectEpoch(context);
        boolean beganTx = false;
        try {
            Transaction tx = this.spi.beginTx();
            this.transactions.put(context, new MasterTransaction(tx));
            beganTx = true;
            Response<Object> response = this.packResponse(context, null);
            return response;
        }
        catch (NotSupportedException | SystemException e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        finally {
            if (beganTx) {
                this.suspendTransaction(context);
            }
        }
    }

    private void assertCorrectEpoch(RequestContext context) {
        if (this.epoch != context.getEpoch()) {
            throw new InvalidEpochException(this.epoch, context.getEpoch());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response<LockResult> acquireLock(RequestContext context, LockGrabber lockGrabber, Object ... entities) {
        this.assertCorrectEpoch(context);
        this.resumeTransaction(context);
        try {
            this.spi.acquireLock(lockGrabber, entities);
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.OK_LOCKED));
            return response;
        }
        catch (DeadlockDetectedException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(e.getMessage()));
            return response;
        }
        catch (IllegalResourceException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.NOT_LOCKED));
            return response;
        }
        finally {
            this.suspendTransaction(context);
        }
    }

    private <T> Response<T> packResponse(RequestContext context, T response) {
        return this.packResponse(context, response, (Predicate<Long>)ServerUtil.ALL);
    }

    private <T> Response<T> packResponse(RequestContext context, T response, Predicate<Long> filter) {
        return this.spi.packResponse(context, response, filter);
    }

    private Transaction getTx(RequestContext txId) {
        MasterTransaction result = this.transactions.get(txId);
        if (result == null) {
            throw new TransactionNotPresentOnMasterException(txId);
        }
        result.resetTime();
        return result.transaction;
    }

    private void resumeTransaction(RequestContext txId) {
        this.spi.resumeTransaction(this.getTx(txId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendTransaction(RequestContext context) {
        try {
            MasterTransaction tx = this.transactions.get(context);
            if (tx.finishAsap()) {
                this.finishTransaction(context, false);
                return;
            }
            tx.updateTime();
        }
        finally {
            try {
                this.spi.suspendTransaction();
            }
            catch (SystemException e) {
                throw Exceptions.launderedException((Throwable)e);
            }
        }
    }

    private void finishTransaction0(RequestContext txId, boolean success) {
        try {
            this.spi.finishTransaction(success);
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        finally {
            this.transactions.remove(txId);
        }
    }

    @Override
    public Response<LockResult> acquireNodeReadLock(RequestContext context, long ... nodes) {
        return this.acquireLock(context, READ_LOCK_GRABBER, this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireNodeWriteLock(RequestContext context, long ... nodes) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireRelationshipReadLock(RequestContext context, long ... relationships) {
        return this.acquireLock(context, READ_LOCK_GRABBER, this.relationshipsById(relationships));
    }

    @Override
    public Response<LockResult> acquireRelationshipWriteLock(RequestContext context, long ... relationships) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, this.relationshipsById(relationships));
    }

    @Override
    public Response<LockResult> acquireGraphReadLock(RequestContext context) {
        return this.acquireLock(context, READ_LOCK_GRABBER, this.spi.graphProperties());
    }

    @Override
    public Response<LockResult> acquireGraphWriteLock(RequestContext context) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, this.spi.graphProperties());
    }

    private Node[] nodesById(long[] ids) {
        Node[] result = new Node[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableNode(ids[i]);
        }
        return result;
    }

    private Relationship[] relationshipsById(long[] ids) {
        Relationship[] result = new Relationship[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableRelationship(ids[i]);
        }
        return result;
    }

    @Override
    public Response<IdAllocation> allocateIds(RequestContext context, IdType idType) {
        this.assertCorrectEpoch(context);
        IdAllocation result = this.spi.allocateIds(idType);
        return ServerUtil.packResponseWithoutTransactionStream((StoreId)this.spi.storeId(), (Object)result);
    }

    @Override
    public Response<Long> commitSingleResourceTransaction(RequestContext context, String resource, TxExtractor txGetter) {
        this.assertCorrectEpoch(context);
        this.resumeTransaction(context);
        try {
            final long txId = this.spi.applyPreparedTransaction(resource, txGetter.extract());
            Predicate<Long> upUntilThisTx = new Predicate<Long>(){

                public boolean accept(Long item) {
                    return item < txId;
                }
            };
            Response<Long> response = this.packResponse(context, txId, upUntilThisTx);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.suspendTransaction(context);
        }
    }

    @Override
    public Response<Void> finishTransaction(RequestContext context, boolean success) {
        this.assertCorrectEpoch(context);
        try {
            this.resumeTransaction(context);
        }
        catch (TransactionNotPresentOnMasterException e) {
            throw e;
        }
        catch (RuntimeException e) {
            MasterTransaction masterTransaction = this.transactions.get(context);
            if (masterTransaction != null) {
                masterTransaction.markAsFinishAsap();
            }
            throw e;
        }
        this.finishTransaction0(context, success);
        return this.packResponse(context, null);
    }

    @Override
    public Response<Integer> createRelationshipType(RequestContext context, String name) {
        this.assertCorrectEpoch(context);
        return this.packResponse(context, this.spi.createRelationshipType(name));
    }

    @Override
    public Response<Integer> createPropertyKey(RequestContext context, String name) {
        this.assertCorrectEpoch(context);
        return this.packResponse(context, this.spi.getOrCreateProperty(name));
    }

    @Override
    public Response<Integer> createLabel(RequestContext context, String name) {
        this.assertCorrectEpoch(context);
        return this.packResponse(context, this.spi.getOrCreateLabel(name));
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context) {
        return this.packResponse(context, null);
    }

    @Override
    public Response<HandshakeResult> handshake(long txId, StoreId storeId) {
        try {
            Pair<Integer, Long> masterId = this.spi.getMasterIdForCommittedTx(txId);
            return ServerUtil.packResponseWithoutTransactionStream((StoreId)this.spi.storeId(), (Object)new HandshakeResult((Integer)masterId.first(), (Long)masterId.other(), this.epoch));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get master ID for " + txId, e);
        }
    }

    @Override
    public Response<Void> copyStore(RequestContext context, StoreWriter writer) {
        context = this.spi.rotateLogsAndStreamStoreFiles(writer);
        writer.done();
        return this.packResponse(context, null);
    }

    @Override
    public Response<Void> copyTransactions(RequestContext context, String dsName, long startTxId, long endTxId) {
        return this.spi.copyTransactions(dsName, startTxId, endTxId);
    }

    @Override
    public Response<LockResult> acquireIndexReadLock(RequestContext context, String index, String key) {
        return this.acquireLock(context, READ_LOCK_GRABBER, new IndexLock(index, key));
    }

    @Override
    public Response<LockResult> acquireIndexWriteLock(RequestContext context, String index, String key) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, new IndexLock(index, key));
    }

    @Override
    public Response<LockResult> acquireSchemaReadLock(RequestContext context) {
        return this.acquireLock(context, READ_LOCK_GRABBER, new SchemaLock());
    }

    @Override
    public Response<LockResult> acquireSchemaWriteLock(RequestContext context) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, new SchemaLock());
    }

    @Override
    public Response<LockResult> acquireIndexEntryWriteLock(RequestContext context, long labelId, long propertyKeyId, String propertyValue) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, new IndexEntryLock(IoPrimitiveUtils.safeCastLongToInt((long)labelId), IoPrimitiveUtils.safeCastLongToInt((long)propertyKeyId), propertyValue));
    }

    @Override
    public Response<Void> pushTransaction(RequestContext context, String resourceName, long tx) {
        this.assertCorrectEpoch(context);
        this.spi.pushTransaction(resourceName, context.getEventIdentifier(), tx, context.machineId());
        return new Response(null, this.spi.storeId(), TransactionStream.EMPTY, ResourceReleaser.NO_OP);
    }

    public Map<Integer, Collection<RequestContext>> getOngoingTransactions() {
        HashMap<Integer, Collection<RequestContext>> result = new HashMap<Integer, Collection<RequestContext>>();
        Set<RequestContext> contexts = this.transactions.keySet();
        for (RequestContext context : contexts.toArray(new RequestContext[contexts.size()])) {
            ArrayList<RequestContext> txs = (ArrayList<RequestContext>)result.get(context.machineId());
            if (txs == null) {
                txs = new ArrayList<RequestContext>();
                result.put(context.machineId(), txs);
            }
            txs.add(context);
        }
        return result;
    }

    private class UnfinishedTransactionReaper
    implements Runnable {
        private UnfinishedTransactionReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HashMap safeTransactions;
                Map map = MasterImpl.this.transactions;
                synchronized (map) {
                    safeTransactions = new HashMap(MasterImpl.this.transactions);
                }
                for (Map.Entry entry : safeTransactions.entrySet()) {
                    long time = ((MasterTransaction)entry.getValue()).timeLastSuspended.get();
                    if ((time == 0L || System.currentTimeMillis() - time < MasterImpl.this.unfinishedTransactionThresholdMillis) && !((MasterTransaction)entry.getValue()).finishAsap()) continue;
                    long displayableTime = time == 0L ? 0L : System.currentTimeMillis() - time;
                    String oldTxDescription = String.format("old tx %s: %s at age %s ms", entry.getKey(), ((MasterTransaction)entry.getValue()).transaction, displayableTime);
                    try {
                        MasterImpl.this.resumeTransaction((RequestContext)entry.getKey());
                        MasterImpl.this.finishTransaction0((RequestContext)entry.getKey(), false);
                        MasterImpl.this.msgLog.info("Rolled back " + oldTxDescription);
                    }
                    catch (TransactionAlreadyActiveException e) {
                    }
                    catch (Throwable t) {
                        MasterImpl.this.msgLog.warn("Unable to roll back " + oldTxDescription, t);
                    }
                }
            }
            catch (Throwable t) {
                MasterImpl.this.msgLog.warn("Exception running " + this.getClass().getName() + ", although will continue...", t);
            }
        }
    }

    private static class MasterTransaction {
        private final Transaction transaction;
        private final AtomicLong timeLastSuspended = new AtomicLong();
        private volatile boolean finishAsap;

        MasterTransaction(Transaction transaction) {
            this.transaction = transaction;
        }

        void updateTime() {
            this.timeLastSuspended.set(System.currentTimeMillis());
        }

        void resetTime() {
            this.timeLastSuspended.set(0L);
        }

        void markAsFinishAsap() {
            this.finishAsap = true;
        }

        public String toString() {
            return this.transaction + "[lastSuspended=" + this.timeLastSuspended + ", finishAsap=" + this.finishAsap + "]";
        }

        boolean finishAsap() {
            return this.finishAsap;
        }
    }

    public static interface LockGrabber {
        public void grab(LockManager var1, TransactionState var2, Object var3);
    }

    public static interface SPI {
        public boolean isAccessible();

        public void acquireLock(LockGrabber var1, Object ... var2);

        public Transaction beginTx() throws SystemException, NotSupportedException;

        public void finishTransaction(boolean var1);

        public void suspendTransaction() throws SystemException;

        public void resumeTransaction(Transaction var1);

        public GraphProperties graphProperties();

        public IdAllocation allocateIds(IdType var1);

        public StoreId storeId();

        public long applyPreparedTransaction(String var1, ReadableByteChannel var2) throws IOException;

        public Integer createRelationshipType(String var1);

        public Pair<Integer, Long> getMasterIdForCommittedTx(long var1) throws IOException;

        public RequestContext rotateLogsAndStreamStoreFiles(StoreWriter var1);

        public Response<Void> copyTransactions(String var1, long var2, long var4);

        public <T> Response<T> packResponse(RequestContext var1, T var2, Predicate<Long> var3);

        public void pushTransaction(String var1, int var2, long var3, int var5);

        public int getOrCreateLabel(String var1);

        public int getOrCreateProperty(String var1);
    }

    public static interface Monitor {
        public void initializeTx(RequestContext var1);
    }
}

