/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.List;
import javax.transaction.Transaction;
import org.neo4j.com.Response;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LocalDeadlockDetectedException;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.IndexLock;
import org.neo4j.kernel.impl.locking.IndexEntryLock;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockManagerImpl;
import org.neo4j.kernel.impl.transaction.LockNotFoundException;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.info.LockInfo;
import org.neo4j.kernel.logging.Logging;

public class SlaveLockManager
implements LockManager {
    private final RequestContextFactory requestContextFactory;
    private final LockManagerImpl local;
    private final Master master;
    private final HaXaDataSourceManager xaDsm;
    private final AbstractTransactionManager txManager;
    private final RemoteTxHook txHook;
    private final AvailabilityGuard availabilityGuard;
    private final Configuration config;

    public SlaveLockManager(RagManager ragManager, RequestContextFactory requestContextFactory, Master master, HaXaDataSourceManager xaDsm, AbstractTransactionManager txManager, RemoteTxHook txHook, AvailabilityGuard availabilityGuard, Configuration config) {
        this.requestContextFactory = requestContextFactory;
        this.xaDsm = xaDsm;
        this.txManager = txManager;
        this.txHook = txHook;
        this.availabilityGuard = availabilityGuard;
        this.config = config;
        this.local = new LockManagerImpl(ragManager);
        this.master = master;
    }

    public long getDetectedDeadlockCount() {
        return this.local.getDetectedDeadlockCount();
    }

    public void getReadLock(Object resource, Transaction tx) throws DeadlockDetectedException, IllegalResourceException {
        if (this.getReadLockOnMaster(resource) && !this.local.tryReadLock(resource, tx)) {
            throw new LocalDeadlockDetectedException((LockManager)this.local, tx, resource, LockType.READ);
        }
    }

    private boolean getReadLockOnMaster(Object resource) {
        Response<LockResult> response;
        if (resource instanceof Node) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireNodeReadLock(this.requestContextFactory.newRequestContext(), ((Node)resource).getId());
        } else if (resource instanceof Relationship) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireRelationshipReadLock(this.requestContextFactory.newRequestContext(), ((Relationship)resource).getId());
        } else if (resource instanceof GraphProperties) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireGraphReadLock(this.requestContextFactory.newRequestContext());
        } else if (resource instanceof IndexLock) {
            this.makeSureTxHasBeenInitialized();
            IndexLock indexLock = (IndexLock)resource;
            response = this.master.acquireIndexReadLock(this.requestContextFactory.newRequestContext(), indexLock.getIndex(), indexLock.getKey());
        } else {
            return true;
        }
        return this.receiveLockResponse(response);
    }

    private boolean receiveLockResponse(Response<LockResult> response) {
        LockResult result = this.xaDsm.applyTransactions(response);
        switch (result.getStatus()) {
            case DEAD_LOCKED: {
                throw new DeadlockDetectedException(result.getDeadlockMessage());
            }
            case NOT_LOCKED: {
                throw new UnsupportedOperationException();
            }
            case OK_LOCKED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(result.toString());
            }
        }
        return true;
    }

    public void getWriteLock(Object resource, Transaction tx) throws DeadlockDetectedException, IllegalResourceException {
        if (this.getWriteLockOnMaster(resource) && !this.local.tryWriteLock(resource, tx)) {
            throw new LocalDeadlockDetectedException((LockManager)this.local, tx, resource, LockType.WRITE);
        }
    }

    public boolean tryReadLock(Object resource, Transaction tx) throws LockNotFoundException, IllegalResourceException {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    public boolean tryWriteLock(Object resource, Transaction tx) throws LockNotFoundException, IllegalResourceException {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    private UnsupportedOperationException newUnsupportedDirectTryLockUsageException() {
        return new UnsupportedOperationException("At the time of adding \"try lock\" semantics there was no usage of " + this.getClass().getSimpleName() + " calling it directly. It was designed to be called on a local " + LockManager.class.getSimpleName() + " delegated to from within the waiting version");
    }

    private boolean getWriteLockOnMaster(Object resource) {
        Response<LockResult> response;
        if (resource instanceof Node) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireNodeWriteLock(this.requestContextFactory.newRequestContext(), ((Node)resource).getId());
        } else if (resource instanceof Relationship) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireRelationshipWriteLock(this.requestContextFactory.newRequestContext(), ((Relationship)resource).getId());
        } else if (resource instanceof GraphProperties) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireGraphWriteLock(this.requestContextFactory.newRequestContext());
        } else if (resource instanceof IndexEntryLock) {
            this.makeSureTxHasBeenInitialized();
            IndexEntryLock lock = (IndexEntryLock)resource;
            response = this.master.acquireIndexEntryWriteLock(this.requestContextFactory.newRequestContext(), lock.labelId(), lock.propertyKeyId(), lock.propertyValue());
        } else if (resource instanceof IndexLock) {
            this.makeSureTxHasBeenInitialized();
            IndexLock indexLock = (IndexLock)resource;
            response = this.master.acquireIndexWriteLock(this.requestContextFactory.newRequestContext(), indexLock.getIndex(), indexLock.getKey());
        } else {
            throw new IllegalArgumentException("Don't know how to take lock on resource: '" + resource + "'.");
        }
        return this.receiveLockResponse(response);
    }

    public void releaseReadLock(Object resource, Transaction tx) throws LockNotFoundException, IllegalResourceException {
        this.local.releaseReadLock(resource, tx);
    }

    public void releaseWriteLock(Object resource, Transaction tx) throws LockNotFoundException, IllegalResourceException {
        this.local.releaseWriteLock(resource, tx);
    }

    public void dumpLocksOnResource(Object resource, Logging logging) {
        this.local.dumpLocksOnResource(resource, logging);
    }

    public List<LockInfo> getAllLocks() {
        return this.local.getAllLocks();
    }

    public List<LockInfo> getAwaitedLocks(long minWaitTime) {
        return this.local.getAwaitedLocks(minWaitTime);
    }

    public void dumpRagStack(Logging logging) {
        this.local.dumpRagStack(logging);
    }

    public void dumpAllLocks(Logging logging) {
        this.local.dumpAllLocks(logging);
    }

    private void makeSureTxHasBeenInitialized() {
        if (!this.availabilityGuard.isAvailable(this.config.getAvailabilityTimeout())) {
            throw new RuntimeException("Timed out waiting for database to allow operations to proceed. " + this.availabilityGuard.describeWhoIsBlocking());
        }
        this.txHook.remotelyInitializeTransaction(this.txManager.getEventIdentifier(), this.txManager.getTransactionState());
    }

    public static interface Configuration {
        public long getAvailabilityTimeout();
    }
}

