/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TestPullUpdates {
    private ClusterManager.ManagedCluster cluster;
    private static final int PULL_INTERVAL = 100;
    private static final int SHELL_PORT = 6370;

    @After
    public void doAfter() throws Throwable {
        if (this.cluster != null) {
            this.cluster.stop();
        }
    }

    @Test
    public void makeSureUpdatePullerGetsGoingAfterMasterSwitch() throws Throwable {
        File root = TargetDirectory.forTest(this.getClass()).directory("makeSureUpdatePullerGetsGoingAfterMasterSwitch", true);
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), root, MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "100ms"}));
        clusterManager.start();
        this.cluster = clusterManager.getDefaultCluster();
        long commonNodeId = this.createNodeOnMaster();
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.setProperty(master, commonNodeId, 1);
        this.awaitPropagation(1, commonNodeId, this.cluster);
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        ClusterManager.RepairKit masterShutdownRK = this.cluster.shutdown(master);
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        this.setProperty(this.cluster.getMaster(), commonNodeId, 2);
        masterShutdownRK.repair();
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        this.awaitPropagation(2, commonNodeId, this.cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pullUpdatesShellAppPullsUpdates() throws Throwable {
        File root = TargetDirectory.forTest(this.getClass()).directory("pullUpdatesShellAppPullsUpdates", true);
        HashMap<Integer, Map<String, String>> instanceConfig = new HashMap<Integer, Map<String, String>>();
        for (int i = 1; i <= 2; ++i) {
            Map thisInstance = MapUtil.stringMap((String[])new String[]{ShellSettings.remote_shell_port.name(), "" + (6370 + i)});
            instanceConfig.put(i, thisInstance);
        }
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(2), root, MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "0", HaSettings.tx_push_factor.name(), "0", ShellSettings.remote_shell_enabled.name(), "true"}), instanceConfig);
        clusterManager.start();
        this.cluster = clusterManager.getDefaultCluster();
        long commonNodeId = this.createNodeOnMaster();
        this.setProperty(this.cluster.getMaster(), commonNodeId, 1);
        this.callPullUpdatesViaShell(2);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Transaction transaction = slave.beginTx();
        try {
            Assert.assertEquals((Object)1, (Object)slave.getNodeById(commonNodeId).getProperty("i"));
        }
        finally {
            transaction.finish();
        }
    }

    private long createNodeOnMaster() {
        long commonNodeId;
        try (Transaction tx = this.cluster.getMaster().beginTx();){
            commonNodeId = this.cluster.getMaster().createNode().getId();
            tx.success();
        }
        return commonNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPullUpdatesOnStartupNoMatterWhat() throws Exception {
        GraphDatabaseService slave = null;
        GraphDatabaseService master = null;
        try {
            long nodeId;
            File masterDir = TargetDirectory.forTest(this.getClass()).directory("master", true);
            master = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(masterDir.getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, ":5001").newGraphDatabase();
            File slaveDir = TargetDirectory.forTest(this.getClass()).directory("slave", true);
            slave = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(slaveDir.getAbsolutePath()).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, ":5001").newGraphDatabase();
            final CountDownLatch slaveLeftLatch = new CountDownLatch(1);
            final ClusterClient masterClusterClient = (ClusterClient)((HighlyAvailableGraphDatabase)master).getDependencyResolver().resolveDependency(ClusterClient.class);
            masterClusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

                public void leftCluster(InstanceId instanceId) {
                    slaveLeftLatch.countDown();
                    masterClusterClient.removeClusterListener((ClusterListener)this);
                }
            });
            System.out.println("MASTER:" + master.isAvailable(60L));
            System.out.println("SLAVE:" + slave.isAvailable(60L));
            ((StringLogger)((GraphDatabaseAPI)master).getDependencyResolver().resolveDependency(StringLogger.class)).info("SHUTTING DOWN SLAVE");
            slave.shutdown();
            if (!slaveLeftLatch.await(60L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Timeout waiting for slave to leave");
            }
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                node.setProperty("from", (Object)"master");
                nodeId = node.getId();
                tx.success();
            }
            slave = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(slaveDir.getAbsolutePath()).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, ":5001").setConfig(HaSettings.pull_interval, "0").newGraphDatabase();
            slave.beginTx().close();
            tx = slave.beginTx();
            var10_8 = null;
            try {
                Assert.assertEquals((Object)"master", (Object)slave.getNodeById(nodeId).getProperty("from"));
                tx.success();
            }
            catch (Throwable throwable) {
                var10_8 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var10_8 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var10_8.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            if (slave != null) {
                slave.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private void callPullUpdatesViaShell(int i) throws ShellException {
        ShellClient client = ShellLobby.newClient((int)(6370 + i));
        client.evaluate("pullupdates");
    }

    private void powerNap() throws InterruptedException {
        Thread.sleep(50L);
    }

    private void awaitPropagation(int i, long nodeId, ClusterManager.ManagedCluster cluster) throws Exception {
        long endTime = System.currentTimeMillis() + 2000L;
        boolean ok = false;
        while (!ok && System.currentTimeMillis() < endTime) {
            ok = true;
            for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
                try {
                    Transaction tx = db.beginTx();
                    Throwable throwable = null;
                    try {
                        Number value = (Number)db.getNodeById(nodeId).getProperty("i", null);
                        if (value != null && value.intValue() == i) continue;
                        ok = false;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (NotFoundException e) {
                    ok = false;
                }
            }
            if (ok) continue;
            this.powerNap();
        }
        Assert.assertTrue((String)"Change wasn't propagated by pulling updates", (boolean)ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperty(HighlyAvailableGraphDatabase db, long nodeId, int i) throws Exception {
        Transaction tx = db.beginTx();
        try {
            db.getNodeById(nodeId).setProperty("i", (Object)i);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

