/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.upgrade;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.ha.upgrade.LegacyDatabase;
import org.neo4j.ha.upgrade.LegacyDatabaseImpl;
import org.neo4j.ha.upgrade.Utils;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

@Ignore(value="Keep this test around as it's a very simple and 'close' test to quickly verify rolling upgrades")
public class RollingUpgradeIT {
    private static final String OLD_VERSION = "2.0.0";
    private final TargetDirectory DIR = TargetDirectory.forTest(this.getClass());
    private final File DBS_DIR = this.DIR.directory("dbs", true);
    private LegacyDatabase[] legacyDbs;
    private GraphDatabaseAPI[] newDbs;

    @Test
    public void doRollingUpgradeFromPreviousVersionWithMasterLast() throws Throwable {
        try {
            this.startOldVersionCluster();
            this.rollOverToNewVersion();
            this.verify();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void debug(String message) {
        this.debug(message, true);
    }

    private void debug(String message, boolean enter) {
        String string = "RUT " + message;
        if (enter) {
            System.out.println(string);
        } else {
            System.out.print(string);
        }
    }

    @After
    public void cleanUp() throws Exception {
        if (this.legacyDbs != null) {
            for (int i = 0; i < this.legacyDbs.length; ++i) {
                this.stop(i);
            }
        }
        if (this.newDbs != null) {
            for (GraphDatabaseAPI db : this.newDbs) {
                db.shutdown();
            }
        }
    }

    private void startOldVersionCluster() throws Exception {
        int i;
        this.debug("Downloading 2.0.0 package");
        File oldVersionPackage = Utils.downloadAndUnpack("http://download.neo4j.org/artifact?edition=enterprise&version=2.0.0&distribution=zip", this.DIR.directory("download"), "2.0.0-enterprise");
        String classpath = Utils.assembleClassPathFromPackage(oldVersionPackage);
        this.debug("Starting 2.0.0 cluster in separate jvms");
        Future[] legacyDbFutures = new Future[3];
        for (i = 0; i < legacyDbFutures.length; ++i) {
            legacyDbFutures[i] = LegacyDatabaseImpl.start(classpath, new File(this.DBS_DIR, "" + i), this.config(i));
            this.debug("  Started " + i);
        }
        this.legacyDbs = new LegacyDatabase[legacyDbFutures.length];
        for (i = 0; i < legacyDbFutures.length; ++i) {
            this.legacyDbs[i] = (LegacyDatabase)legacyDbFutures[i].get();
        }
        for (LegacyDatabase db : this.legacyDbs) {
            this.debug("  Awaiting " + db.getStoreDir() + " to start");
            db.awaitStarted(10L, TimeUnit.SECONDS);
            this.debug("  " + db.getStoreDir() + " fully started");
        }
        for (int i2 = 0; i2 < this.legacyDbs.length; ++i2) {
            String name = "initial-" + i2;
            long node = this.legacyDbs[i2].createNode(name);
            for (LegacyDatabase db : this.legacyDbs) {
                db.verifyNodeExists(node, name);
            }
        }
        this.debug("2.0.0 cluster fully operational");
    }

    private Map<String, String> config(int serverId) throws UnknownHostException {
        String localhost = InetAddress.getLocalHost().getHostAddress();
        Map result = MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "" + serverId, ClusterSettings.cluster_server.name(), localhost + ":" + (5000 + serverId), HaSettings.ha_server.name(), localhost + ":" + (6000 + serverId), ClusterSettings.initial_hosts.name(), localhost + ":" + 5000 + "," + localhost + ":" + 5001 + "," + localhost + ":" + 5002});
        return result;
    }

    private void rollOverToNewVersion() throws Exception {
        this.debug("Starting to roll over to current version");
        Pair<LegacyDatabase, Integer> master = this.findOutWhoIsMaster();
        this.newDbs = new GraphDatabaseAPI[this.legacyDbs.length];
        for (int i = 0; i < this.legacyDbs.length; ++i) {
            LegacyDatabase legacyDb = this.legacyDbs[i];
            if (legacyDb == master.first()) continue;
            this.rollOver(legacyDb, i);
        }
        this.rollOver((LegacyDatabase)master.first(), (Integer)master.other());
    }

    private void rollOver(LegacyDatabase legacyDb, int i) throws Exception {
        int j;
        String storeDir = legacyDb.getStoreDir();
        this.stop(i);
        Thread.sleep(30000L);
        this.debug("Starting " + i + " as current version");
        this.newDbs[i] = (GraphDatabaseAPI)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(this.config(i)).newGraphDatabase();
        this.debug("Started " + i + " as current version");
        this.legacyDbs[i] = null;
        String name = "upgraded-" + i;
        long node = this.createNodeWithRetry((GraphDatabaseService)this.newDbs[i], name);
        this.debug("Node created on " + i);
        for (j = 0; j < i; ++j) {
            if (this.legacyDbs[i] == null) continue;
            this.legacyDbs[j].verifyNodeExists(node, name);
            this.debug("Verified on legacy db " + j);
        }
        for (j = 0; j < this.newDbs.length; ++j) {
            if (this.newDbs[j] == null) continue;
            this.verifyNodeExists(this.newDbs[j], node, name);
            this.debug("Verified on new db " + j);
        }
    }

    private Pair<LegacyDatabase, Integer> findOutWhoIsMaster() {
        try {
            for (int i = 0; i < this.legacyDbs.length; ++i) {
                LegacyDatabase db = this.legacyDbs[i];
                if (!db.isMaster()) continue;
                return Pair.of((Object)db, (Object)i);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("No master");
    }

    private void stop(int i) {
        try {
            LegacyDatabase legacyDb = this.legacyDbs[i];
            if (legacyDb != null) {
                legacyDb.stop();
                this.legacyDbs[i] = null;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void verify() {
    }

    private long createNodeWithRetry(GraphDatabaseService db, String name) throws InterruptedException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(120L);
        Exception exception = null;
        while (System.currentTimeMillis() < end) {
            try {
                return this.createNode(db, name);
            }
            catch (Exception e) {
                exception = e;
                this.debug("Master not switched yet, retrying in a jiffy (" + e + ")");
                Thread.sleep(1024L);
            }
        }
        throw Exceptions.launderedException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNode(GraphDatabaseService db, String name) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    private void verifyNodeExists(GraphDatabaseAPI db, long id, String name) {
        try (Transaction tx = db.beginTx();){
            ((UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
                if (!name.equals(node.getProperty("name", null))) continue;
                return;
            }
            tx.success();
        }
        Assert.fail((String)("Node " + id + " with name '" + name + "' not found"));
    }
}

