/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class Foo {
    public static void main(String[] args) {
        new Foo().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        File dir = TargetDirectory.forTest(this.getClass()).directory("test", true);
        HighlyAvailableGraphDatabase db1 = Foo.startDb(1, dir, "127.0.0.1:5001");
        HighlyAvailableGraphDatabase db2 = Foo.startDb(2, dir, "127.0.0.1:5001");
        Transaction tx = db2.beginTx();
        db2.createNode();
        tx.success();
        tx.finish();
        db2.shutdown();
        tx = db1.beginTx();
        db1.createNode();
        tx.success();
        tx.finish();
        db1.shutdown();
        db2 = Foo.startDb(2, dir, "127.0.0.1:5002");
        tx = db2.beginTx();
        db2.createNode();
        tx.success();
        tx.finish();
        tx = db2.beginTx();
        db2.createNode();
        tx.success();
        tx.finish();
        db1 = Foo.startDb(1, dir, "127.0.0.1:5002");
        boolean success = false;
        while (!success) {
            try {
                tx = db1.beginTx();
                db1.createNode();
                tx.success();
                success = true;
            }
            catch (Exception e) {
                tx.failure();
            }
            finally {
                tx.finish();
            }
        }
        db1.shutdown();
        db2.shutdown();
        System.out.println("-----> Done");
    }

    private static HighlyAvailableGraphDatabase startDb(int serverId, File path, String connectString) {
        GraphDatabaseBuilder builder = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(Foo.path(path, serverId)).setConfig(ClusterSettings.initial_hosts, connectString).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + serverId - 1)).setConfig(ClusterSettings.server_id, "" + serverId).setConfig(HaSettings.ha_server, ":" + (8001 + serverId)).setConfig(HaSettings.tx_push_factor, "0");
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)builder.newGraphDatabase();
        Transaction tx = db.beginTx();
        tx.finish();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return db;
    }

    private static String path(File path, int i) {
        return new File(path, "" + i).getAbsolutePath();
    }
}

