/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMemberMatcher;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.util.StringLogger;

public class ClusterMembersTest {
    private static InstanceId clusterId1 = new InstanceId(1);
    private static InstanceId clusterId2 = new InstanceId(2);
    private static InstanceId clusterId3 = new InstanceId(3);
    private static URI clusterUri1 = URI.create("cluster://server1");
    private static URI clusterUri2 = URI.create("cluster://server2");
    private static URI clusterUri3 = URI.create("cluster://server3");
    private static URI haUri1 = URI.create("ha://server1?serverId=" + clusterId1.toIntegerIndex());
    private static URI haUri2 = URI.create("ha://server2?serverId=" + clusterId2.toIntegerIndex());
    private static URI haUri3 = URI.create("ha://server3?serverId=" + clusterId3.toIntegerIndex());

    @Test
    public void shouldRegisterItselfOnListeners() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        new ClusterMembers(cluster, heartbeat, clusterMemberEvents, null);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)Mockito.any());
        ((Heartbeat)Mockito.verify((Object)heartbeat)).addHeartbeatListener((HeartbeatListener)Mockito.any());
        ((ClusterMemberEvents)Mockito.verify((Object)clusterMemberEvents)).addClusterMemberListener((ClusterMemberListener)Mockito.any());
    }

    @Test
    public void shouldContainMemberListAfterEnteringCluster() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, heartbeat, clusterMemberEvents, null);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId1)), ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId2)), ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId3))}));
    }

    @Test
    public void joinedMemberShowsInList() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, heartbeat, clusterMemberEvents, null);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2));
        ((ClusterListener)listener.getValue()).joinedCluster(clusterId3, clusterUri3);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId1)), ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId2)), ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId3))}));
    }

    @Test
    public void iCanGetToMyself() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, heartbeat, clusterMemberEvents, clusterId1);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2));
        ClusterMember me = members.getSelf();
        Assert.assertNotNull((Object)me);
        Assert.assertEquals((long)1L, (long)me.getInstanceId());
        Assert.assertEquals((Object)clusterId1, (Object)me.getMemberId());
    }

    @Test
    public void leftMemberDisappearsFromList() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, heartbeat, clusterMemberEvents, null);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ((ClusterListener)listener.getValue()).leftCluster(clusterId3);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId3))})));
    }

    @Test
    public void availableMasterShowsProperInformation() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, heartbeat, clusterMemberEvents, null);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor clusterMemberListener = ArgumentCaptor.forClass(ClusterMemberListener.class);
        ((ClusterMemberEvents)Mockito.verify((Object)clusterMemberEvents)).addClusterMemberListener((ClusterMemberListener)clusterMemberListener.capture());
        ((ClusterMemberListener)clusterMemberListener.getValue()).memberIsAvailable("master", clusterId1, haUri1);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId1).availableAs("master", haUri1))));
    }

    @Test
    public void availableSlaveShowsProperInformation() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, heartbeat, clusterMemberEvents, null);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor clusterMemberListener = ArgumentCaptor.forClass(ClusterMemberListener.class);
        ((ClusterMemberEvents)Mockito.verify((Object)clusterMemberEvents)).addClusterMemberListener((ClusterMemberListener)clusterMemberListener.capture());
        ((ClusterMemberListener)clusterMemberListener.getValue()).memberIsAvailable("slave", clusterId1, haUri1);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId1).availableAs("slave", haUri1))));
    }

    @Test
    public void membersShowsAsUnavailableWhenNewMasterElectedBeforeTheyBecomeAvailable() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, heartbeat, clusterMemberEvents, null);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor clusterMemberListener = ArgumentCaptor.forClass(ClusterMemberListener.class);
        ((ClusterMemberEvents)Mockito.verify((Object)clusterMemberEvents)).addClusterMemberListener((ClusterMemberListener)clusterMemberListener.capture());
        ((ClusterMemberListener)clusterMemberListener.getValue()).memberIsAvailable("slave", clusterId1, haUri1);
        ((ClusterMemberListener)clusterMemberListener.getValue()).coordinatorIsElected(clusterId2);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId1))));
    }

    @Test
    public void failedMemberShowsAsSuch() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, heartbeat, clusterMemberEvents, null);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor heartBeatListener = ArgumentCaptor.forClass(HeartbeatListener.class);
        ((Heartbeat)Mockito.verify((Object)heartbeat)).addHeartbeatListener((HeartbeatListener)heartBeatListener.capture());
        ((HeartbeatListener)heartBeatListener.getValue()).failed(clusterId1);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId1).failed())));
    }

    @Test
    public void failedThenAliveMemberShowsAsAlive() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, heartbeat, clusterMemberEvents, null);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor heartBeatListener = ArgumentCaptor.forClass(HeartbeatListener.class);
        ((Heartbeat)Mockito.verify((Object)heartbeat)).addHeartbeatListener((HeartbeatListener)heartBeatListener.capture());
        ((HeartbeatListener)heartBeatListener.getValue()).failed(clusterId1);
        ((HeartbeatListener)heartBeatListener.getValue()).alive(clusterId1);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterId1))));
    }

    private ClusterConfiguration clusterConfiguration(URI ... uris) {
        ClusterConfiguration toReturn = new ClusterConfiguration("neo4j.ha", StringLogger.SYSTEM, Arrays.asList(uris));
        toReturn.joined(clusterId1, clusterUri1);
        toReturn.joined(clusterId2, clusterUri2);
        if (uris.length == 3) {
            toReturn.joined(clusterId3, clusterUri3);
        }
        return toReturn;
    }
}

