/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.index;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.ha.BeginTx;
import org.neo4j.ha.FinishTx;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.ha.ClusterManager;

public class IndexOperationsIT
extends AbstractClusterTest {
    @Test
    public void index_modifications_are_propagated() throws Exception {
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        String key = "name";
        String value = "Mattias";
        HighlyAvailableGraphDatabase author = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long node = this.createNode(author, key, value, true);
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            ((UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
            this.assertNodeAndIndexingExists(db, node, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void index_objects_can_be_reused_after_role_switch() throws Exception {
        Transaction transaction;
        HighlyAvailableGraphDatabase db;
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        String key = "key";
        String value = "value";
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        long nodeId = this.createNode(master, key, value, true);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HashMap<HighlyAvailableGraphDatabase, IndexManager> indexManagers = new HashMap<HighlyAvailableGraphDatabase, IndexManager>();
        HashMap<HighlyAvailableGraphDatabase, Index> indexes = new HashMap<HighlyAvailableGraphDatabase, Index>();
        for (HighlyAvailableGraphDatabase highlyAvailableGraphDatabase : this.cluster.getAllMembers()) {
            Transaction transaction2 = highlyAvailableGraphDatabase.beginTx();
            try {
                indexManagers.put(highlyAvailableGraphDatabase, highlyAvailableGraphDatabase.index());
                indexes.put(highlyAvailableGraphDatabase, highlyAvailableGraphDatabase.index().forNodes(key));
                transaction2.success();
            }
            finally {
                transaction2.finish();
            }
        }
        this.cluster.shutdown(master);
        indexManagers.remove(master);
        indexes.remove(master);
        this.cluster.await(ClusterManager.masterAvailable(master));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        for (Map.Entry entry : indexManagers.entrySet()) {
            db = (HighlyAvailableGraphDatabase)entry.getKey();
            transaction = db.beginTx();
            try {
                IndexManager indexManager = (IndexManager)entry.getValue();
                Assert.assertTrue((boolean)indexManager.existsForNodes(key));
                Assert.assertEquals((long)nodeId, (long)((Node)indexManager.forNodes(key).get(key, (Object)value).getSingle()).getId());
            }
            finally {
                transaction.finish();
            }
        }
        for (Map.Entry entry : indexes.entrySet()) {
            db = (HighlyAvailableGraphDatabase)entry.getKey();
            transaction = db.beginTx();
            try {
                Index index = (Index)entry.getValue();
                Assert.assertEquals((long)nodeId, (long)((Node)index.get(key, (Object)value).getSingle()).getId());
            }
            finally {
                transaction.finish();
            }
        }
    }

    @Test
    public void put_if_absent_works_across_instances() throws Exception {
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        String key = "key";
        String value = "value";
        HighlyAvailableGraphDatabase db1 = this.cluster.getMaster();
        HighlyAvailableGraphDatabase db2 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long node = this.createNode(db1, key, value, false);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        OtherThreadExecutor w1 = new OtherThreadExecutor("w1", (Object)db1);
        OtherThreadExecutor w2 = new OtherThreadExecutor("w2", (Object)db2);
        Transaction tx1 = (Transaction)w1.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
        Transaction tx2 = (Transaction)w2.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
        Assert.assertNull((Object)w2.execute((OtherThreadExecutor.WorkerCommand)new PutIfAbsent(node, key, value)));
        Future w1Future = w1.executeDontWait((OtherThreadExecutor.WorkerCommand)new PutIfAbsent(node, key, value));
        w1.waitUntilWaiting();
        w2.execute((OtherThreadExecutor.WorkerCommand)new FinishTx(tx2, true));
        tx2.success();
        tx2.finish();
        Assert.assertNotNull(w1Future.get());
        w1.execute((OtherThreadExecutor.WorkerCommand)new FinishTx(tx1, true));
        this.assertNodeAndIndexingExists(db1, node, key, value);
        this.assertNodeAndIndexingExists(db2, node, key, value);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertNodeAndIndexingExists(this.cluster.getAnySlave(db1, db2), node, key, value);
        w2.close();
        w1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNode(HighlyAvailableGraphDatabase author, String key, Object value, boolean index) {
        Transaction tx = author.beginTx();
        try {
            Node node = author.createNode();
            node.setProperty(key, value);
            if (index) {
                author.index().forNodes(key).add((PropertyContainer)node, key, value);
            }
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNodeAndIndexingExists(HighlyAvailableGraphDatabase db, long nodeId, String key, Object value) {
        Transaction transaction = db.beginTx();
        try {
            Node node = db.getNodeById(nodeId);
            Assert.assertEquals((Object)value, (Object)node.getProperty(key));
            Assert.assertTrue((boolean)db.index().existsForNodes(key));
            Assert.assertEquals((Object)node, (Object)db.index().forNodes(key).get(key, value).getSingle());
        }
        finally {
            transaction.finish();
        }
    }

    private static class PutIfAbsent
    implements OtherThreadExecutor.WorkerCommand<HighlyAvailableGraphDatabase, Node> {
        private final long node;
        private final String key;
        private final String value;

        public PutIfAbsent(long node, String key, String value) {
            this.node = node;
            this.key = key;
            this.value = value;
        }

        public Node doWork(HighlyAvailableGraphDatabase state) {
            return (Node)state.index().forNodes(this.key).putIfAbsent((PropertyContainer)state.getNodeById(this.node), this.key, (Object)this.value);
        }
    }
}

