/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;

public class HighlyAvailableGraphDatabaseFactory
extends GraphDatabaseFactory {
    public GraphDatabaseService newHighlyAvailableDatabase(String path) {
        return this.newEmbeddedDatabaseBuilder(path).newGraphDatabase();
    }

    public GraphDatabaseBuilder newHighlyAvailableDatabaseBuilder(final String path) {
        final GraphDatabaseFactoryState state = this.getStateCopy();
        return new GraphDatabaseBuilder(new GraphDatabaseBuilder.DatabaseCreator(){

            public GraphDatabaseService newDatabase(Map<String, String> config) {
                config.put("ephemeral", "false");
                return new HighlyAvailableGraphDatabase(path, config, state.getKernelExtension(), (Iterable<CacheProvider>)state.getCacheProviders(), (Iterable<TransactionInterceptorProvider>)state.getTransactionInterceptorProviders());
            }
        });
    }
}

