/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreId;

public class NeoStoreUtil {
    private final long creationTime;
    private final long randomId;
    private final long txId;
    private final long logVersion;
    private final long storeVersion;
    private final long firstGraphProp;
    private File file;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Supply one argument which is the store directory of a neo4j graph database");
            System.exit(1);
        }
        System.out.println(new NeoStoreUtil(new File(args[0])));
    }

    public NeoStoreUtil(File storeDir) {
        RandomAccessFile randomAccessFile = null;
        try {
            this.file = NeoStoreUtil.neoStoreFile(storeDir);
            randomAccessFile = new RandomAccessFile(this.file, "r");
            FileChannel fileChannel = randomAccessFile.getChannel();
            int recordsToRead = 6;
            ByteBuffer buf = ByteBuffer.allocate(recordsToRead * 9);
            if (fileChannel.read(buf) != recordsToRead * 9) {
                throw new RuntimeException("Unable to read neo store header information");
            }
            buf.flip();
            this.creationTime = this.nextRecord(buf);
            this.randomId = this.nextRecord(buf);
            this.logVersion = this.nextRecord(buf);
            this.txId = this.nextRecord(buf);
            this.storeVersion = this.nextRecord(buf);
            this.firstGraphProp = this.nextRecord(buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private long nextRecord(ByteBuffer buf) {
        buf.get();
        return buf.getLong();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getStoreId() {
        return this.randomId;
    }

    public long getLastCommittedTx() {
        return this.txId;
    }

    public long getLogVersion() {
        return this.logVersion;
    }

    public long getStoreVersion() {
        return this.storeVersion;
    }

    public StoreId asStoreId() {
        return new StoreId(this.creationTime, this.randomId, this.storeVersion);
    }

    public String toString() {
        return String.format("Neostore contents of " + this.file + ":%n" + "0: creation time: %s%n" + "1: random id: %s%n" + "2: log version: %s%n" + "3: tx id: %s%n" + "4: store version: %s%n" + "5: first graph prop: %s%n" + " => store id: %s", this.creationTime, this.randomId, this.logVersion, this.txId, this.storeVersion, this.firstGraphProp, new StoreId(this.creationTime, this.randomId, this.storeVersion));
    }

    public static boolean storeExists(File storeDir) {
        return NeoStoreUtil.neoStoreFile(storeDir).exists();
    }

    private static File neoStoreFile(File storeDir) {
        return new File(storeDir, "neostore");
    }
}

