/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToFileStoreWriter;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.logging.ConsoleLogger;

public class SlaveStoreWriter {
    public static final String COPY_FROM_MASTER_TEMP = "temp-copy";
    private final Config config;
    private final Iterable<KernelExtensionFactory<?>> kernelExtensions;
    private final ConsoleLogger console;
    private final FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();

    public SlaveStoreWriter(Config config, Iterable<KernelExtensionFactory<?>> kernelExtensions, ConsoleLogger console) {
        this.config = config;
        this.kernelExtensions = kernelExtensions;
        this.console = console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStore(Master master) throws IOException {
        File storeDir = (File)this.config.get(InternalAbstractGraphDatabase.Configuration.store_dir);
        File tempStore = new File(storeDir, COPY_FROM_MASTER_TEMP);
        if (!tempStore.mkdir()) {
            FileUtils.deleteRecursively((File)tempStore);
            tempStore.mkdir();
        }
        Response<Void> response = master.copyStore(new RequestContext(0L, ((Integer)this.config.get(ClusterSettings.server_id)).intValue(), 0, new RequestContext.Tx[0], 0, 0L), this.decorateWithProgressIndicator((StoreWriter)new ToFileStoreWriter(tempStore)));
        long highestLogVersion = XaLogicalLog.getHighestHistoryLogVersion((FileSystemAbstraction)this.fileSystem, (File)tempStore, (String)"nioneo_logical.log");
        if (highestLogVersion > -1L) {
            NeoStore.setVersion((FileSystemAbstraction)this.fileSystem, (File)new File(tempStore, "neostore"), (long)(highestLogVersion + 1L));
        }
        GraphDatabaseAPI copiedDb = (GraphDatabaseAPI)new GraphDatabaseFactory().setKernelExtensions(this.kernelExtensions).newEmbeddedDatabaseBuilder(tempStore.getAbsolutePath()).setConfig(GraphDatabaseSettings.keep_logical_logs, "true").setConfig(GraphDatabaseSettings.allow_store_upgrade, ((Boolean)this.config.get(GraphDatabaseSettings.allow_store_upgrade)).toString()).newGraphDatabase();
        try {
            ServerUtil.applyReceivedTransactions(response, (XaDataSourceManager)((XaDataSourceManager)copiedDb.getDependencyResolver().resolveDependency(XaDataSourceManager.class)), (ServerUtil.TxHandler)ServerUtil.txHandlerForFullCopy());
        }
        finally {
            copiedDb.shutdown();
            response.close();
        }
        for (File candidate : tempStore.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().startsWith("metrics") && !file.getName().equals("messages.log") && !"active_tx_log tm_tx_log.1 tm_tx_log.2".contains(file.getName());
            }
        })) {
            FileUtils.moveFileToDirectory((File)candidate, (File)storeDir);
        }
    }

    private StoreWriter decorateWithProgressIndicator(final StoreWriter actual) {
        return new StoreWriter(){
            private int totalFiles;

            public int write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
                SlaveStoreWriter.this.console.log("Copying " + path);
                int written = actual.write(path, data, temporaryBuffer, hasData);
                SlaveStoreWriter.this.console.log("Copied  " + path + " " + Format.bytes((long)written));
                ++this.totalFiles;
                return written;
            }

            public void done() {
                actual.done();
                SlaveStoreWriter.this.console.log("Done, copied " + this.totalFiles + " files");
            }
        };
    }
}

