/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.cluster.HighAvailability;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public abstract class AbstractModeSwitcher<T>
implements Lifecycle {
    private final DelegateInvocationHandler<T> delegate;
    private LifeSupport life;
    private final HighAvailability highAvailability;
    private DelegateStateSwitcher delegateStateSwitcher;

    protected AbstractModeSwitcher(HighAvailability highAvailability, DelegateInvocationHandler<T> delegate) {
        this.delegate = delegate;
        this.life = new LifeSupport();
        this.highAvailability = highAvailability;
        this.delegateStateSwitcher = new DelegateStateSwitcher();
        highAvailability.addHighAvailabilityMemberListener(this.delegateStateSwitcher);
    }

    public void init() throws Throwable {
        this.life.init();
    }

    public void start() throws Throwable {
        this.life.start();
    }

    public void stop() throws Throwable {
        this.life.stop();
        this.highAvailability.removeHighAvailabilityMemberListener(this.delegateStateSwitcher);
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    protected abstract T getSlaveImpl(URI var1);

    protected abstract T getMasterImpl();

    private class DelegateStateSwitcher
    implements HighAvailabilityMemberListener {
        private T current = null;

        private DelegateStateSwitcher() {
        }

        @Override
        public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
            this.stateChanged(event);
        }

        @Override
        public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
            this.stateChanged(event);
        }

        @Override
        public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
        }

        @Override
        public void instanceStops(HighAvailabilityMemberChangeEvent event) {
            this.stateChanged(event);
        }

        private void stateChanged(HighAvailabilityMemberChangeEvent event) {
            if (event.getNewState() == event.getOldState()) {
                return;
            }
            switch (event.getNewState()) {
                case TO_MASTER: {
                    this.shutdownCurrent();
                    this.current = AbstractModeSwitcher.this.life.add(AbstractModeSwitcher.this.getMasterImpl());
                    AbstractModeSwitcher.this.delegate.setDelegate(this.current);
                    AbstractModeSwitcher.this.life.start();
                    break;
                }
                case TO_SLAVE: {
                    this.shutdownCurrent();
                    this.current = AbstractModeSwitcher.this.life.add(AbstractModeSwitcher.this.getSlaveImpl(event.getServerHaUri()));
                    AbstractModeSwitcher.this.delegate.setDelegate(this.current);
                    AbstractModeSwitcher.this.life.start();
                    break;
                }
                case PENDING: {
                    this.shutdownCurrent();
                }
            }
        }

        private void shutdownCurrent() {
            if (this.current != null) {
                AbstractModeSwitcher.this.life.shutdown();
                AbstractModeSwitcher.this.life = new LifeSupport();
            }
        }
    }
}

