/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.TransactionManager;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.ServerUtil;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.Uris;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchDetectingTxVerifier;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.SlaveStoreWriter;
import org.neo4j.kernel.ha.StoreOutOfDateException;
import org.neo4j.kernel.ha.StoreUnableToParticipateInClusterException;
import org.neo4j.kernel.ha.cluster.DefaultMasterImplSPI;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveImpl;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class HighAvailabilityModeSwitcher
implements HighAvailabilityMemberListener,
Lifecycle {
    private static final Class[] SERVICES_TO_RESTART_FOR_STORE_COPY = new Class[]{StoreLockerLifecycleAdapter.class, XaDataSourceManager.class, TransactionManager.class, NodeManager.class, IndexStore.class};
    public static final String MASTER = "master";
    public static final String SLAVE = "slave";
    private URI masterHaURI;
    public static final String INADDR_ANY = "0.0.0.0";
    private URI slaveHaURI;
    private BindingListener bindingListener;
    private URI availableMasterId;
    private final HighAvailabilityMemberStateMachine stateHandler;
    private final BindingNotifier bindingNotifier;
    private final DelegateInvocationHandler<Master> masterDelegateHandler;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final GraphDatabaseAPI graphDb;
    private final Config config;
    private LifeSupport haCommunicationLife;
    private final StringLogger msgLog;
    private final ConsoleLogger console;
    private final HaIdGeneratorFactory idGeneratorFactory;
    private final Logging logging;
    private final UpdateableSchemaState updateableSchemaState;
    private final Iterable<KernelExtensionFactory<?>> kernelExtensions;
    private final Monitors monitors;
    private final RequestContextFactory requestContextFactory;
    private MasterClientResolver masterClientResolver;
    private ScheduledExecutorService scheduledExecutorService;
    private volatile URI me;

    public static int getServerId(URI haUri) {
        return (Integer)Settings.INTEGER.apply(Functions.withDefaults((Function)Functions.constant((Object)"-1"), (Function)Uris.parameter((String)"serverId")).apply((Object)haUri));
    }

    public HighAvailabilityModeSwitcher(BindingNotifier bindingNotifier, DelegateInvocationHandler<Master> delegateHandler, ClusterMemberAvailability clusterMemberAvailability, HighAvailabilityMemberStateMachine stateHandler, GraphDatabaseAPI graphDb, HaIdGeneratorFactory idGeneratorFactory, Config config, Logging logging, UpdateableSchemaState updateableSchemaState, Iterable<KernelExtensionFactory<?>> kernelExtensions, Monitors monitors, RequestContextFactory requestContextFactory) {
        this.bindingNotifier = bindingNotifier;
        this.masterDelegateHandler = delegateHandler;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.graphDb = graphDb;
        this.idGeneratorFactory = idGeneratorFactory;
        this.config = config;
        this.logging = logging;
        this.updateableSchemaState = updateableSchemaState;
        this.kernelExtensions = kernelExtensions;
        this.monitors = monitors;
        this.requestContextFactory = requestContextFactory;
        this.msgLog = logging.getMessagesLog(this.getClass());
        this.haCommunicationLife = new LifeSupport();
        this.stateHandler = stateHandler;
        this.console = logging.getConsoleLog(this.getClass());
    }

    public synchronized void init() throws Throwable {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.stateHandler.addHighAvailabilityMemberListener(this);
        this.bindingListener = new BindingListener(){

            public void listeningAt(URI myUri) {
                HighAvailabilityModeSwitcher.this.me = myUri;
            }
        };
        this.bindingNotifier.addBindingListener(this.bindingListener);
        this.haCommunicationLife.init();
    }

    public synchronized void start() throws Throwable {
        this.haCommunicationLife.start();
    }

    public synchronized void stop() throws Throwable {
        this.haCommunicationLife.stop();
    }

    public synchronized void shutdown() throws Throwable {
        this.stateHandler.removeHighAvailabilityMemberListener(this);
        this.bindingNotifier.removeBindingListener(this.bindingListener);
        this.scheduledExecutorService.shutdown();
        this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS);
        this.haCommunicationLife.shutdown();
    }

    @Override
    public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
        if (event.getNewState() == event.getOldState() && event.getOldState() == HighAvailabilityMemberState.MASTER) {
            this.clusterMemberAvailability.memberIsAvailable(MASTER, this.masterHaURI);
        } else {
            this.stateChanged(event);
        }
    }

    @Override
    public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
        if (event.getNewState() == event.getOldState() && event.getOldState() == HighAvailabilityMemberState.SLAVE) {
            this.clusterMemberAvailability.memberIsAvailable(SLAVE, this.slaveHaURI);
        } else {
            this.stateChanged(event);
        }
    }

    @Override
    public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
    }

    @Override
    public void instanceStops(HighAvailabilityMemberChangeEvent event) {
        this.stateChanged(event);
    }

    private void stateChanged(HighAvailabilityMemberChangeEvent event) {
        this.availableMasterId = event.getServerHaUri();
        if (event.getNewState() == event.getOldState()) {
            return;
        }
        switch (event.getNewState()) {
            case TO_MASTER: {
                this.haCommunicationLife.shutdown();
                this.haCommunicationLife = new LifeSupport();
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                }
                this.switchToMaster();
                break;
            }
            case TO_SLAVE: {
                this.haCommunicationLife.shutdown();
                this.switchToSlave();
                break;
            }
            case PENDING: {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                } else if (event.getOldState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.clusterMemberAvailability.memberIsUnavailable(MASTER);
                }
                this.haCommunicationLife.shutdown();
                this.haCommunicationLife = new LifeSupport();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchToMaster() {
        this.msgLog.logMessage("I am " + this.config.get(ClusterSettings.server_id) + ", moving to master");
        try {
            HaXaDataSourceManager xaDataSourceManager;
            DependencyResolver resolver = this.graphDb.getDependencyResolver();
            HaXaDataSourceManager haXaDataSourceManager = xaDataSourceManager = (HaXaDataSourceManager)((Object)resolver.resolveDependency(HaXaDataSourceManager.class));
            synchronized (haXaDataSourceManager) {
                TransactionManager txManager = (TransactionManager)this.graphDb.getDependencyResolver().resolveDependency(TransactionManager.class);
                this.idGeneratorFactory.switchToMaster();
                DefaultMasterImplSPI spi = new DefaultMasterImplSPI(this.graphDb, this.logging, txManager);
                MasterImpl masterImpl = new MasterImpl(spi, (MasterImpl.Monitor)this.monitors.newMonitor(MasterImpl.Monitor.class, new String[0]), this.logging, this.config);
                MasterServer masterServer = new MasterServer(masterImpl, this.logging, this.serverConfig(), new BranchDetectingTxVerifier(this.graphDb), (Monitors)this.graphDb.getDependencyResolver().resolveDependency(Monitors.class));
                this.haCommunicationLife.add((Object)masterImpl);
                this.haCommunicationLife.add((Object)masterServer);
                this.assignMaster(masterImpl);
                this.idGeneratorFactory.switchToMaster();
                this.haCommunicationLife.start();
                this.masterHaURI = URI.create("ha://" + (ServerUtil.getHostString((InetSocketAddress)masterServer.getSocketAddress()).contains(INADDR_ANY) ? this.me.getHost() : ServerUtil.getHostString((InetSocketAddress)masterServer.getSocketAddress())) + ":" + masterServer.getSocketAddress().getPort() + "?serverId=" + this.config.get(ClusterSettings.server_id));
                this.clusterMemberAvailability.memberIsAvailable(MASTER, this.masterHaURI);
                this.msgLog.logMessage("I am " + this.config.get(ClusterSettings.server_id) + ", successfully moved to master");
            }
        }
        catch (Throwable e) {
            this.msgLog.logMessage("Failed to switch to master", e);
        }
    }

    private void assignMaster(Master master) {
        this.masterDelegateHandler.setDelegate(master);
    }

    private URI createHaURI(Server<?, ?> server) {
        String hostString = ServerUtil.getHostString((InetSocketAddress)server.getSocketAddress());
        int port = server.getSocketAddress().getPort();
        Integer serverId = (Integer)this.config.get(ClusterSettings.server_id);
        String host = hostString.contains(INADDR_ANY) ? this.me.getHost() : hostString;
        return URI.create("ha://" + host + ":" + port + "?serverId=" + serverId);
    }

    private void switchToSlave() {
        this.masterClientResolver = new MasterClientResolver(this.logging, ((Long)this.config.get(HaSettings.read_timeout)).intValue(), ((Long)this.config.get(HaSettings.lock_read_timeout)).intValue(), (Integer)this.config.get(HaSettings.max_concurrent_channels_per_slave), ((Long)this.config.get(HaSettings.com_chunk_size)).intValue());
        final AtomicLong wait = new AtomicLong();
        this.scheduledExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (HighAvailabilityModeSwitcher.this.haCommunicationLife.getStatus() == LifecycleStatus.STARTED) {
                    return;
                }
                try {
                    HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
                    URI masterUri = HighAvailabilityModeSwitcher.this.availableMasterId;
                    HighAvailabilityModeSwitcher.this.console.log("ServerId " + HighAvailabilityModeSwitcher.this.config.get(ClusterSettings.server_id) + ", moving to slave for master " + masterUri);
                    assert (masterUri != null);
                    DependencyResolver resolver = HighAvailabilityModeSwitcher.this.graphDb.getDependencyResolver();
                    HaXaDataSourceManager xaDataSourceManager = (HaXaDataSourceManager)((Object)resolver.resolveDependency(HaXaDataSourceManager.class));
                    HighAvailabilityModeSwitcher.this.idGeneratorFactory.switchToSlave();
                    HaXaDataSourceManager haXaDataSourceManager = xaDataSourceManager;
                    synchronized (haXaDataSourceManager) {
                        if (!NeoStore.isStorePresent((FileSystemAbstraction)((FileSystemAbstraction)resolver.resolveDependency(FileSystemAbstraction.class)), (Config)HighAvailabilityModeSwitcher.this.config)) {
                            HighAvailabilityModeSwitcher.this.copyStoreFromMaster(masterUri);
                        }
                        NeoStoreXaDataSource nioneoDataSource = HighAvailabilityModeSwitcher.this.ensureDataSourceStarted(xaDataSourceManager, resolver);
                        if (HighAvailabilityModeSwitcher.this.checkDataConsistency(xaDataSourceManager, (RequestContextFactory)resolver.resolveDependency(RequestContextFactory.class), nioneoDataSource, masterUri) && HighAvailabilityModeSwitcher.this.startHaCommunication(xaDataSourceManager, nioneoDataSource, masterUri)) {
                            HighAvailabilityModeSwitcher.this.console.log("ServerId " + HighAvailabilityModeSwitcher.this.config.get(ClusterSettings.server_id) + ", successfully moved to slave for master " + masterUri);
                            return;
                        }
                    }
                }
                catch (Throwable t) {
                    HighAvailabilityModeSwitcher.this.msgLog.logMessage("Error while trying to switch to slave", t);
                }
                HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                wait.set(1L + wait.get() * 2L);
                wait.set(Math.min(wait.get(), 300L));
                HighAvailabilityModeSwitcher.this.scheduledExecutorService.schedule(this, wait.get(), TimeUnit.SECONDS);
                HighAvailabilityModeSwitcher.this.msgLog.logMessage("Attempting to switch to slave in " + wait.get() + "s");
            }
        }, wait.get(), TimeUnit.SECONDS);
    }

    private boolean startHaCommunication(HaXaDataSourceManager xaDataSourceManager, NeoStoreXaDataSource nioneoDataSource, URI masterUri) {
        try {
            MasterClient master = this.newMasterClient(masterUri, nioneoDataSource.getStoreId(), this.haCommunicationLife);
            SlaveImpl slaveImpl = new SlaveImpl(nioneoDataSource.getStoreId(), master, new RequestContextFactory(HighAvailabilityModeSwitcher.getServerId(masterUri), xaDataSourceManager, this.graphDb.getDependencyResolver()), xaDataSourceManager);
            SlaveServer server = new SlaveServer(slaveImpl, this.serverConfig(), this.logging, (Monitors)this.graphDb.getDependencyResolver().resolveDependency(Monitors.class));
            this.assignMaster(master);
            this.haCommunicationLife.add((Object)slaveImpl);
            this.haCommunicationLife.add((Object)server);
            this.haCommunicationLife.start();
            this.slaveHaURI = this.createHaURI(server);
            this.clusterMemberAvailability.memberIsAvailable(SLAVE, this.slaveHaURI);
            return true;
        }
        catch (Throwable t) {
            this.msgLog.logMessage("Got exception while starting HA communication", t);
            this.haCommunicationLife.shutdown();
            this.haCommunicationLife = new LifeSupport();
            return false;
        }
    }

    private Server.Configuration serverConfig() {
        return new Server.Configuration(){

            public long getOldChannelThreshold() {
                return (Long)HighAvailabilityModeSwitcher.this.config.get(HaSettings.lock_read_timeout);
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)HighAvailabilityModeSwitcher.this.config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)HighAvailabilityModeSwitcher.this.config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)HighAvailabilityModeSwitcher.this.config.get(HaSettings.ha_server);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDataConsistency(HaXaDataSourceManager xaDataSourceManager, RequestContextFactory requestContextFactory, NeoStoreXaDataSource nioneoDataSource, URI masterUri) throws Throwable {
        block12: {
            LifeSupport checkConsistencyLife = new LifeSupport();
            try {
                MasterClient checkConsistencyMaster = this.newMasterClient(masterUri, nioneoDataSource.getStoreId(), checkConsistencyLife);
                checkConsistencyLife.start();
                this.console.log("Checking store consistency with master");
                this.checkDataConsistencyWithMaster(checkConsistencyMaster, nioneoDataSource);
                this.console.log("Store is consistent");
                this.console.log("Catching up with master");
                RequestContext context = requestContextFactory.newRequestContext(-1);
                xaDataSourceManager.applyTransactions(checkConsistencyMaster.pullUpdates(context));
                this.console.log("Now consistent with master");
                boolean bl = true;
                return bl;
            }
            catch (StoreUnableToParticipateInClusterException upe) {
                this.console.log("The store is inconsistent. Will treat it as branched and fetch a new one from the master");
                this.msgLog.warn("Current store is unable to participate in the cluster; fetching new store from master", (Throwable)upe);
                try {
                    xaDataSourceManager.unregisterDataSource("nioneodb");
                    this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)));
                }
                catch (IOException e) {
                    this.msgLog.warn("Failed while trying to handle branched data", (Throwable)e);
                }
            }
            catch (MismatchingStoreIdException e) {
                this.console.log("The store does not represent the same database as master. Will remove and fetch a new one from master");
                if (nioneoDataSource.getNeoStore().getLastCommittedTx() == 1L) {
                    this.msgLog.warn("Found and deleting empty store with mismatching store id " + e.getMessage());
                    this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
                    break block12;
                }
                this.msgLog.error("Store cannot participate in cluster due to mismatching store IDs");
                throw e;
            }
            catch (Throwable throwable) {
                this.msgLog.warn("Consistency checker failed", throwable);
            }
            finally {
                checkConsistencyLife.shutdown();
            }
        }
        return false;
    }

    private NeoStoreXaDataSource ensureDataSourceStarted(XaDataSourceManager xaDataSourceManager, DependencyResolver resolver) {
        NeoStoreXaDataSource nioneoDataSource = (NeoStoreXaDataSource)xaDataSourceManager.getXaDataSource("nioneodb");
        if (nioneoDataSource == null) {
            nioneoDataSource = new NeoStoreXaDataSource(this.config, (StoreFactory)resolver.resolveDependency(StoreFactory.class), (StringLogger)resolver.resolveDependency(StringLogger.class), (XaFactory)resolver.resolveDependency(XaFactory.class), (TransactionStateFactory)resolver.resolveDependency(TransactionStateFactory.class), (TransactionInterceptorProviders)resolver.resolveDependency(TransactionInterceptorProviders.class), (JobScheduler)resolver.resolveDependency(JobScheduler.class), this.logging, this.updateableSchemaState, (TokenNameLookup)new NonTransactionalTokenNameLookup((LabelTokenHolder)resolver.resolveDependency(LabelTokenHolder.class), (PropertyKeyTokenHolder)resolver.resolveDependency(PropertyKeyTokenHolder.class)), resolver, (AbstractTransactionManager)resolver.resolveDependency(AbstractTransactionManager.class), (PropertyKeyTokenHolder)resolver.resolveDependency(PropertyKeyTokenHolder.class), (LabelTokenHolder)resolver.resolveDependency(LabelTokenHolder.class), (RelationshipTypeTokenHolder)resolver.resolveDependency(RelationshipTypeTokenHolder.class), (PersistenceManager)resolver.resolveDependency(PersistenceManager.class), (LockManager)resolver.resolveDependency(LockManager.class), (SchemaWriteGuard)this.graphDb, (TransactionEventHandlers)resolver.resolveDependency(TransactionEventHandlers.class));
            xaDataSourceManager.registerDataSource((XaDataSource)nioneoDataSource);
            ((NodeManager)resolver.resolveDependency(NodeManager.class)).start();
        }
        return nioneoDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMaster(URI masterUri) throws Throwable {
        LifeSupport life = new LifeSupport();
        try {
            this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
            MasterClient copyMaster = this.newMasterClient(masterUri, null, life);
            life.start();
            this.console.log("Copying store from master");
            new SlaveStoreWriter(this.config, this.kernelExtensions, this.console).copyStore(copyMaster);
            this.startServicesAgain();
            this.console.log("Finished copying store from master");
        }
        finally {
            life.stop();
        }
    }

    private MasterClient newMasterClient(URI masterUri, StoreId storeId, LifeSupport life) {
        return this.masterClientResolver.instantiate(masterUri.getHost(), masterUri.getPort(), (Monitors)this.graphDb.getDependencyResolver().resolveDependency(Monitors.class), storeId, life);
    }

    private void startServicesAgain() throws Throwable {
        ArrayList<Class> services = new ArrayList<Class>(Arrays.asList(SERVICES_TO_RESTART_FOR_STORE_COPY));
        for (Class serviceClass : services) {
            Lifecycle service = (Lifecycle)this.graphDb.getDependencyResolver().resolveDependency(serviceClass);
            service.start();
        }
    }

    private void stopServicesAndHandleBranchedStore(BranchedDataPolicy branchPolicy) throws Throwable {
        ArrayList<Class> services = new ArrayList<Class>(Arrays.asList(SERVICES_TO_RESTART_FOR_STORE_COPY));
        Collections.reverse(services);
        for (Class serviceClass : services) {
            Lifecycle service = (Lifecycle)this.graphDb.getDependencyResolver().resolveDependency(serviceClass);
            service.stop();
        }
        branchPolicy.handle((File)this.config.get(InternalAbstractGraphDatabase.Configuration.store_dir));
    }

    private void checkDataConsistencyWithMaster(Master master, NeoStoreXaDataSource nioneoDataSource) {
        HandshakeResult handshake;
        Pair myMaster;
        long myLastCommittedTx = nioneoDataSource.getLastCommittedTxId();
        try {
            myMaster = nioneoDataSource.getMasterForCommittedTx(myLastCommittedTx);
        }
        catch (NoSuchLogVersionException e) {
            this.msgLog.logMessage("Logical log file for txId " + myLastCommittedTx + " missing [version=" + e.getVersion() + "]. If this is startup then it will be recovered later, " + "otherwise it might be a problem.");
            return;
        }
        catch (IOException e) {
            this.msgLog.logMessage("Failed to get master ID for txId " + myLastCommittedTx + ".", (Throwable)e);
            return;
        }
        catch (Exception e) {
            throw new BranchedDataException("Exception while getting master ID for txId " + myLastCommittedTx + ".", e);
        }
        try (Response<HandshakeResult> response = master.handshake(myLastCommittedTx, nioneoDataSource.getStoreId());){
            handshake = (HandshakeResult)response.response();
            this.requestContextFactory.setEpoch(handshake.epoch());
        }
        catch (BranchedDataException e) {
            throw new BranchedDataException("Master detected branched data for this machine.", e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MissingLogDataException) {
                throw new StoreOutOfDateException("The master is missing the log required to complete the consistency check", e.getCause());
            }
            throw e;
        }
        if ((Integer)myMaster.first() != -1 && (((Integer)myMaster.first()).intValue() != handshake.txAuthor() || ((Long)myMaster.other()).longValue() != handshake.txChecksum())) {
            String msg = "Branched data, I (machineId:" + this.config.get(ClusterSettings.server_id) + ") think machineId for" + " txId (" + myLastCommittedTx + ") is " + myMaster + ", but master (machineId:" + HighAvailabilityModeSwitcher.getServerId(this.availableMasterId) + ") says that it's " + handshake;
            throw new BranchedDataException(msg);
        }
        this.msgLog.logMessage("Master id for last committed tx ok with highestTxId=" + myLastCommittedTx + " with masterId=" + myMaster, true);
    }
}

