/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.slave;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.com.MismatchingVersionHandler;
import org.neo4j.kernel.ha.MasterClient20;
import org.neo4j.kernel.ha.MasterClient201;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class MasterClientResolver
implements MasterClientFactory,
MismatchingVersionHandler {
    private volatile MasterClientFactory currentFactory;
    private volatile ProtocolVersionCombo currentVersion;
    private boolean downgradeForbidden = false;
    private final Map<ProtocolVersionCombo, MasterClientFactory> protocolToFactoryMapping = new HashMap<ProtocolVersionCombo, MasterClientFactory>();

    @Override
    public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId, LifeSupport life) {
        if (this.currentFactory == null) {
            this.assignDefaultFactory();
        }
        MasterClient result = this.currentFactory.instantiate(hostNameOrIp, port, monitors, storeId, life);
        result.addMismatchingVersionHandler(this);
        return result;
    }

    public void versionMismatched(int expected, int received) {
        this.getFor(received, 2);
    }

    public MasterClientResolver(Logging logging, int readTimeout, int lockReadTimeout, int channels, int chunkSize) {
        this.protocolToFactoryMapping.put(ProtocolVersionCombo.PC_20, new F20(logging, readTimeout, lockReadTimeout, channels, chunkSize));
        this.protocolToFactoryMapping.put(ProtocolVersionCombo.PC_201, new F201(logging, readTimeout, lockReadTimeout, channels, chunkSize));
    }

    public MasterClientFactory getFor(int applicationProtocol, int internalProtocol) {
        ProtocolVersionCombo incomingCombo = new ProtocolVersionCombo(applicationProtocol, internalProtocol);
        MasterClientFactory candidate = this.protocolToFactoryMapping.get(incomingCombo);
        if (!(candidate == null || this.currentVersion != null && this.downgradeForbidden && this.currentVersion.compareTo(incomingCombo) > 0)) {
            this.currentFactory = candidate;
            this.currentVersion = incomingCombo;
        }
        return candidate;
    }

    public MasterClientFactory assignDefaultFactory() {
        return this.getFor(ProtocolVersionCombo.PC_201.applicationProtocol, ProtocolVersionCombo.PC_201.internalProtocol);
    }

    public void enableDowngradeBarrier() {
        this.downgradeForbidden = true;
    }

    public static final class F201
    extends StaticMasterClientFactory {
        public F201(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logging, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId, LifeSupport life) {
            return (MasterClient)life.add((Object)new MasterClient201(hostNameOrIp, port, this.logging, monitors, storeId, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize));
        }
    }

    public static final class F20
    extends StaticMasterClientFactory {
        public F20(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logging, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, Monitors monitors, StoreId storeId, LifeSupport life) {
            return (MasterClient)life.add((Object)new MasterClient20(hostNameOrIp, port, this.logging, monitors, storeId, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize));
        }
    }

    protected static abstract class StaticMasterClientFactory
    implements MasterClientFactory {
        protected final Logging logging;
        protected final int readTimeoutSeconds;
        protected final int lockReadTimeout;
        protected final int maxConcurrentChannels;
        protected final int chunkSize;

        StaticMasterClientFactory(Logging logging, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            this.logging = logging;
            this.readTimeoutSeconds = readTimeoutSeconds;
            this.lockReadTimeout = lockReadTimeout;
            this.maxConcurrentChannels = maxConcurrentChannels;
            this.chunkSize = chunkSize;
        }
    }

    private static final class ProtocolVersionCombo
    implements Comparable<ProtocolVersionCombo> {
        final int applicationProtocol;
        final int internalProtocol;
        static final ProtocolVersionCombo PC_20 = new ProtocolVersionCombo(5, 2);
        static final ProtocolVersionCombo PC_201 = new ProtocolVersionCombo(6, 2);

        ProtocolVersionCombo(int applicationProtocol, int internalProtocol) {
            this.applicationProtocol = applicationProtocol;
            this.internalProtocol = internalProtocol;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ProtocolVersionCombo.class) {
                return false;
            }
            ProtocolVersionCombo other = (ProtocolVersionCombo)obj;
            return other.applicationProtocol == this.applicationProtocol && other.internalProtocol == this.internalProtocol;
        }

        public int hashCode() {
            return 31 * this.applicationProtocol | this.internalProtocol;
        }

        @Override
        public int compareTo(ProtocolVersionCombo o) {
            return this.applicationProtocol < o.applicationProtocol ? -1 : (this.applicationProtocol == o.applicationProtocol ? 0 : 1);
        }
    }
}

